/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import dev.cerbos.api.v1.effect.EffectOuterClass;
import dev.cerbos.api.v1.response.Response;
import dev.cerbos.api.v1.schema.SchemaOuterClass;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class CheckResult {
    private final Response.CheckResourcesResponse.ResultEntry entry;

    CheckResult(Response.CheckResourcesResponse.ResultEntry entry) {
        this.entry = entry;
    }

    public boolean isAllowed(String action) {
        if (this.entry == null) {
            return false;
        }
        return this.entry.getActionsMap().getOrDefault(action, EffectOuterClass.Effect.EFFECT_DENY) == EffectOuterClass.Effect.EFFECT_ALLOW;
    }

    public Map<String, Boolean> getAll() {
        if (this.entry == null) {
            return Collections.emptyMap();
        }
        return this.entry.getActionsMap().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> e.getValue() == EffectOuterClass.Effect.EFFECT_ALLOW));
    }

    public boolean hasValidationErrors() {
        if (this.entry == null) {
            return false;
        }
        return this.entry.getValidationErrorsCount() > 0;
    }

    public List<SchemaOuterClass.ValidationError> getValidationErrors() {
        if (this.entry == null) {
            return Collections.emptyList();
        }
        return this.entry.getValidationErrorsList();
    }

    public Optional<Response.CheckResourcesResponse.ResultEntry> getRaw() {
        return Optional.ofNullable(this.entry);
    }
}

