/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import dev.cerbos.api.v1.response.Response;
import dev.cerbos.sdk.CheckResult;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class CheckResourcesResult {
    private final Response.CheckResourcesResponse resp;

    CheckResourcesResult(Response.CheckResourcesResponse resp) {
        this.resp = resp;
    }

    public Stream<CheckResult> results() {
        return this.resp.getResultsList().stream().map(CheckResult::new);
    }

    public Optional<CheckResult> find(String resourceID) {
        return this.find(resourceID, null);
    }

    public Optional<CheckResult> find(String resourceID, Predicate<Response.CheckResourcesResponse.ResultEntry.Resource> predicate) {
        return this.resp.getResultsList().stream().filter(re -> {
            if (!re.getResource().getId().equals(resourceID)) {
                return false;
            }
            if (predicate != null) {
                return predicate.test(re.getResource());
            }
            return true;
        }).map(CheckResult::new).findFirst();
    }

    public boolean hasValidationErrors() {
        return this.resp.getResultsList().stream().anyMatch(re -> re.getValidationErrorsCount() > 0);
    }

    public Response.CheckResourcesResponse getRaw() {
        return this.resp;
    }
}

