/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import dev.cerbos.sdk.AdminApiCredentials;
import dev.cerbos.sdk.CerbosBlockingAdminClient;
import dev.cerbos.sdk.CerbosBlockingClient;
import dev.cerbos.sdk.PlaygroundInstanceCredentials;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.InputStream;
import java.time.Duration;

public class CerbosClientBuilder {
    private final String target;
    private boolean plaintext;
    private boolean insecure;
    private String authority;
    private InputStream caCertificate;
    private InputStream tlsCertificate;
    private InputStream tlsKey;
    private String playgroundInstance;
    private long timeoutMillis = 1000L;

    public CerbosClientBuilder(String target) {
        this.target = target;
    }

    public CerbosClientBuilder withPlaintext() {
        this.plaintext = true;
        return this;
    }

    public CerbosClientBuilder withInsecure() {
        this.insecure = true;
        return this;
    }

    public CerbosClientBuilder withAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    public CerbosClientBuilder withCaCertificate(InputStream caCertificate) {
        this.caCertificate = caCertificate;
        return this;
    }

    public CerbosClientBuilder withTlsCertificate(InputStream tlsCertificate) {
        this.tlsCertificate = tlsCertificate;
        return this;
    }

    public CerbosClientBuilder withTlsKey(InputStream tlsKey) {
        this.tlsKey = tlsKey;
        return this;
    }

    public CerbosClientBuilder withTimeout(Duration timeout) {
        this.timeoutMillis = timeout.toMillis();
        return this;
    }

    public CerbosClientBuilder withPlaygroundInstance(String playgroundInstance) {
        this.playgroundInstance = playgroundInstance;
        return this;
    }

    private ManagedChannel buildChannel() throws InvalidClientConfigurationException {
        if (CerbosClientBuilder.isEmptyString(this.target)) {
            throw new InvalidClientConfigurationException("Invalid target [" + this.target + "]");
        }
        ManagedChannelBuilder channelBuilder = null;
        if (this.plaintext) {
            channelBuilder = Grpc.newChannelBuilder((String)this.target, (ChannelCredentials)InsecureChannelCredentials.create());
        } else {
            TlsChannelCredentials.Builder tlsCredentials = TlsChannelCredentials.newBuilder();
            if (this.insecure) {
                tlsCredentials.trustManager(InsecureTrustManagerFactory.INSTANCE.getTrustManagers());
            }
            if (this.caCertificate != null) {
                try {
                    tlsCredentials.trustManager(this.caCertificate);
                }
                catch (Exception e) {
                    throw new InvalidClientConfigurationException("Failed to set CA trust root", e);
                }
            }
            if (this.tlsCertificate != null && this.tlsKey != null) {
                try {
                    tlsCredentials.keyManager(this.tlsCertificate, this.tlsKey);
                }
                catch (Exception e) {
                    throw new InvalidClientConfigurationException("Failed to set TLS credentials", e);
                }
            }
            channelBuilder = Grpc.newChannelBuilder((String)this.target, (ChannelCredentials)tlsCredentials.build());
        }
        if (!CerbosClientBuilder.isEmptyString(this.authority)) {
            channelBuilder.overrideAuthority(this.authority);
        }
        return channelBuilder.build();
    }

    public CerbosBlockingClient buildBlockingClient() throws InvalidClientConfigurationException {
        PlaygroundInstanceCredentials pgCreds = null;
        if (!CerbosClientBuilder.isEmptyString(this.playgroundInstance)) {
            pgCreds = new PlaygroundInstanceCredentials(this.playgroundInstance);
        }
        return new CerbosBlockingClient((Channel)this.buildChannel(), this.timeoutMillis, pgCreds);
    }

    public CerbosBlockingAdminClient buildBlockingAdminClient() throws InvalidClientConfigurationException {
        String username = System.getenv("CERBOS_USERNAME");
        String password = System.getenv("CERBOS_PASSWORD");
        return this.buildBlockingAdminClient(username, password);
    }

    public CerbosBlockingAdminClient buildBlockingAdminClient(String username, String password) throws InvalidClientConfigurationException {
        if (username == null || password == null) {
            throw new InvalidClientConfigurationException("username and password must not be null");
        }
        AdminApiCredentials adminCreds = new AdminApiCredentials(username, password);
        return new CerbosBlockingAdminClient((Channel)this.buildChannel(), this.timeoutMillis, adminCreds);
    }

    private static boolean isEmptyString(String str) {
        return str == null || str.strip().isEmpty();
    }

    public static class InvalidClientConfigurationException
    extends Exception {
        public InvalidClientConfigurationException(String message) {
            super(message);
        }

        public InvalidClientConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidClientConfigurationException(Throwable cause) {
            super(cause);
        }
    }
}

