package dev.cel.checker;

import dev.cel.common.ast.CelConstant;
import dev.cel.common.types.CelType;
import java.util.Optional;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_CelIdentDecl extends CelIdentDecl {

  private final String name;

  private final CelType type;

  private final Optional<CelConstant> constant;

  private final String doc;

  private AutoValue_CelIdentDecl(
      String name,
      CelType type,
      Optional<CelConstant> constant,
      String doc) {
    this.name = name;
    this.type = type;
    this.constant = constant;
    this.doc = doc;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public CelType type() {
    return type;
  }

  @Override
  public Optional<CelConstant> constant() {
    return constant;
  }

  @Override
  public String doc() {
    return doc;
  }

  @Override
  public String toString() {
    return "CelIdentDecl{"
        + "name=" + name + ", "
        + "type=" + type + ", "
        + "constant=" + constant + ", "
        + "doc=" + doc
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CelIdentDecl) {
      CelIdentDecl that = (CelIdentDecl) o;
      return this.name.equals(that.name())
          && this.type.equals(that.type())
          && this.constant.equals(that.constant())
          && this.doc.equals(that.doc());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= constant.hashCode();
    h$ *= 1000003;
    h$ ^= doc.hashCode();
    return h$;
  }

  static final class Builder extends CelIdentDecl.Builder {
    private String name;
    private CelType type;
    private Optional<CelConstant> constant = Optional.empty();
    private String doc;
    Builder() {
    }
    @Override
    public CelIdentDecl.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public CelIdentDecl.Builder setType(CelType type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public CelIdentDecl.Builder setConstant(CelConstant constant) {
      this.constant = Optional.of(constant);
      return this;
    }
    @Override
    public CelIdentDecl.Builder setConstant(Optional<CelConstant> constant) {
      if (constant == null) {
        throw new NullPointerException("Null constant");
      }
      this.constant = constant;
      return this;
    }
    @Override
    public CelIdentDecl.Builder setDoc(String doc) {
      if (doc == null) {
        throw new NullPointerException("Null doc");
      }
      this.doc = doc;
      return this;
    }
    @Override
    public CelIdentDecl build() {
      if (this.name == null
          || this.type == null
          || this.doc == null) {
        StringBuilder missing = new StringBuilder();
        if (this.name == null) {
          missing.append(" name");
        }
        if (this.type == null) {
          missing.append(" type");
        }
        if (this.doc == null) {
          missing.append(" doc");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CelIdentDecl(
          this.name,
          this.type,
          this.constant,
          this.doc);
    }
  }

}
