/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.parser;

import com.google.protobuf.ByteString;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelSource;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelExprVisitor;
import dev.cel.parser.Operator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;

public class CelUnparserVisitor
extends CelExprVisitor {
    protected static final String LEFT_PAREN = "(";
    protected static final String RIGHT_PAREN = ")";
    protected static final String DOT = ".";
    protected static final String COMMA = ",";
    protected static final String SPACE = " ";
    protected static final String LEFT_BRACKET = "[";
    protected static final String RIGHT_BRACKET = "]";
    protected static final String LEFT_BRACE = "{";
    protected static final String RIGHT_BRACE = "}";
    protected static final String COLON = ":";
    protected static final String QUESTION_MARK = "?";
    protected final CelAbstractSyntaxTree ast;
    protected final CelSource sourceInfo;
    protected final StringBuilder stringBuilder;

    public CelUnparserVisitor(CelAbstractSyntaxTree ast) {
        this.ast = ast;
        this.sourceInfo = ast.getSource();
        this.stringBuilder = new StringBuilder();
    }

    public String unparse() {
        this.visit(this.ast.getExpr());
        return this.stringBuilder.toString();
    }

    @Override
    public void visit(CelExpr expr) {
        if (this.sourceInfo.getMacroCalls().containsKey((Object)expr.id())) {
            this.visit((CelExpr)this.sourceInfo.getMacroCalls().get((Object)expr.id()));
            return;
        }
        super.visit(expr);
    }

    @Override
    protected void visit(CelExpr expr, CelConstant constant) {
        switch (constant.getKind()) {
            case STRING_VALUE: {
                this.stringBuilder.append("\"").append(constant.stringValue()).append("\"");
                break;
            }
            case INT64_VALUE: {
                this.stringBuilder.append(constant.int64Value());
                break;
            }
            case UINT64_VALUE: {
                this.stringBuilder.append(constant.uint64Value()).append("u");
                break;
            }
            case BOOLEAN_VALUE: {
                this.stringBuilder.append(constant.booleanValue() ? "true" : "false");
                break;
            }
            case DOUBLE_VALUE: {
                this.stringBuilder.append(constant.doubleValue());
                break;
            }
            case NULL_VALUE: {
                this.stringBuilder.append("null");
                break;
            }
            case BYTES_VALUE: {
                this.stringBuilder.append("b\"").append(this.bytesToOctets(constant.bytesValue())).append("\"");
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected expr kind");
            }
        }
    }

    @Override
    protected void visit(CelExpr expr, CelExpr.CelIdent ident) {
        this.stringBuilder.append(ident.name());
    }

    @Override
    protected void visit(CelExpr expr, CelExpr.CelSelect select) {
        this.visitSelect(select.operand(), select.testOnly(), DOT, select.field());
    }

    @Override
    protected void visit(CelExpr expr, CelExpr.CelCall call) {
        String fun = call.function();
        Optional<String> op = Operator.lookupUnaryOperator(fun);
        if (op.isPresent()) {
            this.visitUnary(call, op.get());
            return;
        }
        op = Operator.lookupBinaryOperator(fun);
        if (op.isPresent()) {
            this.visitBinary(call, op.get());
            return;
        }
        if (fun.equals(Operator.INDEX.getFunction())) {
            this.visitIndex(call, LEFT_BRACKET);
            return;
        }
        if (fun.equals(Operator.OPTIONAL_INDEX.getFunction())) {
            this.visitIndex(call, "[?");
            return;
        }
        if (fun.equals(Operator.CONDITIONAL.getFunction())) {
            this.visitTernary(call);
            return;
        }
        if (fun.equals(Operator.OPTIONAL_SELECT.getFunction())) {
            CelExpr operand = (CelExpr)call.args().get(0);
            String field = ((CelExpr)call.args().get(1)).constant().stringValue();
            this.visitSelect(operand, false, ".?", field);
            return;
        }
        if (call.target().isPresent()) {
            boolean nested = this.isBinaryOrTernaryOperator(call.target().get());
            this.visitMaybeNested(call.target().get(), nested);
            this.stringBuilder.append(DOT);
        }
        this.stringBuilder.append(fun).append(LEFT_PAREN);
        for (int i = 0; i < call.args().size(); ++i) {
            if (i > 0) {
                this.stringBuilder.append(COMMA).append(SPACE);
            }
            this.visit((CelExpr)call.args().get(i));
        }
        this.stringBuilder.append(RIGHT_PAREN);
    }

    @Override
    protected void visit(CelExpr expr, CelExpr.CelList createList) {
        this.stringBuilder.append(LEFT_BRACKET);
        HashSet<Integer> optionalIndices = new HashSet<Integer>((Collection<Integer>)createList.optionalIndices());
        for (int i = 0; i < createList.elements().size(); ++i) {
            if (i > 0) {
                this.stringBuilder.append(COMMA).append(SPACE);
            }
            if (optionalIndices.contains(i)) {
                this.stringBuilder.append(QUESTION_MARK);
            }
            this.visit((CelExpr)createList.elements().get(i));
        }
        this.stringBuilder.append(RIGHT_BRACKET);
    }

    @Override
    protected void visit(CelExpr expr, CelExpr.CelStruct createStruct) {
        this.stringBuilder.append(createStruct.messageName());
        this.stringBuilder.append(LEFT_BRACE);
        for (int i = 0; i < createStruct.entries().size(); ++i) {
            CelExpr.CelStruct.Entry e;
            if (i > 0) {
                this.stringBuilder.append(COMMA).append(SPACE);
            }
            if ((e = (CelExpr.CelStruct.Entry)createStruct.entries().get(i)).optionalEntry()) {
                this.stringBuilder.append(QUESTION_MARK);
            }
            this.stringBuilder.append(e.fieldKey());
            this.stringBuilder.append(COLON).append(SPACE);
            this.visit(e.value());
        }
        this.stringBuilder.append(RIGHT_BRACE);
    }

    @Override
    protected void visit(CelExpr expr, CelExpr.CelMap createMap) {
        this.stringBuilder.append(LEFT_BRACE);
        for (int i = 0; i < createMap.entries().size(); ++i) {
            CelExpr.CelMap.Entry e;
            if (i > 0) {
                this.stringBuilder.append(COMMA).append(SPACE);
            }
            if ((e = (CelExpr.CelMap.Entry)createMap.entries().get(i)).optionalEntry()) {
                this.stringBuilder.append(QUESTION_MARK);
            }
            this.visit(e.key());
            this.stringBuilder.append(COLON).append(SPACE);
            this.visit(e.value());
        }
        this.stringBuilder.append(RIGHT_BRACE);
    }

    @Override
    protected void visit(CelExpr expr, CelExpr.CelComprehension comprehension) {
        throw new UnsupportedOperationException("Comprehension unparsing requires macro calls to be populated. Ensure the option is enabled.");
    }

    private void visitUnary(CelExpr.CelCall expr, String op) {
        if (expr.args().size() != 1) {
            throw new IllegalArgumentException(String.format("unexpected unary: %s", expr));
        }
        this.stringBuilder.append(op);
        boolean nested = this.isComplexOperator((CelExpr)expr.args().get(0));
        this.visitMaybeNested((CelExpr)expr.args().get(0), nested);
    }

    private void visitBinary(CelExpr.CelCall expr, String op) {
        if (expr.args().size() != 2) {
            throw new IllegalArgumentException(String.format("unexpected binary: %s", expr));
        }
        CelExpr lhs = (CelExpr)expr.args().get(0);
        CelExpr rhs = (CelExpr)expr.args().get(1);
        String fun = expr.function();
        boolean lhsParen = this.isComplexOperatorWithRespectTo(lhs, fun);
        boolean rhsParen = this.isComplexOperatorWithRespectTo(rhs, fun);
        if (!rhsParen && Operator.isOperatorLeftRecursive(fun)) {
            rhsParen = this.isOperatorSamePrecedence(fun, rhs);
        }
        this.visitMaybeNested(lhs, lhsParen);
        this.stringBuilder.append(SPACE).append(op).append(SPACE);
        this.visitMaybeNested(rhs, rhsParen);
    }

    private void visitSelect(CelExpr operand, boolean testOnly, String op, String field) {
        if (testOnly) {
            this.stringBuilder.append(Operator.HAS.getFunction()).append(LEFT_PAREN);
        }
        boolean nested = !testOnly && this.isBinaryOrTernaryOperator(operand);
        this.visitMaybeNested(operand, nested);
        this.stringBuilder.append(op).append(field);
        if (testOnly) {
            this.stringBuilder.append(RIGHT_PAREN);
        }
    }

    private void visitTernary(CelExpr.CelCall expr) {
        if (expr.args().size() != 3) {
            throw new IllegalArgumentException(String.format("unexpected ternary: %s", expr));
        }
        boolean nested = this.isOperatorSamePrecedence(Operator.CONDITIONAL.getFunction(), (CelExpr)expr.args().get(0)) || this.isComplexOperator((CelExpr)expr.args().get(0));
        this.visitMaybeNested((CelExpr)expr.args().get(0), nested);
        this.stringBuilder.append(SPACE).append(QUESTION_MARK).append(SPACE);
        nested = this.isOperatorSamePrecedence(Operator.CONDITIONAL.getFunction(), (CelExpr)expr.args().get(1)) || this.isComplexOperator((CelExpr)expr.args().get(1));
        this.visitMaybeNested((CelExpr)expr.args().get(1), nested);
        this.stringBuilder.append(SPACE).append(COLON).append(SPACE);
        nested = this.isOperatorSamePrecedence(Operator.CONDITIONAL.getFunction(), (CelExpr)expr.args().get(2)) || this.isComplexOperator((CelExpr)expr.args().get(2));
        this.visitMaybeNested((CelExpr)expr.args().get(2), nested);
    }

    private void visitIndex(CelExpr.CelCall expr, String op) {
        if (expr.args().size() != 2) {
            throw new IllegalArgumentException(String.format("unexpected index call: %s", expr));
        }
        boolean nested = this.isBinaryOrTernaryOperator((CelExpr)expr.args().get(0));
        this.visitMaybeNested((CelExpr)expr.args().get(0), nested);
        this.stringBuilder.append(op);
        this.visit((CelExpr)expr.args().get(1));
        this.stringBuilder.append(RIGHT_BRACKET);
    }

    private void visitMaybeNested(CelExpr expr, boolean nested) {
        if (nested) {
            this.stringBuilder.append(LEFT_PAREN);
        }
        this.visit(expr);
        if (nested) {
            this.stringBuilder.append(RIGHT_PAREN);
        }
    }

    private boolean isBinaryOrTernaryOperator(CelExpr expr) {
        if (!this.isComplexOperator(expr)) {
            return false;
        }
        return Operator.lookupBinaryOperator(expr.call().function()).isPresent() || this.isOperatorSamePrecedence(Operator.CONDITIONAL.getFunction(), expr);
    }

    private boolean isComplexOperator(CelExpr expr) {
        return expr.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.CALL) && expr.call().args().size() >= 2;
    }

    private boolean isOperatorSamePrecedence(String op, CelExpr expr) {
        if (!expr.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.CALL)) {
            return false;
        }
        return Operator.lookupPrecedence(op) == Operator.lookupPrecedence(expr.call().function());
    }

    private boolean isComplexOperatorWithRespectTo(CelExpr expr, String op) {
        if (!expr.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.CALL) || expr.call().args().size() < 2) {
            return false;
        }
        return Operator.isOperatorLowerPrecedence(op, expr);
    }

    private String bytesToOctets(ByteString bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes.toByteArray()) {
            sb.append(String.format("\\%03o", b));
        }
        return sb.toString();
    }
}

