/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.parser;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.parser.AutoValue_CelMacro;
import dev.cel.parser.CelMacroExpander;

@Immutable
@AutoValue
public abstract class CelMacro
implements Comparable<CelMacro> {
    CelMacro() {
    }

    public abstract String getFunction();

    public abstract int getArgumentCount();

    abstract boolean getReceiverStyle();

    public final boolean isReceiverStyle() {
        return this.getReceiverStyle();
    }

    public abstract String getKey();

    abstract boolean getVariadic();

    public final boolean isVariadic() {
        return this.getVariadic();
    }

    public abstract CelMacroExpander getExpander();

    @Override
    public final int compareTo(CelMacro other) {
        if (other == null) {
            return 1;
        }
        int diff = this.getFunction().compareTo(other.getFunction());
        if (diff != 0) {
            return diff;
        }
        diff = Boolean.compare(!this.isVariadic(), !other.isVariadic());
        if (diff != 0) {
            return diff;
        }
        if (!this.isVariadic() && (diff = Integer.compare(this.getArgumentCount(), other.getArgumentCount())) != 0) {
            return diff;
        }
        return Boolean.compare(this.isReceiverStyle(), other.isReceiverStyle());
    }

    public final String toString() {
        return this.getKey();
    }

    public final int hashCode() {
        return this.getKey().hashCode();
    }

    public final boolean equals(Object other) {
        return other instanceof CelMacro && this.getKey().equals(((CelMacro)other).getKey());
    }

    static Builder newBuilder() {
        return new AutoValue_CelMacro.Builder();
    }

    public static CelMacro newGlobalMacro(String function, int argCount, CelMacroExpander expander) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        Preconditions.checkArgument((argCount >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)expander);
        return CelMacro.newBuilder().setFunction(function).setArgumentCount(argCount).setReceiverStyle(false).setKey(CelMacro.formatKey(function, argCount, false)).setVariadic(false).setExpander(expander).build();
    }

    public static CelMacro newGlobalVarArgMacro(String function, CelMacroExpander expander) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)expander);
        return CelMacro.newBuilder().setFunction(function).setArgumentCount(0).setReceiverStyle(false).setKey(CelMacro.formatVarArgKey(function, false)).setVariadic(true).setExpander(expander).build();
    }

    public static CelMacro newReceiverMacro(String function, int argCount, CelMacroExpander expander) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        Preconditions.checkArgument((argCount >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)expander);
        return CelMacro.newBuilder().setFunction(function).setArgumentCount(argCount).setReceiverStyle(true).setKey(CelMacro.formatKey(function, argCount, true)).setVariadic(false).setExpander(expander).build();
    }

    public static CelMacro newReceiverVarArgMacro(String function, CelMacroExpander expander) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)expander);
        return CelMacro.newBuilder().setFunction(function).setArgumentCount(0).setReceiverStyle(true).setKey(CelMacro.formatVarArgKey(function, true)).setVariadic(true).setExpander(expander).build();
    }

    static String formatKey(String function, int argCount, boolean receiverStyle) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        Preconditions.checkArgument((argCount >= 0 ? 1 : 0) != 0);
        return String.format("%s:%d:%s", function, argCount, receiverStyle);
    }

    static String formatVarArgKey(String function, boolean receiverStyle) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        return String.format("%s:*:%s", function, receiverStyle);
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setFunction(String var1);

        abstract Builder setArgumentCount(int var1);

        abstract Builder setReceiverStyle(boolean var1);

        abstract Builder setKey(String var1);

        abstract Builder setVariadic(boolean var1);

        abstract Builder setExpander(CelMacroExpander var1);

        @CheckReturnValue
        abstract CelMacro build();
    }
}

