/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.compiler;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import dev.cel.checker.CelChecker;
import dev.cel.checker.CelCheckerBuilder;
import dev.cel.checker.ProtoTypeMask;
import dev.cel.checker.TypeProvider;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelOptions;
import dev.cel.common.CelSource;
import dev.cel.common.CelValidationResult;
import dev.cel.common.CelVarDecl;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.EnvVisitable;
import dev.cel.common.internal.EnvVisitor;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypeProvider;
import dev.cel.common.types.CelTypes;
import dev.cel.compiler.CelCompiler;
import dev.cel.compiler.CelCompilerBuilder;
import dev.cel.compiler.CelCompilerLibrary;
import dev.cel.expr.Decl;
import dev.cel.expr.Type;
import dev.cel.parser.CelMacro;
import dev.cel.parser.CelParser;
import dev.cel.parser.CelParserBuilder;
import dev.cel.parser.CelStandardMacro;
import java.util.Arrays;

@Immutable
@Internal
public final class CelCompilerImpl
implements CelCompiler,
EnvVisitable {
    private final CelParser parser;
    private final CelChecker checker;

    @Override
    public CelValidationResult parse(String expression, String description) {
        return this.parser.parse(expression, description);
    }

    @Override
    public CelValidationResult parse(CelSource source) {
        return this.parser.parse(source);
    }

    @Override
    public CelValidationResult check(CelAbstractSyntaxTree ast) {
        return this.checker.check(ast);
    }

    @Override
    public void accept(EnvVisitor envVisitor) {
        if (this.checker instanceof EnvVisitable) {
            ((EnvVisitable)((Object)this.checker)).accept(envVisitor);
        }
    }

    @Override
    public CelCompilerBuilder toCompilerBuilder() {
        return CelCompilerImpl.newBuilder(this.toParserBuilder(), this.toCheckerBuilder());
    }

    @Override
    public CelCheckerBuilder toCheckerBuilder() {
        return this.checker.toCheckerBuilder();
    }

    @Override
    public CelParserBuilder toParserBuilder() {
        return this.parser.toParserBuilder();
    }

    static CelCompilerImpl combine(CelParser parser, CelChecker checker) {
        return new CelCompilerImpl(parser, checker);
    }

    public static CelCompilerBuilder newBuilder(CelParserBuilder parserBuilder, CelCheckerBuilder checkerBuilder) {
        return new Builder(parserBuilder, checkerBuilder);
    }

    private CelCompilerImpl(CelParser parser, CelChecker checker) {
        this.parser = parser;
        this.checker = checker;
    }

    public static final class Builder
    implements CelCompilerBuilder {
        private final CelParserBuilder parserBuilder;
        private final CelCheckerBuilder checkerBuilder;

        @Override
        public CelCompilerBuilder setOptions(CelOptions options) {
            this.parserBuilder.setOptions(options);
            this.checkerBuilder.setOptions(options);
            return this;
        }

        @Override
        public CelCompilerBuilder setStandardMacros(CelStandardMacro ... macros) {
            this.parserBuilder.setStandardMacros(macros);
            return this;
        }

        @Override
        public CelCompilerBuilder setStandardMacros(Iterable<CelStandardMacro> macros) {
            this.parserBuilder.setStandardMacros(macros);
            return this;
        }

        @Override
        public CelCompilerBuilder addMacros(CelMacro ... macros) {
            Preconditions.checkNotNull((Object)macros);
            return this.addMacros(Arrays.asList(macros));
        }

        @Override
        public CelCompilerBuilder addMacros(Iterable<CelMacro> macros) {
            Preconditions.checkNotNull(macros);
            this.parserBuilder.addMacros(macros);
            return this;
        }

        @Override
        public CelCompilerBuilder setContainer(String container) {
            this.checkerBuilder.setContainer(container);
            return this;
        }

        @Override
        public CelCompilerBuilder addVar(String name, Type type) {
            return this.addVar(name, CelTypes.typeToCelType(type));
        }

        @Override
        public CelCompilerBuilder addVar(String name, CelType type) {
            return this.addVarDeclarations(CelVarDecl.newVarDeclaration(name, type));
        }

        @Override
        public CelCompilerBuilder addDeclarations(Decl ... declarations) {
            this.checkerBuilder.addDeclarations(declarations);
            return this;
        }

        @Override
        public CelCompilerBuilder addDeclarations(Iterable<Decl> declarations) {
            this.checkerBuilder.addDeclarations(declarations);
            return this;
        }

        @Override
        public CelCompilerBuilder addFunctionDeclarations(CelFunctionDecl ... celFunctionDecls) {
            this.checkerBuilder.addFunctionDeclarations(celFunctionDecls);
            return this;
        }

        @Override
        public CelCompilerBuilder addFunctionDeclarations(Iterable<CelFunctionDecl> celFunctionDecls) {
            this.checkerBuilder.addFunctionDeclarations(celFunctionDecls);
            return this;
        }

        @Override
        public CelCompilerBuilder addVarDeclarations(CelVarDecl ... celVarDecls) {
            this.checkerBuilder.addVarDeclarations(celVarDecls);
            return this;
        }

        @Override
        public CelCompilerBuilder addVarDeclarations(Iterable<CelVarDecl> celVarDecls) {
            this.checkerBuilder.addVarDeclarations(celVarDecls);
            return this;
        }

        @Override
        public CelCompilerBuilder addProtoTypeMasks(ProtoTypeMask ... typeMasks) {
            this.checkerBuilder.addProtoTypeMasks(typeMasks);
            return this;
        }

        @Override
        public CelCompilerBuilder addProtoTypeMasks(Iterable<ProtoTypeMask> typeMasks) {
            this.checkerBuilder.addProtoTypeMasks(typeMasks);
            return this;
        }

        @Override
        public CelCompilerBuilder setResultType(CelType resultType) {
            Preconditions.checkNotNull((Object)resultType);
            return this.setProtoResultType(CelTypes.celTypeToType(resultType));
        }

        @Override
        public CelCompilerBuilder setProtoResultType(Type resultType) {
            this.checkerBuilder.setProtoResultType(resultType);
            return this;
        }

        @Override
        @Deprecated
        public CelCompilerBuilder setTypeProvider(TypeProvider typeProvider) {
            this.checkerBuilder.setTypeProvider(typeProvider);
            return this;
        }

        @Override
        public CelCompilerBuilder setTypeProvider(CelTypeProvider celTypeProvider) {
            this.checkerBuilder.setTypeProvider(celTypeProvider);
            return this;
        }

        @Override
        public CelCompilerBuilder addMessageTypes(Descriptors.Descriptor ... descriptors) {
            this.checkerBuilder.addMessageTypes(descriptors);
            return this;
        }

        @Override
        public CelCompilerBuilder addMessageTypes(Iterable<Descriptors.Descriptor> descriptors) {
            this.checkerBuilder.addMessageTypes(descriptors);
            return this;
        }

        @Override
        public CelCompilerBuilder addFileTypes(Descriptors.FileDescriptor ... fileDescriptors) {
            this.checkerBuilder.addFileTypes(fileDescriptors);
            return this;
        }

        @Override
        public CelCompilerBuilder addFileTypes(Iterable<Descriptors.FileDescriptor> fileDescriptors) {
            this.checkerBuilder.addFileTypes(fileDescriptors);
            return this;
        }

        @Override
        public CelCompilerBuilder addFileTypes(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
            this.checkerBuilder.addFileTypes(fileDescriptorSet);
            return this;
        }

        @Override
        public CelCompilerBuilder setStandardEnvironmentEnabled(boolean value) {
            this.checkerBuilder.setStandardEnvironmentEnabled(value);
            return this;
        }

        @Override
        public CelCompilerBuilder addLibraries(CelCompilerLibrary ... libraries) {
            Preconditions.checkNotNull((Object)libraries);
            return this.addLibraries(Arrays.asList(libraries));
        }

        @Override
        public CelCompilerBuilder addLibraries(Iterable<? extends CelCompilerLibrary> libraries) {
            Preconditions.checkNotNull(libraries);
            this.parserBuilder.addLibraries(libraries);
            this.checkerBuilder.addLibraries(libraries);
            return this;
        }

        @Override
        @CheckReturnValue
        public CelCompilerImpl build() {
            return new CelCompilerImpl(this.parserBuilder.build(), this.checkerBuilder.build());
        }

        private Builder(CelParserBuilder parserBuilder, CelCheckerBuilder checkerBuilder) {
            this.parserBuilder = parserBuilder;
            this.checkerBuilder = checkerBuilder;
        }
    }
}

