/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@CheckReturnValue
public final class FileDescriptorSetConverter {
    public static ImmutableSet<Descriptors.FileDescriptor> convert(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        HashMap<String, DescriptorProtos.FileDescriptorProto> descriptorProtos = new HashMap<String, DescriptorProtos.FileDescriptorProto>();
        for (DescriptorProtos.FileDescriptorProto fileProto : fileDescriptorSet.getFileList()) {
            descriptorProtos.put(fileProto.getName(), fileProto);
        }
        HashMap<String, Descriptors.FileDescriptor> fileDescriptors = new HashMap<String, Descriptors.FileDescriptor>();
        for (DescriptorProtos.FileDescriptorProto fileProto : fileDescriptorSet.getFileList()) {
            FileDescriptorSetConverter.readDescriptor(fileProto.getName(), descriptorProtos, fileDescriptors);
        }
        return ImmutableSet.copyOf(fileDescriptors.values());
    }

    @CanIgnoreReturnValue
    private static Descriptors.FileDescriptor readDescriptor(String fileName, Map<String, DescriptorProtos.FileDescriptorProto> descriptorProtos, Map<String, Descriptors.FileDescriptor> descriptors) {
        if (descriptors.containsKey(fileName)) {
            return descriptors.get(fileName);
        }
        if (!descriptorProtos.containsKey(fileName)) {
            throw new IllegalArgumentException("file descriptor set with unresolved proto file: " + fileName);
        }
        DescriptorProtos.FileDescriptorProto fileProto = descriptorProtos.get(fileName);
        ArrayList<Descriptors.FileDescriptor> deps = new ArrayList<Descriptors.FileDescriptor>();
        for (String dep : fileProto.getDependencyList()) {
            deps.add(FileDescriptorSetConverter.readDescriptor(dep, descriptorProtos, descriptors));
        }
        try {
            Descriptors.FileDescriptor result = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileProto, (Descriptors.FileDescriptor[])deps.toArray(new Descriptors.FileDescriptor[0]));
            descriptors.put(fileName, result);
            return result;
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new VerifyException((Throwable)e);
        }
    }

    private FileDescriptorSetConverter() {
    }
}

