/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.base.Preconditions;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelCodePointArray;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.misc.Interval;

@Internal
public final class CodePointStream
implements CharStream {
    private final String sourceName;
    private final CelCodePointArray codePoints;
    private int position;

    public CodePointStream(String sourceName, CelCodePointArray codePoints) {
        this.sourceName = (String)Preconditions.checkNotNull((Object)sourceName);
        this.codePoints = (CelCodePointArray)Preconditions.checkNotNull((Object)codePoints);
        this.position = 0;
    }

    public void consume() {
        if (this.position >= this.size()) {
            Preconditions.checkState((this.LA(1) == -1 ? 1 : 0) != 0);
            throw new IllegalStateException("Cannot consume EOF");
        }
        ++this.position;
    }

    public int LA(int i) {
        switch (Integer.signum(i)) {
            case -1: {
                int index = this.position + i;
                if (index < 0) {
                    return -1;
                }
                return this.codePoints.get(index);
            }
            case 0: {
                return 0;
            }
            case 1: {
                int index = this.position + i - 1;
                if (index >= this.codePoints.size()) {
                    return -1;
                }
                return this.codePoints.get(index);
            }
        }
        throw new AssertionError();
    }

    public int mark() {
        return -1;
    }

    public void release(int marker) {
    }

    public int index() {
        return this.position;
    }

    public void seek(int index) {
        Preconditions.checkArgument((index >= 0 && index <= this.size() ? 1 : 0) != 0);
        this.position = index;
    }

    public int size() {
        return this.codePoints.size();
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getText(Interval interval) {
        int index = Math.min(interval.a, this.size());
        int size = Math.min(interval.b - interval.a + 1, this.size() - index);
        return this.codePoints.slice(index, index + size).toString();
    }

    public String toString() {
        return this.codePoints.toString();
    }
}

