/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.AutoValue_CelReference;
import dev.cel.common.ast.CelConstant;
import java.util.Arrays;
import java.util.Optional;

@Immutable
@AutoValue
@Internal
public abstract class CelReference {
    public abstract String name();

    public abstract ImmutableList<String> overloadIds();

    public abstract Optional<CelConstant> value();

    public static Builder newBuilder() {
        return new AutoValue_CelReference.Builder().setName("");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setValue(CelConstant var1);

        abstract ImmutableList<String> overloadIds();

        abstract Optional<CelConstant> value();

        abstract ImmutableList.Builder<String> overloadIdsBuilder();

        @CanIgnoreReturnValue
        public Builder addOverloadIds(String ... overloadIds) {
            Preconditions.checkNotNull((Object)overloadIds);
            return this.addOverloadIds(Arrays.asList(overloadIds));
        }

        @CanIgnoreReturnValue
        public Builder addOverloadIds(Iterable<String> overloadIds) {
            Preconditions.checkNotNull(overloadIds);
            this.overloadIdsBuilder().addAll(overloadIds);
            return this;
        }

        @CheckReturnValue
        abstract CelReference autoBuild();

        public final CelReference build() {
            CelReference celReference = this.autoBuild();
            Preconditions.checkArgument((!this.value().isPresent() || this.overloadIds().isEmpty() ? 1 : 0) != 0, (Object)"Value and overloadIds cannot be set at the same time.");
            return celReference;
        }
    }
}

