/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;

public class CelExprVisitor {
    protected CelExprVisitor() {
    }

    public void visit(CelAbstractSyntaxTree ast) {
        this.visit(ast.getExpr());
    }

    public void visit(CelExpr expr) {
        switch (expr.exprKind().getKind()) {
            case CONSTANT: {
                this.visit(expr, expr.constant());
                break;
            }
            case IDENT: {
                this.visit(expr, expr.ident());
                break;
            }
            case SELECT: {
                this.visit(expr, expr.select());
                break;
            }
            case CALL: {
                this.visit(expr, expr.call());
                break;
            }
            case LIST: {
                this.visit(expr, expr.list());
                break;
            }
            case STRUCT: {
                this.visit(expr, expr.struct());
                break;
            }
            case MAP: {
                this.visit(expr, expr.map());
                break;
            }
            case COMPREHENSION: {
                this.visit(expr, expr.comprehension());
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected expr kind: " + (Object)((Object)expr.exprKind().getKind()));
            }
        }
    }

    protected void visit(CelExpr expr, CelExpr.CelIdent ident) {
    }

    protected void visit(CelExpr expr, CelConstant constant) {
    }

    protected void visit(CelExpr expr, CelExpr.CelSelect select) {
        this.visit(select.operand());
    }

    protected void visit(CelExpr expr, CelExpr.CelCall call) {
        if (call.target().isPresent()) {
            this.visit(call.target().get());
        }
        for (int i = 0; i < call.args().size(); ++i) {
            CelExpr arg = (CelExpr)call.args().get(i);
            this.visit(arg);
            this.visitArg(expr, arg, i);
        }
    }

    protected void visit(CelExpr expr, CelExpr.CelStruct createStruct) {
        for (CelExpr.CelStruct.Entry entry : createStruct.entries()) {
            this.visit(entry.value());
        }
    }

    protected void visit(CelExpr expr, CelExpr.CelMap createMap) {
        for (CelExpr.CelMap.Entry entry : createMap.entries()) {
            this.visit(entry.key());
            this.visit(entry.value());
        }
    }

    protected void visit(CelExpr expr, CelExpr.CelList createList) {
        for (CelExpr elem : createList.elements()) {
            this.visit(elem);
        }
    }

    protected void visit(CelExpr expr, CelExpr.CelComprehension comprehension) {
        this.visit(comprehension.iterRange());
        this.visitArg(expr, comprehension.iterRange(), ComprehensionArg.ITER_RANGE.ordinal());
        this.visit(comprehension.accuInit());
        this.visitArg(expr, comprehension.accuInit(), ComprehensionArg.ACCU_INIT.ordinal());
        this.visit(comprehension.loopCondition());
        this.visitArg(expr, comprehension.loopCondition(), ComprehensionArg.LOOP_CONDIITON.ordinal());
        this.visit(comprehension.loopStep());
        this.visitArg(expr, comprehension.loopStep(), ComprehensionArg.LOOP_STEP.ordinal());
        this.visit(comprehension.result());
        this.visitArg(expr, comprehension.result(), ComprehensionArg.RESULT.ordinal());
    }

    protected void visitArg(CelExpr expr, CelExpr arg, int argNum) {
    }

    public static enum ComprehensionArg {
        ITER_RANGE,
        ACCU_INIT,
        LOOP_CONDIITON,
        LOOP_STEP,
        RESULT;

    }
}

