/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.InlineMe;
import dev.cel.common.ast.AutoOneOf_CelExpr_ExprKind;
import dev.cel.common.ast.AutoValue_CelExpr;
import dev.cel.common.ast.AutoValue_CelExpr_CelCall;
import dev.cel.common.ast.AutoValue_CelExpr_CelComprehension;
import dev.cel.common.ast.AutoValue_CelExpr_CelIdent;
import dev.cel.common.ast.AutoValue_CelExpr_CelList;
import dev.cel.common.ast.AutoValue_CelExpr_CelMap;
import dev.cel.common.ast.AutoValue_CelExpr_CelMap_Entry;
import dev.cel.common.ast.AutoValue_CelExpr_CelNotSet;
import dev.cel.common.ast.AutoValue_CelExpr_CelSelect;
import dev.cel.common.ast.AutoValue_CelExpr_CelStruct;
import dev.cel.common.ast.AutoValue_CelExpr_CelStruct_Entry;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExprFormatter;
import dev.cel.common.ast.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@Immutable
@AutoValue
public abstract class CelExpr
implements Expression {
    @Override
    public abstract long id();

    public abstract ExprKind exprKind();

    @Override
    public ExprKind.Kind getKind() {
        return this.exprKind().getKind();
    }

    @Override
    public CelConstant constant() {
        return this.exprKind().constant();
    }

    @Override
    public CelIdent ident() {
        return this.exprKind().ident();
    }

    public CelSelect select() {
        return this.exprKind().select();
    }

    public CelCall call() {
        return this.exprKind().call();
    }

    @Deprecated
    @InlineMe(replacement="this.list()")
    public final CelList createList() {
        return this.list();
    }

    public CelList list() {
        return this.exprKind().createList();
    }

    @Deprecated
    @InlineMe(replacement="this.struct()")
    public final CelStruct createStruct() {
        return this.struct();
    }

    public CelStruct struct() {
        return this.exprKind().createStruct();
    }

    @Deprecated
    @InlineMe(replacement="this.map()")
    public final CelMap createMap() {
        return this.map();
    }

    public CelMap map() {
        return this.exprKind().createMap();
    }

    public CelComprehension comprehension() {
        return this.exprKind().comprehension();
    }

    public CelConstant constantOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.CONSTANT) ? this.exprKind().constant() : CelConstant.ofNotSet();
    }

    public CelIdent identOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.IDENT) ? this.exprKind().ident() : CelIdent.newBuilder().build();
    }

    public CelSelect selectOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.SELECT) ? this.exprKind().select() : CelSelect.newBuilder().build();
    }

    public CelCall callOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.CALL) ? this.exprKind().call() : CelCall.newBuilder().build();
    }

    public CelList listOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.LIST) ? this.exprKind().createList() : CelList.newBuilder().build();
    }

    public CelStruct structOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.STRUCT) ? this.exprKind().createStruct() : CelStruct.newBuilder().build();
    }

    public CelMap mapOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.MAP) ? this.exprKind().createMap() : CelMap.newBuilder().build();
    }

    public CelComprehension comprehensionOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.COMPREHENSION) ? this.exprKind().comprehension() : CelComprehension.newBuilder().build();
    }

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_CelExpr.Builder().setId(0L).setExprKind(AutoOneOf_CelExpr_ExprKind.notSet(new AutoValue_CelExpr_CelNotSet()));
    }

    public static CelExpr ofNotSet(long id) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.notSet(new AutoValue_CelExpr_CelNotSet())).build();
    }

    public static CelExpr ofConstant(long id, CelConstant celConstant) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.constant(celConstant)).build();
    }

    public static CelExpr ofIdent(long id, String identName) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.ident(CelIdent.newBuilder().setName(identName).build())).build();
    }

    public static CelExpr ofSelect(long id, CelExpr operandExpr, String field, boolean isTestOnly) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.select(CelSelect.newBuilder().setOperand(operandExpr).setField(field).setTestOnly(isTestOnly).build())).build();
    }

    public static CelExpr ofCall(long id, Optional<CelExpr> targetExpr, String function, ImmutableList<CelExpr> arguments) {
        CelCall.Builder celCallBuilder = CelCall.newBuilder().setFunction(function).addArgs((Iterable<CelExpr>)arguments);
        targetExpr.ifPresent(celCallBuilder::setTarget);
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.call(celCallBuilder.build())).build();
    }

    public static CelExpr ofList(long id, ImmutableList<CelExpr> elements, ImmutableList<Integer> optionalIndices) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.list(CelList.newBuilder().addElements((Iterable<CelExpr>)elements).addOptionalIndices((Iterable<Integer>)optionalIndices).build())).build();
    }

    public static CelExpr ofStruct(long id, String messageName, ImmutableList<CelStruct.Entry> entries) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.struct(CelStruct.newBuilder().setMessageName(messageName).addEntries((Iterable<CelStruct.Entry>)entries).build())).build();
    }

    public static CelExpr ofMap(long id, ImmutableList<CelMap.Entry> entries) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.map(CelMap.newBuilder().addEntries((Iterable<CelMap.Entry>)entries).build())).build();
    }

    public static CelStruct.Entry ofStructEntry(long id, String fieldKey, CelExpr value, boolean isOptionalEntry) {
        return CelStruct.Entry.newBuilder().setId(id).setFieldKey(fieldKey).setValue(value).setOptionalEntry(isOptionalEntry).build();
    }

    public static CelMap.Entry ofMapEntry(long id, CelExpr mapKey, CelExpr value, boolean isOptionalEntry) {
        return CelMap.Entry.newBuilder().setId(id).setKey(mapKey).setValue(value).setOptionalEntry(isOptionalEntry).build();
    }

    public static CelExpr ofComprehension(long id, String iterVar, CelExpr iterRange, String accuVar, CelExpr accuInit, CelExpr loopCondition, CelExpr loopStep, CelExpr result) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.comprehension(CelComprehension.newBuilder().setIterVar(iterVar).setIterRange(iterRange).setAccuVar(accuVar).setAccuInit(accuInit).setLoopCondition(loopCondition).setLoopStep(loopStep).setResult(result).build())).build();
    }

    public final String toString() {
        return CelExprFormatter.format(this);
    }

    @Immutable
    @AutoOneOf(value=Kind.class)
    public static abstract class ExprKind {
        public abstract Kind getKind();

        public abstract CelNotSet notSet();

        public abstract CelConstant constant();

        public abstract CelIdent ident();

        public abstract CelSelect select();

        public abstract CelCall call();

        public abstract CelList list();

        @Deprecated
        @InlineMe(replacement="this.list()")
        public final CelList createList() {
            return this.list();
        }

        public abstract CelStruct struct();

        @Deprecated
        @InlineMe(replacement="this.struct()")
        public final CelStruct createStruct() {
            return this.struct();
        }

        public abstract CelMap map();

        @Deprecated
        @InlineMe(replacement="this.map()")
        public final CelMap createMap() {
            return this.map();
        }

        public abstract CelComprehension comprehension();

        public static enum Kind {
            NOT_SET,
            CONSTANT,
            IDENT,
            SELECT,
            CALL,
            LIST,
            STRUCT,
            MAP,
            COMPREHENSION;

        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelIdent
    implements Expression.Ident {
        @Override
        public abstract String name();

        public abstract Builder toBuilder();

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelIdent.Builder().setName("");
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setName(String var1);

            @CheckReturnValue
            public abstract CelIdent build();
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelSelect
    implements Expression.Select<CelExpr> {
        @Override
        public abstract CelExpr operand();

        @Override
        public abstract String field();

        @Override
        public abstract boolean testOnly();

        public abstract Builder toBuilder();

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelSelect.Builder().setField("").setOperand(CelExpr.newBuilder().build()).setTestOnly(false);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract CelExpr operand();

            public abstract String field();

            public abstract boolean testOnly();

            public abstract Builder setOperand(CelExpr var1);

            public abstract Builder setField(String var1);

            public abstract Builder setTestOnly(boolean var1);

            @CheckReturnValue
            public abstract CelSelect build();
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelCall
    implements Expression.Call<CelExpr> {
        @Override
        public abstract Optional<CelExpr> target();

        @Override
        public abstract String function();

        @Override
        public abstract ImmutableList<CelExpr> args();

        abstract Builder autoToBuilder();

        public Builder toBuilder() {
            Builder builder = this.autoToBuilder();
            builder.mutableArgs = new ArrayList<CelExpr>((Collection<CelExpr>)builder.args());
            return builder;
        }

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelCall.Builder().setFunction("");
        }

        @AutoValue.Builder
        public static abstract class Builder {
            private List<CelExpr> mutableArgs = new ArrayList<CelExpr>();

            abstract ImmutableList<CelExpr> args();

            public abstract Builder setTarget(CelExpr var1);

            public abstract Builder setTarget(Optional<CelExpr> var1);

            public abstract Builder setFunction(String var1);

            public abstract Optional<CelExpr> target();

            abstract Builder setArgs(ImmutableList<CelExpr> var1);

            public ImmutableList<CelExpr> getArgs() {
                return ImmutableList.copyOf(this.mutableArgs);
            }

            public ImmutableList<dev.cel.common.ast.CelExpr$Builder> getArgsBuilders() {
                return (ImmutableList)this.mutableArgs.stream().map(CelExpr::toBuilder).collect(ImmutableList.toImmutableList());
            }

            @CanIgnoreReturnValue
            public Builder clearArgs() {
                this.mutableArgs.clear();
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setArg(int index, CelExpr arg) {
                Preconditions.checkNotNull((Object)arg);
                this.mutableArgs.set(index, arg);
                return this;
            }

            public Builder clearTarget() {
                return this.setTarget(Optional.empty());
            }

            @CanIgnoreReturnValue
            public Builder addArgs(CelExpr ... args) {
                Preconditions.checkNotNull((Object)args);
                return this.addArgs(Arrays.asList(args));
            }

            @CanIgnoreReturnValue
            public Builder addArgs(Iterable<CelExpr> args) {
                Preconditions.checkNotNull(args);
                args.forEach(this.mutableArgs::add);
                return this;
            }

            @CheckReturnValue
            abstract CelCall autoBuild();

            public CelCall build() {
                this.setArgs((ImmutableList<CelExpr>)ImmutableList.copyOf(this.mutableArgs));
                return this.autoBuild();
            }
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelList
    implements Expression.List<CelExpr> {
        @Override
        public abstract ImmutableList<CelExpr> elements();

        public abstract ImmutableList<Integer> optionalIndices();

        abstract Builder autoToBuilder();

        public Builder toBuilder() {
            Builder builder = this.autoToBuilder();
            builder.mutableElements = new ArrayList<CelExpr>((Collection<CelExpr>)builder.elements());
            return builder;
        }

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelList.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            private List<CelExpr> mutableElements = new ArrayList<CelExpr>();

            abstract ImmutableList<CelExpr> elements();

            abstract ImmutableList.Builder<Integer> optionalIndicesBuilder();

            @CanIgnoreReturnValue
            abstract Builder setElements(ImmutableList<CelExpr> var1);

            public ImmutableList<CelExpr> getElements() {
                return ImmutableList.copyOf(this.mutableElements);
            }

            public ImmutableList<dev.cel.common.ast.CelExpr$Builder> getElementsBuilders() {
                return (ImmutableList)this.mutableElements.stream().map(CelExpr::toBuilder).collect(ImmutableList.toImmutableList());
            }

            @CanIgnoreReturnValue
            public Builder setElement(int index, CelExpr element) {
                Preconditions.checkNotNull((Object)element);
                this.mutableElements.set(index, element);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addElements(CelExpr ... elements) {
                Preconditions.checkNotNull((Object)elements);
                return this.addElements(Arrays.asList(elements));
            }

            @CanIgnoreReturnValue
            public Builder addElements(Iterable<CelExpr> elements) {
                Preconditions.checkNotNull(elements);
                elements.forEach(this.mutableElements::add);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addOptionalIndices(Integer ... indices) {
                Preconditions.checkNotNull((Object)indices);
                return this.addOptionalIndices(Arrays.asList(indices));
            }

            @CanIgnoreReturnValue
            public Builder addOptionalIndices(Iterable<Integer> indices) {
                Preconditions.checkNotNull(indices);
                this.optionalIndicesBuilder().addAll(indices);
                return this;
            }

            abstract CelList autoBuild();

            @CheckReturnValue
            public CelList build() {
                this.setElements((ImmutableList<CelExpr>)ImmutableList.copyOf(this.mutableElements));
                return this.autoBuild();
            }
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelStruct
    implements Expression.Struct<Entry> {
        @Override
        public abstract String messageName();

        @Override
        public abstract ImmutableList<Entry> entries();

        abstract Builder autoToBuilder();

        public Builder toBuilder() {
            Builder builder = this.autoToBuilder();
            builder.mutableEntries = new ArrayList<Entry>((Collection<Entry>)builder.entries());
            return builder;
        }

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelStruct.Builder().setMessageName("");
        }

        @AutoValue.Builder
        public static abstract class Builder {
            private List<Entry> mutableEntries = new ArrayList<Entry>();

            abstract ImmutableList<Entry> entries();

            @CanIgnoreReturnValue
            public abstract Builder setMessageName(String var1);

            @CanIgnoreReturnValue
            abstract Builder setEntries(ImmutableList<Entry> var1);

            public ImmutableList<Entry> getEntries() {
                return ImmutableList.copyOf(this.mutableEntries);
            }

            public ImmutableList<Entry.Builder> getEntriesBuilders() {
                return (ImmutableList)this.mutableEntries.stream().map(Entry::toBuilder).collect(ImmutableList.toImmutableList());
            }

            @CanIgnoreReturnValue
            public Builder setEntry(int index, Entry entry) {
                Preconditions.checkNotNull((Object)entry);
                this.mutableEntries.set(index, entry);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addEntries(Entry ... entries) {
                Preconditions.checkNotNull((Object)entries);
                return this.addEntries(Arrays.asList(entries));
            }

            @CanIgnoreReturnValue
            public Builder addEntries(Iterable<Entry> entries) {
                Preconditions.checkNotNull(entries);
                entries.forEach(this.mutableEntries::add);
                return this;
            }

            abstract CelStruct autoBuild();

            @CheckReturnValue
            public CelStruct build() {
                this.setEntries((ImmutableList<Entry>)ImmutableList.copyOf(this.mutableEntries));
                return this.autoBuild();
            }
        }

        @Immutable
        @AutoValue
        public static abstract class Entry
        implements Expression.Struct.Entry<CelExpr> {
            @Override
            public abstract long id();

            @Override
            public abstract String fieldKey();

            @Override
            public abstract CelExpr value();

            @Override
            public abstract boolean optionalEntry();

            public abstract Builder toBuilder();

            public static Builder newBuilder() {
                return new AutoValue_CelExpr_CelStruct_Entry.Builder().setId(0L).setOptionalEntry(false);
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract long id();

                public abstract CelExpr value();

                public abstract Builder setId(long var1);

                public abstract Builder setFieldKey(String var1);

                public abstract Builder setValue(CelExpr var1);

                public abstract Builder setOptionalEntry(boolean var1);

                @CheckReturnValue
                public abstract Entry build();
            }
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelMap
    implements Expression.Map<Entry> {
        @Override
        public abstract ImmutableList<Entry> entries();

        abstract Builder autoToBuilder();

        public Builder toBuilder() {
            Builder builder = this.autoToBuilder();
            builder.mutableEntries = new ArrayList<Entry>((Collection<Entry>)builder.entries());
            return builder;
        }

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelMap.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            private List<Entry> mutableEntries = new ArrayList<Entry>();

            abstract ImmutableList<Entry> entries();

            @CanIgnoreReturnValue
            abstract Builder setEntries(ImmutableList<Entry> var1);

            public ImmutableList<Entry> getEntries() {
                return ImmutableList.copyOf(this.mutableEntries);
            }

            public ImmutableList<Entry.Builder> getEntriesBuilders() {
                return (ImmutableList)this.mutableEntries.stream().map(Entry::toBuilder).collect(ImmutableList.toImmutableList());
            }

            @CanIgnoreReturnValue
            public Builder setEntry(int index, Entry entry) {
                Preconditions.checkNotNull((Object)entry);
                this.mutableEntries.set(index, entry);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addEntries(Entry ... entries) {
                Preconditions.checkNotNull((Object)entries);
                return this.addEntries(Arrays.asList(entries));
            }

            @CanIgnoreReturnValue
            public Builder addEntries(Iterable<Entry> entries) {
                Preconditions.checkNotNull(entries);
                entries.forEach(this.mutableEntries::add);
                return this;
            }

            abstract CelMap autoBuild();

            @CheckReturnValue
            public CelMap build() {
                this.setEntries((ImmutableList<Entry>)ImmutableList.copyOf(this.mutableEntries));
                return this.autoBuild();
            }
        }

        @Immutable
        @AutoValue
        public static abstract class Entry
        implements Expression.Map.Entry<CelExpr> {
            @Override
            public abstract long id();

            @Override
            public abstract CelExpr key();

            @Override
            public abstract CelExpr value();

            @Override
            public abstract boolean optionalEntry();

            public abstract Builder toBuilder();

            public static Builder newBuilder() {
                return new AutoValue_CelExpr_CelMap_Entry.Builder().setId(0L).setOptionalEntry(false);
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract long id();

                public abstract CelExpr key();

                public abstract CelExpr value();

                public abstract Builder setId(long var1);

                public abstract Builder setKey(CelExpr var1);

                public abstract Builder setValue(CelExpr var1);

                public abstract Builder setOptionalEntry(boolean var1);

                @CheckReturnValue
                public abstract Entry build();
            }
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelComprehension
    implements Expression.Comprehension<CelExpr> {
        @Override
        public abstract String iterVar();

        @Override
        public abstract CelExpr iterRange();

        @Override
        public abstract String accuVar();

        @Override
        public abstract CelExpr accuInit();

        @Override
        public abstract CelExpr loopCondition();

        @Override
        public abstract CelExpr loopStep();

        @Override
        public abstract CelExpr result();

        public abstract Builder toBuilder();

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelComprehension.Builder().setIterVar("").setIterRange(CelExpr.newBuilder().build()).setAccuVar("").setAccuInit(CelExpr.newBuilder().build()).setLoopCondition(CelExpr.newBuilder().build()).setLoopStep(CelExpr.newBuilder().build()).setResult(CelExpr.newBuilder().build());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract String accuVar();

            public abstract CelExpr iterRange();

            public abstract CelExpr accuInit();

            public abstract CelExpr loopCondition();

            public abstract CelExpr loopStep();

            public abstract CelExpr result();

            public abstract Builder setIterVar(String var1);

            public abstract Builder setIterRange(CelExpr var1);

            public abstract Builder setAccuVar(String var1);

            public abstract Builder setAccuInit(CelExpr var1);

            public abstract Builder setLoopCondition(CelExpr var1);

            public abstract Builder setLoopStep(CelExpr var1);

            public abstract Builder setResult(CelExpr var1);

            @CheckReturnValue
            public abstract CelComprehension build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract long id();

        public abstract Builder setId(long var1);

        public abstract Builder setExprKind(ExprKind var1);

        public abstract ExprKind exprKind();

        public CelConstant constant() {
            return this.exprKind().constant();
        }

        public CelIdent ident() {
            return this.exprKind().ident();
        }

        public CelSelect select() {
            return this.exprKind().select();
        }

        public CelCall call() {
            return this.exprKind().call();
        }

        public CelList list() {
            return this.exprKind().list();
        }

        public CelStruct struct() {
            return this.exprKind().struct();
        }

        public CelMap map() {
            return this.exprKind().map();
        }

        public CelComprehension comprehension() {
            return this.exprKind().comprehension();
        }

        @CanIgnoreReturnValue
        public Builder setConstant(CelConstant constant) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.constant(constant));
        }

        @CanIgnoreReturnValue
        public Builder setIdent(CelIdent ident) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.ident(ident));
        }

        @CanIgnoreReturnValue
        public Builder setCall(CelCall call) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.call(call));
        }

        @CanIgnoreReturnValue
        public Builder setSelect(CelSelect select) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.select(select));
        }

        @CanIgnoreReturnValue
        public Builder setList(CelList list) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.list(list));
        }

        @CanIgnoreReturnValue
        public Builder setStruct(CelStruct struct) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.struct(struct));
        }

        @CanIgnoreReturnValue
        public Builder setMap(CelMap map) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.map(map));
        }

        @CanIgnoreReturnValue
        public Builder setComprehension(CelComprehension comprehension) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.comprehension(comprehension));
        }

        @CheckReturnValue
        public abstract CelExpr build();
    }

    @Immutable
    @AutoValue
    public static abstract class CelNotSet {
    }
}

