/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.AutoValue_CelSourceLocation;

@Immutable
@AutoValue
public abstract class CelSourceLocation
implements Comparable<CelSourceLocation> {
    public static final CelSourceLocation NONE = CelSourceLocation.of(-1, -1);

    CelSourceLocation() {
    }

    public abstract int getLine();

    public abstract int getColumn();

    @Override
    public final int compareTo(CelSourceLocation other) {
        int otherColumn;
        int otherLine;
        if (other != null) {
            otherLine = CelSourceLocation.positiveOrMax(other.getLine());
            otherColumn = CelSourceLocation.positiveOrMax(other.getColumn());
        } else {
            otherLine = Integer.MAX_VALUE;
            otherColumn = Integer.MAX_VALUE;
        }
        int diff = Integer.compare(CelSourceLocation.positiveOrMax(this.getLine()), otherLine);
        if (diff != 0) {
            return diff;
        }
        return Integer.compare(CelSourceLocation.positiveOrMax(this.getColumn()), otherColumn);
    }

    static Builder newBuilder() {
        return new AutoValue_CelSourceLocation.Builder();
    }

    public static CelSourceLocation of(int line, int column) {
        Preconditions.checkArgument((line >= -1 && line < Integer.MAX_VALUE ? 1 : 0) != 0);
        Preconditions.checkArgument((column >= -1 && column < Integer.MAX_VALUE ? 1 : 0) != 0);
        return CelSourceLocation.newBuilder().setLine(line).setColumn(column).build();
    }

    private static int positiveOrMax(int value) {
        return value >= 0 ? value : Integer.MAX_VALUE;
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setLine(int var1);

        abstract Builder setColumn(int var1);

        @CheckReturnValue
        abstract CelSourceLocation build();
    }
}

