/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.AutoValue_CelOptions;
import dev.cel.common.ExprFeatures;

@CheckReturnValue
@Immutable
@AutoValue
public abstract class CelOptions {
    public static final CelOptions DEFAULT = CelOptions.current().build();
    public static final CelOptions LEGACY = CelOptions.newBuilder().disableCelStandardEquality(true).build();

    CelOptions() {
    }

    public abstract boolean enableReservedIds();

    public abstract boolean enableOptionalSyntax();

    public abstract int maxExpressionCodePointSize();

    public abstract int maxParseErrorRecoveryLimit();

    public abstract int maxParseRecursionDepth();

    public abstract boolean populateMacroCalls();

    public abstract boolean retainRepeatedUnaryOperators();

    public abstract boolean retainUnbalancedLogicalExpressions();

    public abstract boolean enableCompileTimeOverloadResolution();

    public abstract boolean enableHomogeneousLiterals();

    public abstract boolean enableTimestampEpoch();

    public abstract boolean enableHeterogeneousNumericComparisons();

    public abstract boolean enableNamespacedDeclarations();

    public abstract boolean disableCelStandardEquality();

    public abstract boolean enableShortCircuiting();

    public abstract boolean enableRegexPartialMatch();

    public abstract boolean enableUnsignedComparisonAndArithmeticIsUnsigned();

    public abstract boolean enableUnsignedLongs();

    public abstract boolean enableProtoDifferencerEquality();

    public abstract boolean errorOnDuplicateMapKeys();

    public abstract boolean errorOnIntWrap();

    public abstract boolean resolveTypeDependencies();

    public abstract boolean enableUnknownTracking();

    public abstract boolean enableCelValue();

    public abstract int comprehensionMaxIterations();

    public abstract Builder toBuilder();

    public ImmutableSet<ExprFeatures> toExprFeatures() {
        ImmutableSet.Builder features = ImmutableSet.builder();
        if (this.enableCompileTimeOverloadResolution()) {
            features.add((Object)ExprFeatures.COMPILE_TIME_OVERLOAD_RESOLUTION);
        }
        if (this.disableCelStandardEquality()) {
            features.add((Object)ExprFeatures.LEGACY_JAVA_EQUALITY);
        }
        if (this.enableHomogeneousLiterals()) {
            features.add((Object)ExprFeatures.HOMOGENEOUS_LITERALS);
        }
        if (this.enableRegexPartialMatch()) {
            features.add((Object)ExprFeatures.REGEX_PARTIAL_MATCH);
        }
        if (this.enableReservedIds()) {
            features.add((Object)ExprFeatures.RESERVED_IDS);
        }
        if (this.enableUnsignedComparisonAndArithmeticIsUnsigned()) {
            features.add((Object)ExprFeatures.UNSIGNED_COMPARISON_AND_ARITHMETIC_IS_UNSIGNED);
        }
        if (this.retainRepeatedUnaryOperators()) {
            features.add((Object)ExprFeatures.RETAIN_REPEATED_UNARY_OPERATORS);
        }
        if (this.retainUnbalancedLogicalExpressions()) {
            features.add((Object)ExprFeatures.RETAIN_UNBALANCED_LOGICAL_EXPRESSIONS);
        }
        if (this.errorOnIntWrap()) {
            features.add((Object)ExprFeatures.ERROR_ON_WRAP);
        }
        if (this.errorOnDuplicateMapKeys()) {
            features.add((Object)ExprFeatures.ERROR_ON_DUPLICATE_KEYS);
        }
        if (this.populateMacroCalls()) {
            features.add((Object)ExprFeatures.POPULATE_MACRO_CALLS);
        }
        if (this.enableTimestampEpoch()) {
            features.add((Object)ExprFeatures.ENABLE_TIMESTAMP_EPOCH);
        }
        if (this.enableHeterogeneousNumericComparisons()) {
            features.add((Object)ExprFeatures.ENABLE_HETEROGENEOUS_NUMERIC_COMPARISONS);
        }
        if (this.enableNamespacedDeclarations()) {
            features.add((Object)ExprFeatures.ENABLE_NAMESPACED_DECLARATIONS);
        }
        if (this.enableUnsignedLongs()) {
            features.add((Object)ExprFeatures.ENABLE_UNSIGNED_LONGS);
        }
        if (this.enableProtoDifferencerEquality()) {
            features.add((Object)ExprFeatures.PROTO_DIFFERENCER_EQUALITY);
        }
        return features.build();
    }

    public static Builder newBuilder() {
        return new AutoValue_CelOptions.Builder().enableReservedIds(false).enableOptionalSyntax(false).maxExpressionCodePointSize(100000).maxParseErrorRecoveryLimit(30).maxParseRecursionDepth(250).populateMacroCalls(false).retainRepeatedUnaryOperators(false).retainUnbalancedLogicalExpressions(false).enableCompileTimeOverloadResolution(false).enableHomogeneousLiterals(false).enableTimestampEpoch(false).enableHeterogeneousNumericComparisons(false).enableNamespacedDeclarations(true).disableCelStandardEquality(true).enableShortCircuiting(true).enableRegexPartialMatch(false).enableUnsignedComparisonAndArithmeticIsUnsigned(false).enableUnsignedLongs(false).enableProtoDifferencerEquality(false).errorOnIntWrap(false).errorOnDuplicateMapKeys(false).resolveTypeDependencies(true).enableUnknownTracking(false).enableCelValue(false).comprehensionMaxIterations(-1);
    }

    public static Builder current() {
        return CelOptions.newBuilder().enableReservedIds(true).enableUnsignedComparisonAndArithmeticIsUnsigned(true).enableRegexPartialMatch(true).errorOnDuplicateMapKeys(true).errorOnIntWrap(true).resolveTypeDependencies(true).disableCelStandardEquality(false);
    }

    public static CelOptions fromExprFeatures(ImmutableSet<ExprFeatures> features) {
        return CelOptions.newBuilder().enableCompileTimeOverloadResolution(features.contains((Object)ExprFeatures.COMPILE_TIME_OVERLOAD_RESOLUTION)).disableCelStandardEquality(features.contains((Object)ExprFeatures.LEGACY_JAVA_EQUALITY)).enableHomogeneousLiterals(features.contains((Object)ExprFeatures.HOMOGENEOUS_LITERALS)).enableRegexPartialMatch(features.contains((Object)ExprFeatures.REGEX_PARTIAL_MATCH)).enableReservedIds(features.contains((Object)ExprFeatures.RESERVED_IDS)).enableUnsignedComparisonAndArithmeticIsUnsigned(features.contains((Object)ExprFeatures.UNSIGNED_COMPARISON_AND_ARITHMETIC_IS_UNSIGNED)).retainRepeatedUnaryOperators(features.contains((Object)ExprFeatures.RETAIN_REPEATED_UNARY_OPERATORS)).retainUnbalancedLogicalExpressions(features.contains((Object)ExprFeatures.RETAIN_UNBALANCED_LOGICAL_EXPRESSIONS)).errorOnIntWrap(features.contains((Object)ExprFeatures.ERROR_ON_WRAP)).errorOnDuplicateMapKeys(features.contains((Object)ExprFeatures.ERROR_ON_DUPLICATE_KEYS)).populateMacroCalls(features.contains((Object)ExprFeatures.POPULATE_MACRO_CALLS)).enableTimestampEpoch(features.contains((Object)ExprFeatures.ENABLE_TIMESTAMP_EPOCH)).enableHeterogeneousNumericComparisons(features.contains((Object)ExprFeatures.ENABLE_HETEROGENEOUS_NUMERIC_COMPARISONS)).enableNamespacedDeclarations(features.contains((Object)ExprFeatures.ENABLE_NAMESPACED_DECLARATIONS)).enableUnsignedLongs(features.contains((Object)ExprFeatures.ENABLE_UNSIGNED_LONGS)).enableProtoDifferencerEquality(features.contains((Object)ExprFeatures.PROTO_DIFFERENCER_EQUALITY)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder enableReservedIds(boolean var1);

        public abstract Builder enableOptionalSyntax(boolean var1);

        public abstract Builder maxExpressionCodePointSize(int var1);

        public abstract Builder maxParseErrorRecoveryLimit(int var1);

        public abstract Builder maxParseRecursionDepth(int var1);

        public abstract Builder populateMacroCalls(boolean var1);

        public abstract Builder retainRepeatedUnaryOperators(boolean var1);

        public abstract Builder retainUnbalancedLogicalExpressions(boolean var1);

        public abstract Builder enableCompileTimeOverloadResolution(boolean var1);

        @Deprecated
        public abstract Builder enableHomogeneousLiterals(boolean var1);

        public abstract Builder enableTimestampEpoch(boolean var1);

        public abstract Builder enableHeterogeneousNumericComparisons(boolean var1);

        @Deprecated
        public abstract Builder enableNamespacedDeclarations(boolean var1);

        public abstract Builder disableCelStandardEquality(boolean var1);

        public abstract Builder enableShortCircuiting(boolean var1);

        public abstract Builder enableRegexPartialMatch(boolean var1);

        public abstract Builder enableUnsignedComparisonAndArithmeticIsUnsigned(boolean var1);

        public abstract Builder enableUnsignedLongs(boolean var1);

        public abstract Builder enableProtoDifferencerEquality(boolean var1);

        public abstract Builder errorOnDuplicateMapKeys(boolean var1);

        public abstract Builder errorOnIntWrap(boolean var1);

        public abstract Builder resolveTypeDependencies(boolean var1);

        public abstract Builder enableUnknownTracking(boolean var1);

        public abstract Builder enableCelValue(boolean var1);

        public abstract Builder comprehensionMaxIterations(int var1);

        public abstract CelOptions build();
    }
}

