/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelSource;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelReference;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypes;
import dev.cel.common.types.SimpleType;
import dev.cel.expr.Type;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

@Immutable
public final class CelAbstractSyntaxTree {
    private final CelSource celSource;
    private final CelExpr celExpr;
    private final ImmutableMap<Long, CelReference> references;
    private final ImmutableMap<Long, CelType> types;

    public static CelAbstractSyntaxTree newParsedAst(CelExpr celExpr, CelSource celSource) {
        return new CelAbstractSyntaxTree(celExpr, celSource);
    }

    @Internal
    public static CelAbstractSyntaxTree newCheckedAst(CelExpr celExpr, CelSource celSource, Map<Long, CelReference> references, Map<Long, CelType> types) {
        return new CelAbstractSyntaxTree(celExpr, celSource, references, types);
    }

    private CelAbstractSyntaxTree(CelExpr celExpr, CelSource celSource) {
        this(celExpr, celSource, (Map<Long, CelReference>)ImmutableMap.of(), (Map<Long, CelType>)ImmutableMap.of());
    }

    private CelAbstractSyntaxTree(CelExpr celExpr, CelSource celSource, Map<Long, CelReference> references, Map<Long, CelType> types) {
        this.celExpr = celExpr;
        this.celSource = celSource;
        this.references = ImmutableMap.copyOf(references);
        this.types = ImmutableMap.copyOf(types);
    }

    public CelExpr getExpr() {
        return this.celExpr;
    }

    public boolean isChecked() {
        return !this.types.isEmpty();
    }

    public CelType getResultType() {
        return this.isChecked() ? this.getType(this.getExpr().id()).get() : SimpleType.DYN;
    }

    public Type getProtoResultType() {
        return CelTypes.celTypeToType(this.getResultType());
    }

    public CelSource getSource() {
        return this.celSource;
    }

    public Optional<CelType> getType(long exprId) {
        return Optional.ofNullable((CelType)this.types.get((Object)exprId));
    }

    public ImmutableMap<Long, CelType> getTypeMap() {
        return this.types;
    }

    public Optional<CelReference> getReference(long exprId) {
        return Optional.ofNullable((CelReference)this.references.get((Object)exprId));
    }

    public ImmutableMap<Long, CelReference> getReferenceMap() {
        return this.references;
    }

    public CelReference getReferenceOrThrow(long exprId) {
        return this.getReference(exprId).orElseThrow(() -> new NoSuchElementException("Expr Id not found: " + exprId));
    }

    Optional<CelConstant> findEnumValue(long exprId) {
        CelReference ref = (CelReference)this.references.get((Object)exprId);
        return ref != null ? ref.value() : Optional.empty();
    }

    Optional<ImmutableList<String>> findOverloadIDs(long exprId) {
        CelReference ref = (CelReference)this.references.get((Object)exprId);
        return ref != null && !ref.value().isPresent() ? Optional.of(ref.overloadIds()) : Optional.empty();
    }
}

