/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.checker.CelIdentDecl;
import dev.cel.checker.DescriptorTypeProvider;
import dev.cel.checker.Standard;
import dev.cel.checker.TypeFormatter;
import dev.cel.checker.TypeProvider;
import dev.cel.checker.Types;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelOptions;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.ExprFeatures;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelExprConverter;
import dev.cel.common.ast.CelReference;
import dev.cel.common.internal.Errors;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypes;
import dev.cel.common.types.OpaqueType;
import dev.cel.common.types.SimpleType;
import dev.cel.expr.Constant;
import dev.cel.expr.Decl;
import dev.cel.expr.Expr;
import dev.cel.expr.Type;
import dev.cel.parser.CelStandardMacro;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jspecify.nullness.Nullable;

@Internal
public class Env {
    public static final int ROOT_SCOPE = 0;
    public static final CelIdentDecl ERROR_IDENT_DECL = CelIdentDecl.newBuilder().setName("*error*").setType(SimpleType.ERROR).build();
    public static final CelFunctionDecl ERROR_FUNCTION_DECL = CelFunctionDecl.newBuilder().setName("*error*").build();
    private final TypeProvider typeProvider;
    private final ArrayList<DeclGroup> decls = new ArrayList();
    private final Map<Long, CelReference> referenceMap = new LinkedHashMap<Long, CelReference>();
    private final Map<Long, CelType> typeMap = new LinkedHashMap<Long, CelType>();
    private final Errors errors;
    private final CelOptions celOptions;

    private Env(Errors errors, TypeProvider typeProvider, DeclGroup declGroup, CelOptions celOptions) {
        this.celOptions = celOptions;
        this.errors = (Errors)Preconditions.checkNotNull((Object)errors);
        this.typeProvider = (TypeProvider)Preconditions.checkNotNull((Object)typeProvider);
        this.decls.add((DeclGroup)Preconditions.checkNotNull((Object)declGroup));
    }

    @Deprecated
    public static Env unconfigured(Errors errors, ExprFeatures ... exprFeatures) {
        return Env.unconfigured(errors, (TypeProvider)new DescriptorTypeProvider(), (ImmutableSet<ExprFeatures>)ImmutableSet.copyOf((Object[])exprFeatures));
    }

    @Deprecated
    public static Env unconfigured(Errors errors, TypeProvider typeProvider, ExprFeatures ... exprFeatures) {
        return Env.unconfigured(errors, typeProvider, (ImmutableSet<ExprFeatures>)ImmutableSet.copyOf((Object[])exprFeatures));
    }

    @Deprecated
    public static Env unconfigured(Errors errors, TypeProvider typeProvider, ImmutableSet<ExprFeatures> exprFeatures) {
        return Env.unconfigured(errors, typeProvider, CelOptions.fromExprFeatures(exprFeatures));
    }

    public static Env unconfigured(Errors errors, CelOptions celOptions) {
        return Env.unconfigured(errors, (TypeProvider)new DescriptorTypeProvider(), celOptions);
    }

    public static Env unconfigured(Errors errors, TypeProvider typeProvider, CelOptions celOptions) {
        return new Env(errors, typeProvider, new DeclGroup(), celOptions);
    }

    @Deprecated
    public static Env standard(Errors errors, ExprFeatures ... exprFeatures) {
        return Env.standard(errors, (TypeProvider)new DescriptorTypeProvider(), exprFeatures);
    }

    @Deprecated
    public static Env standard(Errors errors, TypeProvider typeProvider, ExprFeatures ... exprFeatures) {
        return Env.standard(errors, typeProvider, (ImmutableSet<ExprFeatures>)ImmutableSet.copyOf((Object[])exprFeatures));
    }

    @Deprecated
    public static Env standard(Errors errors, TypeProvider typeProvider, ImmutableSet<ExprFeatures> exprFeatures) {
        return Env.standard(errors, typeProvider, CelOptions.fromExprFeatures(exprFeatures));
    }

    public static Env standard(Errors errors, CelOptions celOptions) {
        return Env.standard(errors, (TypeProvider)new DescriptorTypeProvider(), celOptions);
    }

    public static Env standard(Errors errors, TypeProvider typeProvider, CelOptions celOptions) {
        Env env = Env.unconfigured(errors, typeProvider, celOptions);
        Standard.add(env);
        env.enterScope();
        return env;
    }

    public Errors getErrorContext() {
        return this.errors;
    }

    public TypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public void enterScope() {
        this.decls.add(new DeclGroup());
    }

    public void exitScope() {
        Preconditions.checkState((!this.decls.isEmpty() ? 1 : 0) != 0, (Object)"Cannot exit top-level environment scope");
        this.decls.remove(this.decls.size() - 1);
    }

    public int scopeDepth() {
        return this.decls.size() - 1;
    }

    public DeclGroup getDeclGroup() {
        return (DeclGroup)Iterables.getLast(this.decls);
    }

    public DeclGroup getDeclGroup(int scopeDepth) {
        Preconditions.checkArgument((scopeDepth <= this.scopeDepth() && scopeDepth >= 0 ? 1 : 0) != 0, (Object)"Invalid scope depth.");
        return this.decls.get(scopeDepth);
    }

    public void resetTypeAndRefMaps() {
        this.typeMap.clear();
        this.referenceMap.clear();
    }

    public Map<Long, CelReference> getRefMap() {
        return this.referenceMap;
    }

    public Map<Long, CelType> getTypeMap() {
        return this.typeMap;
    }

    @Deprecated
    public Type getType(Expr expr) {
        Preconditions.checkNotNull((Object)expr);
        return CelTypes.celTypeToType(this.getType(CelExprConverter.fromExpr(expr)));
    }

    public CelType getType(CelExpr expr) {
        return (CelType)Preconditions.checkNotNull((Object)this.typeMap.get(expr.id()), (Object)"expression has no type");
    }

    @CanIgnoreReturnValue
    public CelExpr setType(CelExpr expr, CelType type) {
        CelType oldType = this.typeMap.put(expr.id(), type);
        Preconditions.checkState((oldType == null || oldType.equals(type) ? 1 : 0) != 0, (String)"expression already has a type which is incompatible.\n old: %s\n new: %s", (Object)oldType, (Object)type);
        return expr;
    }

    public void setRef(CelExpr expr, CelReference reference) {
        CelReference oldReference = this.referenceMap.put(expr.id(), reference);
        Preconditions.checkState((oldReference == null || oldReference.equals(reference) ? 1 : 0) != 0, (Object)"expression already has a reference which is incompatible");
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Env add(Decl decl) {
        switch (decl.getDeclKindCase()) {
            case IDENT: {
                CelIdentDecl.Builder identBuilder = CelIdentDecl.newBuilder().setName(decl.getName()).setType(CelTypes.typeToCelType(decl.getIdent().getType())).setDoc(decl.getIdent().getDoc());
                if (decl.getIdent().hasValue()) {
                    identBuilder.setConstant(CelExprConverter.exprConstantToCelConstant(decl.getIdent().getValue()));
                }
                return this.add(identBuilder.build());
            }
            case FUNCTION: {
                ImmutableList.Builder overloadDeclBuilder = new ImmutableList.Builder();
                for (Decl.FunctionDecl.Overload overload : decl.getFunction().getOverloadsList()) {
                    overloadDeclBuilder.add((Object)CelOverloadDecl.overloadToCelOverload(overload));
                }
                return this.add(CelFunctionDecl.newBuilder().setName(decl.getName()).addOverloads((Iterable<CelOverloadDecl>)overloadDeclBuilder.build()).build());
            }
        }
        return this;
    }

    @CanIgnoreReturnValue
    public Env add(CelFunctionDecl celFunctionDecl) {
        return this.addFunction(Env.sanitizeFunction(celFunctionDecl));
    }

    @CanIgnoreReturnValue
    public Env add(CelIdentDecl celIdentDecl) {
        return this.addIdent(Env.sanitizeIdent(celIdentDecl));
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Env add(String name, Type type) {
        return this.add(CelIdentDecl.newIdentDeclaration(name, CelTypes.typeToCelType(type)));
    }

    @Deprecated
    public @Nullable Decl tryLookupFunction(String container, String name) {
        CelFunctionDecl decl = this.tryLookupCelFunction(container, name);
        if (decl == null) {
            return null;
        }
        return CelFunctionDecl.celFunctionDeclToDecl(decl);
    }

    public @Nullable CelFunctionDecl tryLookupCelFunction(String container, String name) {
        for (String cand : Env.qualifiedTypeNameCandidates(container, name)) {
            CelFunctionDecl decl = this.findFunctionDecl(cand);
            if (decl == null) continue;
            return decl;
        }
        return null;
    }

    @Deprecated
    public @Nullable Decl tryLookupIdent(String container, String name) {
        CelIdentDecl decl = this.tryLookupCelIdent(container, name);
        if (decl == null) {
            return null;
        }
        return CelIdentDecl.celIdentToDecl(decl);
    }

    public @Nullable CelIdentDecl tryLookupCelIdent(String container, String name) {
        for (String cand : Env.qualifiedTypeNameCandidates(container, name)) {
            CelIdentDecl decl = this.findIdentDecl(cand);
            if (decl != null) {
                return decl;
            }
            Optional<CelType> type = this.typeProvider.lookupCelType(cand);
            if (type.isPresent()) {
                decl = CelIdentDecl.newIdentDeclaration(cand, type.get());
                this.decls.get(0).putIdent(decl);
                return decl;
            }
            Integer enumValue = this.typeProvider.lookupEnumValue(cand);
            if (enumValue == null) continue;
            decl = CelIdentDecl.newBuilder().setName(cand).setType(SimpleType.INT).setConstant(CelConstant.ofValue(enumValue.intValue())).build();
            this.decls.get(0).putIdent(decl);
            return decl;
        }
        return null;
    }

    public CelIdentDecl lookupIdent(int position, String inContainer, String name) {
        CelIdentDecl result = this.tryLookupCelIdent(inContainer, name);
        if (result == null) {
            this.reportError(position, "undeclared reference to '%s' (in container '%s')", name, inContainer);
            return ERROR_IDENT_DECL;
        }
        return result;
    }

    public CelFunctionDecl lookupFunction(int position, String inContainer, String name) {
        CelFunctionDecl result = this.tryLookupCelFunction(inContainer, name);
        if (result == null) {
            this.reportError(position, "undeclared reference to '%s' (in container '%s')", name, inContainer);
            return ERROR_FUNCTION_DECL;
        }
        return result;
    }

    public void reportError(int position, String message, Object ... args) {
        this.errors.reportError(position, message, args);
    }

    boolean enableCompileTimeOverloadResolution() {
        return this.celOptions.enableCompileTimeOverloadResolution();
    }

    boolean enableHomogeneousLiterals() {
        return this.celOptions.enableHomogeneousLiterals();
    }

    boolean enableNamespacedDeclarations() {
        return this.celOptions.enableNamespacedDeclarations();
    }

    boolean enableHeterogeneousNumericComparisons() {
        return this.celOptions.enableHeterogeneousNumericComparisons();
    }

    boolean enableTimestampEpoch() {
        return this.celOptions.enableTimestampEpoch();
    }

    @CanIgnoreReturnValue
    private Env addIdent(CelIdentDecl celIdentDecl) {
        CelIdentDecl current = this.getDeclGroup().getIdent(celIdentDecl.name());
        if (current == null) {
            this.getDeclGroup().putIdent(celIdentDecl);
        } else {
            this.reportError(0, "overlapping declaration name '%s' (type '%s' cannot be distinguished from '%s')", celIdentDecl.name(), CelTypes.format(current.type()), CelTypes.format(celIdentDecl.type()));
        }
        return this;
    }

    @CanIgnoreReturnValue
    private Env addFunction(CelFunctionDecl decl) {
        CelFunctionDecl current = this.getDeclGroup().getFunction(decl.name());
        CelFunctionDecl.Builder builder = current != null ? current.toBuilder() : CelFunctionDecl.newBuilder().setName(decl.name());
        for (CelOverloadDecl overload : decl.overloads()) {
            this.addOverload(builder, overload);
        }
        this.getDeclGroup().putFunction(builder.build());
        return this;
    }

    private void addOverload(CelFunctionDecl.Builder builder, CelOverloadDecl overload) {
        ImmutableMap emptySubs = ImmutableMap.of();
        OpaqueType overloadFunction = CelTypes.createFunctionType(overload.resultType(), overload.parameterTypes());
        CelType overloadTypeErased = Types.substitute((Map<CelType, CelType>)emptySubs, overloadFunction, true);
        for (CelOverloadDecl existing : builder.overloads()) {
            OpaqueType existingFunction = CelTypes.createFunctionType(existing.resultType(), existing.parameterTypes());
            CelType existingTypeErased = Types.substitute((Map<CelType, CelType>)emptySubs, existingFunction, true);
            boolean overlap = Types.isAssignable((Map<CelType, CelType>)emptySubs, overloadTypeErased, existingTypeErased) != null || Types.isAssignable((Map<CelType, CelType>)emptySubs, existingTypeErased, overloadTypeErased) != null;
            if (!overlap || existing.isInstanceFunction() != overload.isInstanceFunction()) continue;
            this.reportError(0, "overlapping overload for name '%s' (type '%s' cannot be distinguished from '%s')", builder.name(), CelTypes.format(existingFunction), CelTypes.format(overloadFunction));
            return;
        }
        for (CelStandardMacro macro : CelStandardMacro.STANDARD_MACROS) {
            if (!macro.getFunction().equals(builder.name()) || macro.getDefinition().isReceiverStyle() != overload.isInstanceFunction() || macro.getDefinition().getArgumentCount() != overload.parameterTypes().size()) continue;
            this.reportError(0, "overload for name '%s' with %s argument(s) overlaps with predefined macro", builder.name(), macro.getDefinition().getArgumentCount());
            return;
        }
        builder.addOverloads(overload);
    }

    private @Nullable CelIdentDecl findIdentDecl(String name) {
        for (DeclGroup declGroup : Lists.reverse(this.decls)) {
            CelIdentDecl ident = declGroup.getIdent(name);
            if (ident == null) continue;
            return ident;
        }
        return null;
    }

    private @Nullable CelFunctionDecl findFunctionDecl(String name) {
        ArrayList<CelFunctionDecl> functions = new ArrayList<CelFunctionDecl>();
        for (DeclGroup declGroup : Lists.reverse(this.decls)) {
            CelFunctionDecl function = declGroup.getFunction(name);
            if (function == null) continue;
            functions.add(function);
        }
        if (functions.isEmpty()) {
            return null;
        }
        if (functions.size() == 1) {
            return (CelFunctionDecl)functions.get(0);
        }
        HashMap<String, CelOverloadDecl> overloadSignatureMap = new HashMap<String, CelOverloadDecl>();
        for (CelFunctionDecl function : functions) {
            for (CelOverloadDecl overload : function.overloads()) {
                String overloadSignature = TypeFormatter.formatFunction(null, overload.parameterTypes(), overload.isInstanceFunction(), true);
                overloadSignatureMap.putIfAbsent(overloadSignature, overload);
            }
        }
        return CelFunctionDecl.newBuilder().setName(name).addOverloads(overloadSignatureMap.values()).build();
    }

    private static ImmutableList<String> qualifiedTypeNameCandidates(String container, String typeName) {
        if (typeName.startsWith(".")) {
            return ImmutableList.of((Object)typeName.substring(1));
        }
        if (container.isEmpty()) {
            return ImmutableList.of((Object)typeName);
        }
        int i = container.lastIndexOf(46);
        return ImmutableList.builder().add((Object)(container + "." + typeName)).addAll(Env.qualifiedTypeNameCandidates(i >= 0 ? container.substring(0, i) : "", typeName)).build();
    }

    private static CelIdentDecl sanitizeIdent(CelIdentDecl decl) {
        CelType type = decl.type();
        if (!Env.isWellKnownType(type)) {
            return decl;
        }
        return CelIdentDecl.newIdentDeclaration(decl.name(), Env.getWellKnownType(decl.type()));
    }

    private static CelFunctionDecl sanitizeFunction(CelFunctionDecl func) {
        boolean needsSanitizing = false;
        block0: for (CelOverloadDecl o : func.overloads()) {
            if (Env.isWellKnownType(o.resultType())) {
                needsSanitizing = true;
                break;
            }
            for (CelType p : o.parameterTypes()) {
                if (!Env.isWellKnownType(p)) continue;
                needsSanitizing = true;
                continue block0;
            }
        }
        if (!needsSanitizing) {
            return func;
        }
        CelFunctionDecl.Builder funcBuilder = func.toBuilder();
        ImmutableSet.Builder overloadsBuilder = new ImmutableSet.Builder();
        for (CelOverloadDecl overloadDecl : funcBuilder.overloads()) {
            CelOverloadDecl.Builder overloadBuilder = overloadDecl.toBuilder();
            CelType resultType = overloadBuilder.build().resultType();
            if (Env.isWellKnownType(resultType)) {
                overloadBuilder.setResultType(Env.getWellKnownType(resultType));
            }
            ImmutableList.Builder parameterTypeBuilder = ImmutableList.builder();
            for (CelType paramType : overloadBuilder.parameterTypes()) {
                if (Env.isWellKnownType(paramType)) {
                    parameterTypeBuilder.add((Object)Env.getWellKnownType(paramType));
                    continue;
                }
                parameterTypeBuilder.add((Object)paramType);
            }
            overloadBuilder.setParameterTypes((ImmutableList<CelType>)parameterTypeBuilder.build());
            overloadsBuilder.add((Object)overloadBuilder.build());
        }
        return funcBuilder.setOverloads((ImmutableSet<CelOverloadDecl>)overloadsBuilder.build()).build();
    }

    static boolean isWellKnownType(CelType type) {
        return type.kind() == CelKind.STRUCT && CelTypes.isWellKnownType(type.name());
    }

    static CelType getWellKnownType(CelType type) {
        Preconditions.checkArgument((type.kind() == CelKind.STRUCT ? 1 : 0) != 0);
        return CelTypes.getWellKnownCelType(type.name()).get();
    }

    public static class DeclGroup {
        private final Map<String, CelIdentDecl> idents;
        private final Map<String, CelFunctionDecl> functions;

        public DeclGroup() {
            this(new HashMap<String, CelIdentDecl>(), new HashMap<String, CelFunctionDecl>());
        }

        public DeclGroup(Map<String, CelIdentDecl> idents, Map<String, CelFunctionDecl> functions) {
            this.functions = functions;
            this.idents = idents;
        }

        public Map<String, CelIdentDecl> getIdents() {
            return ImmutableMap.copyOf(this.idents);
        }

        public Map<String, CelFunctionDecl> getFunctions() {
            return ImmutableMap.copyOf(this.functions);
        }

        public @Nullable CelIdentDecl getIdent(String name) {
            return this.idents.get(name);
        }

        public void putIdent(CelIdentDecl ident) {
            this.idents.put(ident.name(), ident);
        }

        public @Nullable CelFunctionDecl getFunction(String name) {
            return this.functions.get(name);
        }

        public void putFunction(CelFunctionDecl function) {
            this.functions.put(function.name(), function);
        }

        public DeclGroup immutableCopy() {
            return new DeclGroup(this.getIdents(), this.getFunctions());
        }
    }

    @Deprecated
    public static final class FunctionBuilder {
        private final String name;
        private final List<CelOverloadDecl> overloads = new ArrayList<CelOverloadDecl>();
        private final boolean isInstance;

        public FunctionBuilder(String name) {
            this(name, false);
        }

        public FunctionBuilder(String name, boolean isInstance) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.isInstance = isInstance;
        }

        @CanIgnoreReturnValue
        public FunctionBuilder sameAs(Decl func, String idPart, String idPartReplace) {
            Preconditions.checkNotNull((Object)func);
            for (Decl.FunctionDecl.Overload overload : func.getFunction().getOverloadsList()) {
                this.overloads.add(CelOverloadDecl.overloadToCelOverload(overload).toBuilder().setOverloadId(overload.getOverloadId().replace(idPart, idPartReplace)).build());
            }
            return this;
        }

        @CanIgnoreReturnValue
        public FunctionBuilder add(String id, Type resultType, Type ... argTypes) {
            return this.add(id, resultType, (Iterable<Type>)ImmutableList.copyOf((Object[])argTypes));
        }

        @CanIgnoreReturnValue
        public FunctionBuilder add(String id, Type resultType, Iterable<Type> argTypes) {
            ImmutableList.Builder argumentBuilder = new ImmutableList.Builder();
            for (Type type : argTypes) {
                argumentBuilder.add((Object)CelTypes.typeToCelType(type));
            }
            this.overloads.add(CelOverloadDecl.newBuilder().setOverloadId(id).setResultType(CelTypes.typeToCelType(resultType)).addParameterTypes((Iterable<CelType>)argumentBuilder.build()).setIsInstanceFunction(this.isInstance).build());
            return this;
        }

        @CanIgnoreReturnValue
        public FunctionBuilder add(String id, List<String> typeParams, Type resultType, Type ... argTypes) {
            return this.add(id, typeParams, resultType, (Iterable<Type>)ImmutableList.copyOf((Object[])argTypes));
        }

        @CanIgnoreReturnValue
        public FunctionBuilder add(String id, List<String> typeParams, Type resultType, Iterable<Type> argTypes) {
            ImmutableList.Builder argumentBuilder = new ImmutableList.Builder();
            for (Type type : argTypes) {
                argumentBuilder.add((Object)CelTypes.typeToCelType(type));
            }
            this.overloads.add(CelOverloadDecl.newBuilder().setOverloadId(id).setResultType(CelTypes.typeToCelType(resultType)).addParameterTypes((Iterable<CelType>)argumentBuilder.build()).setIsInstanceFunction(this.isInstance).build());
            return this;
        }

        @CanIgnoreReturnValue
        public FunctionBuilder doc(@Nullable String value) {
            int current = this.overloads.size() - 1;
            CelOverloadDecl.Builder builder = this.overloads.get(current).toBuilder();
            if (value == null) {
                builder.setDoc("");
            } else {
                builder.setDoc(value);
            }
            this.overloads.set(current, builder.build());
            return this;
        }

        @CheckReturnValue
        public Decl build() {
            return CelFunctionDecl.celFunctionDeclToDecl(CelFunctionDecl.newBuilder().setName(this.name).addOverloads(this.overloads).build());
        }
    }

    @Deprecated
    public static final class IdentBuilder {
        private final CelIdentDecl.Builder builder = CelIdentDecl.newBuilder();

        public IdentBuilder(String name) {
            this.builder.setName((String)Preconditions.checkNotNull((Object)name));
        }

        @CanIgnoreReturnValue
        public IdentBuilder type(Type value) {
            Preconditions.checkNotNull((Object)value);
            this.builder.setType(CelTypes.typeToCelType((Type)Preconditions.checkNotNull((Object)value)));
            return this;
        }

        @CanIgnoreReturnValue
        public IdentBuilder value(@Nullable Constant value) {
            if (value == null) {
                this.builder.clearConstant();
            } else {
                this.builder.setConstant(CelExprConverter.exprConstantToCelConstant(value));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public IdentBuilder doc(@Nullable String value) {
            if (value == null) {
                this.builder.setDoc("");
            } else {
                this.builder.setDoc(value);
            }
            return this;
        }

        public Decl build() {
            return CelIdentDecl.celIdentToDecl(this.builder.build());
        }
    }
}

