/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.checker.AutoValue_CelIdentDecl;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExprConverter;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypes;
import dev.cel.expr.Decl;
import java.util.Optional;

@Immutable
@AutoValue
@Internal
public abstract class CelIdentDecl {
    public abstract String name();

    public abstract CelType type();

    public abstract Optional<CelConstant> constant();

    public abstract String doc();

    public static Decl celIdentToDecl(CelIdentDecl identDecl) {
        Decl.IdentDecl.Builder identBuilder = Decl.IdentDecl.newBuilder().setDoc(identDecl.doc()).setType(CelTypes.celTypeToType(identDecl.type()));
        if (identDecl.constant().isPresent()) {
            identBuilder.setValue(CelExprConverter.celConstantToExprConstant(identDecl.constant().get()));
        }
        return Decl.newBuilder().setName(identDecl.name()).setIdent(identBuilder).build();
    }

    @CheckReturnValue
    public static CelIdentDecl newIdentDeclaration(String name, CelType type) {
        return CelIdentDecl.newBuilder().setName(name).setType(type).build();
    }

    public static Builder newBuilder() {
        return new AutoValue_CelIdentDecl.Builder().setDoc("");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @CanIgnoreReturnValue
        public abstract Builder setName(String var1);

        @CanIgnoreReturnValue
        public abstract Builder setType(CelType var1);

        @CanIgnoreReturnValue
        public abstract Builder setConstant(CelConstant var1);

        @CanIgnoreReturnValue
        public abstract Builder setConstant(Optional<CelConstant> var1);

        @CanIgnoreReturnValue
        public abstract Builder setDoc(String var1);

        @CanIgnoreReturnValue
        public Builder clearConstant() {
            return this.setConstant(Optional.empty());
        }

        @CheckReturnValue
        public abstract CelIdentDecl build();
    }
}

