/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import dev.cel.checker.CelChecker;
import dev.cel.checker.CelCheckerBuilder;
import dev.cel.checker.CelCheckerLibrary;
import dev.cel.checker.CelIdentDecl;
import dev.cel.checker.Env;
import dev.cel.checker.ExprChecker;
import dev.cel.checker.ProtoTypeMask;
import dev.cel.checker.ProtoTypeMaskTypeProvider;
import dev.cel.checker.TypeProvider;
import dev.cel.checker.TypeProviderLegacyImpl;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelDescriptorUtil;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelIssue;
import dev.cel.common.CelOptions;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.CelSource;
import dev.cel.common.CelSourceLocation;
import dev.cel.common.CelValidationResult;
import dev.cel.common.CelVarDecl;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelExprConverter;
import dev.cel.common.internal.EnvVisitable;
import dev.cel.common.internal.EnvVisitor;
import dev.cel.common.internal.Errors;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypeProvider;
import dev.cel.common.types.CelTypes;
import dev.cel.common.types.ProtoMessageTypeProvider;
import dev.cel.expr.Decl;
import dev.cel.expr.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;

@Immutable
@Internal
public final class CelCheckerLegacyImpl
implements CelChecker,
EnvVisitable {
    private final CelOptions celOptions;
    private final String container;
    private final ImmutableSet<CelIdentDecl> identDeclarations;
    private final ImmutableSet<CelFunctionDecl> functionDeclarations;
    private final Optional<CelType> expectedResultType;
    private final TypeProvider typeProvider;
    private final boolean standardEnvironmentEnabled;
    private final Builder checkerBuilder;

    @Override
    public CelValidationResult check(CelAbstractSyntaxTree ast) {
        CelSource source = ast.getSource();
        Errors errors = new Errors(source.getDescription(), source.getContent().toString());
        Env env = this.getEnv(errors);
        if (errors.getErrorCount() > 0) {
            return new CelValidationResult(source, CelCheckerLegacyImpl.errorsToIssues(errors));
        }
        CelAbstractSyntaxTree checkedAst = ExprChecker.typecheck(env, this.container, ast, this.expectedResultType);
        if (errors.getErrorCount() > 0) {
            return new CelValidationResult(source, CelCheckerLegacyImpl.errorsToIssues(errors));
        }
        return new CelValidationResult(checkedAst, (ImmutableList<CelIssue>)ImmutableList.of());
    }

    @Override
    public CelCheckerBuilder toCheckerBuilder() {
        return new Builder(this.checkerBuilder);
    }

    @Override
    public void accept(EnvVisitor envVisitor) {
        Errors errors = new Errors("", "");
        Env env = this.getEnv(errors);
        for (int i = env.scopeDepth(); i >= 0; --i) {
            Env.DeclGroup declGroup = env.getDeclGroup(i);
            TreeSet<String> names = new TreeSet<String>();
            names.addAll(declGroup.getIdents().keySet());
            names.addAll(declGroup.getFunctions().keySet());
            for (String name : names) {
                CelIdentDecl ident = declGroup.getIdent(name);
                CelFunctionDecl func = declGroup.getFunction(name);
                ArrayList<Decl> decls = new ArrayList<Decl>();
                if (ident != null) {
                    decls.add(CelIdentDecl.celIdentToDecl(ident));
                }
                if (func != null) {
                    decls.add(CelFunctionDecl.celFunctionDeclToDecl(func));
                }
                envVisitor.visitDecl(name, decls);
            }
        }
    }

    private Env getEnv(Errors errors) {
        Env env = this.standardEnvironmentEnabled ? Env.standard(errors, this.typeProvider, this.celOptions) : Env.unconfigured(errors, this.typeProvider, this.celOptions);
        this.identDeclarations.forEach(env::add);
        this.functionDeclarations.forEach(env::add);
        return env;
    }

    public static CelCheckerBuilder newBuilder() {
        return new Builder();
    }

    private CelCheckerLegacyImpl(CelOptions celOptions, String container, ImmutableSet<CelIdentDecl> identDeclarations, ImmutableSet<CelFunctionDecl> functionDeclarations, Optional<CelType> expectedResultType, TypeProvider typeProvider, boolean standardEnvironmentEnabled, Builder checkerBuilder) {
        this.celOptions = celOptions;
        this.container = container;
        this.identDeclarations = identDeclarations;
        this.functionDeclarations = functionDeclarations;
        this.expectedResultType = expectedResultType;
        this.typeProvider = typeProvider;
        this.standardEnvironmentEnabled = standardEnvironmentEnabled;
        this.checkerBuilder = new Builder(checkerBuilder);
    }

    private static ImmutableList<CelIssue> errorsToIssues(Errors errors) {
        ImmutableList<Errors.Error> errorList = errors.getErrors();
        CelIssue.Builder issueBuilder = CelIssue.newBuilder().setSeverity(CelIssue.Severity.ERROR);
        return (ImmutableList)errorList.stream().map(e -> {
            Errors.SourceLocation loc = errors.getPositionLocation(e.position());
            CelSourceLocation newLoc = CelSourceLocation.of(loc.line(), loc.column() - 1);
            return issueBuilder.setMessage(e.rawMessage()).setSourceLocation(newLoc).build();
        }).collect(ImmutableList.toImmutableList());
    }

    public static final class Builder
    implements CelCheckerBuilder {
        private final ImmutableSet.Builder<CelIdentDecl> identDeclarations;
        private final ImmutableSet.Builder<CelFunctionDecl> functionDeclarations;
        private final ImmutableSet.Builder<ProtoTypeMask> protoTypeMasks;
        private final ImmutableSet.Builder<Descriptors.Descriptor> messageTypes;
        private final ImmutableSet.Builder<Descriptors.FileDescriptor> fileTypes;
        private final ImmutableSet.Builder<CelCheckerLibrary> celCheckerLibraries;
        private CelOptions celOptions;
        private String container;
        private CelType expectedResultType;
        private TypeProvider customTypeProvider;
        private CelTypeProvider celTypeProvider;
        private boolean standardEnvironmentEnabled;

        @Override
        public CelCheckerBuilder setOptions(CelOptions celOptions) {
            this.celOptions = (CelOptions)Preconditions.checkNotNull((Object)celOptions);
            return this;
        }

        @Override
        public CelCheckerBuilder setContainer(String container) {
            Preconditions.checkNotNull((Object)container);
            this.container = container;
            return this;
        }

        @Override
        public CelCheckerBuilder addDeclarations(Decl ... declarations) {
            Preconditions.checkNotNull((Object)declarations);
            return this.addDeclarations(Arrays.asList(declarations));
        }

        @Override
        public CelCheckerBuilder addDeclarations(Iterable<Decl> declarations) {
            Preconditions.checkNotNull(declarations);
            block4: for (Decl decl : declarations) {
                switch (decl.getDeclKindCase()) {
                    case IDENT: {
                        CelIdentDecl.Builder identBuilder = CelIdentDecl.newBuilder().setName(decl.getName()).setType(CelTypes.typeToCelType(decl.getIdent().getType())).setDoc(decl.getIdent().getDoc());
                        if (decl.getIdent().hasValue()) {
                            identBuilder.setConstant(CelExprConverter.exprConstantToCelConstant(decl.getIdent().getValue()));
                        }
                        this.identDeclarations.add((Object)identBuilder.build());
                        continue block4;
                    }
                    case FUNCTION: {
                        this.addFunctionDeclarations(CelFunctionDecl.newFunctionDeclaration(decl.getName(), (Iterable)decl.getFunction().getOverloadsList().stream().map(CelOverloadDecl::overloadToCelOverload).collect(ImmutableList.toImmutableList())));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("unexpected decl kind: " + (Object)((Object)decl.getDeclKindCase()));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public CelCheckerBuilder addFunctionDeclarations(CelFunctionDecl ... celFunctionDecls) {
            Preconditions.checkNotNull((Object)celFunctionDecls);
            return this.addFunctionDeclarations(Arrays.asList(celFunctionDecls));
        }

        @Override
        public CelCheckerBuilder addFunctionDeclarations(Iterable<CelFunctionDecl> celFunctionDecls) {
            Preconditions.checkNotNull(celFunctionDecls);
            this.functionDeclarations.addAll(celFunctionDecls);
            return this;
        }

        @Override
        public CelCheckerBuilder addVarDeclarations(CelVarDecl ... celVarDecls) {
            Preconditions.checkNotNull((Object)celVarDecls);
            return this.addVarDeclarations(Arrays.asList(celVarDecls));
        }

        @Override
        public CelCheckerBuilder addVarDeclarations(Iterable<CelVarDecl> celVarDecls) {
            Preconditions.checkNotNull(celVarDecls);
            for (CelVarDecl celVarDecl : celVarDecls) {
                this.identDeclarations.add((Object)CelIdentDecl.newIdentDeclaration(celVarDecl.name(), celVarDecl.type()));
            }
            return this;
        }

        @Override
        public CelCheckerBuilder addProtoTypeMasks(ProtoTypeMask ... typeMasks) {
            Preconditions.checkNotNull((Object)typeMasks);
            return this.addProtoTypeMasks(Arrays.asList(typeMasks));
        }

        @Override
        public CelCheckerBuilder addProtoTypeMasks(Iterable<ProtoTypeMask> typeMasks) {
            Preconditions.checkNotNull(typeMasks);
            this.protoTypeMasks.addAll(typeMasks);
            return this;
        }

        @Override
        public CelCheckerBuilder setResultType(CelType resultType) {
            Preconditions.checkNotNull((Object)resultType);
            this.expectedResultType = resultType;
            return this;
        }

        @Override
        public CelCheckerBuilder setProtoResultType(Type resultType) {
            Preconditions.checkNotNull((Object)resultType);
            return this.setResultType(CelTypes.typeToCelType(resultType));
        }

        @Override
        @Deprecated
        public CelCheckerBuilder setTypeProvider(TypeProvider typeProvider) {
            this.customTypeProvider = typeProvider;
            return this;
        }

        @Override
        public CelCheckerBuilder setTypeProvider(CelTypeProvider celTypeProvider) {
            this.celTypeProvider = celTypeProvider;
            return this;
        }

        @Override
        public CelCheckerBuilder addMessageTypes(Descriptors.Descriptor ... descriptors) {
            return this.addMessageTypes(Arrays.asList((Descriptors.Descriptor[])Preconditions.checkNotNull((Object)descriptors)));
        }

        @Override
        public CelCheckerBuilder addMessageTypes(Iterable<Descriptors.Descriptor> descriptors) {
            this.messageTypes.addAll((Iterable)Preconditions.checkNotNull(descriptors));
            return this;
        }

        @Override
        public CelCheckerBuilder addFileTypes(Descriptors.FileDescriptor ... fileDescriptors) {
            return this.addFileTypes(Arrays.asList((Descriptors.FileDescriptor[])Preconditions.checkNotNull((Object)fileDescriptors)));
        }

        @Override
        public CelCheckerBuilder addFileTypes(Iterable<Descriptors.FileDescriptor> fileDescriptors) {
            this.fileTypes.addAll((Iterable)Preconditions.checkNotNull(fileDescriptors));
            return this;
        }

        @Override
        public CelCheckerBuilder addFileTypes(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
            Preconditions.checkNotNull((Object)fileDescriptorSet);
            return this.addFileTypes((Iterable<Descriptors.FileDescriptor>)CelDescriptorUtil.getFileDescriptorsFromFileDescriptorSet(fileDescriptorSet));
        }

        @Override
        public CelCheckerBuilder setStandardEnvironmentEnabled(boolean value) {
            this.standardEnvironmentEnabled = value;
            return this;
        }

        @Override
        public CelCheckerBuilder addLibraries(CelCheckerLibrary ... libraries) {
            Preconditions.checkNotNull((Object)libraries);
            return this.addLibraries(Arrays.asList(libraries));
        }

        @Override
        public CelCheckerBuilder addLibraries(Iterable<? extends CelCheckerLibrary> libraries) {
            Preconditions.checkNotNull(libraries);
            this.celCheckerLibraries.addAll(libraries);
            return this;
        }

        @VisibleForTesting
        ImmutableSet.Builder<CelFunctionDecl> getFunctionDecls() {
            return this.functionDeclarations;
        }

        @VisibleForTesting
        ImmutableSet.Builder<CelIdentDecl> getIdentDecls() {
            return this.identDeclarations;
        }

        @VisibleForTesting
        ImmutableSet.Builder<ProtoTypeMask> getProtoTypeMasks() {
            return this.protoTypeMasks;
        }

        @VisibleForTesting
        ImmutableSet.Builder<Descriptors.Descriptor> getMessageTypes() {
            return this.messageTypes;
        }

        @VisibleForTesting
        ImmutableSet.Builder<Descriptors.FileDescriptor> getFileTypes() {
            return this.fileTypes;
        }

        @VisibleForTesting
        ImmutableSet.Builder<CelCheckerLibrary> getCheckerLibraries() {
            return this.celCheckerLibraries;
        }

        @Override
        @CheckReturnValue
        public CelCheckerLegacyImpl build() {
            this.celCheckerLibraries.build().forEach(celLibrary -> celLibrary.setCheckerOptions(this));
            ImmutableSet fileTypeSet = this.fileTypes.build();
            ImmutableSet messageTypeSet = this.messageTypes.build();
            if (!messageTypeSet.isEmpty()) {
                fileTypeSet = new ImmutableSet.Builder().addAll((Iterable)fileTypeSet).addAll((Iterable)messageTypeSet.stream().map(Descriptors.Descriptor::getFile).collect(ImmutableSet.toImmutableSet())).build();
            }
            CelTypeProvider messageTypeProvider = new ProtoMessageTypeProvider(CelDescriptorUtil.getAllDescriptorsFromFileDescriptor((Iterable<Descriptors.FileDescriptor>)fileTypeSet, this.celOptions.resolveTypeDependencies()));
            if (this.celTypeProvider != null && fileTypeSet.isEmpty()) {
                messageTypeProvider = this.celTypeProvider;
            } else if (this.celTypeProvider != null) {
                messageTypeProvider = new CelTypeProvider.CombinedCelTypeProvider((ImmutableList<CelTypeProvider>)ImmutableList.of((Object)this.celTypeProvider, (Object)messageTypeProvider));
            }
            ImmutableSet identDeclarationSet = this.identDeclarations.build();
            ImmutableSet protoTypeMaskSet = this.protoTypeMasks.build();
            if (!protoTypeMaskSet.isEmpty()) {
                ProtoTypeMaskTypeProvider protoTypeMaskTypeProvider = new ProtoTypeMaskTypeProvider(messageTypeProvider, (ImmutableSet<ProtoTypeMask>)protoTypeMaskSet);
                identDeclarationSet = ImmutableSet.builder().addAll((Iterable)identDeclarationSet).addAll(protoTypeMaskTypeProvider.computeDeclsFromProtoTypeMasks()).build();
                messageTypeProvider = protoTypeMaskTypeProvider;
            }
            TypeProvider legacyProvider = new TypeProviderLegacyImpl(messageTypeProvider);
            if (this.customTypeProvider != null) {
                legacyProvider = new TypeProvider.CombinedTypeProvider((Iterable<TypeProvider>)ImmutableList.of((Object)this.customTypeProvider, (Object)legacyProvider));
            }
            return new CelCheckerLegacyImpl(this.celOptions, this.container, identDeclarationSet, this.functionDeclarations.build(), Optional.fromNullable((Object)this.expectedResultType), legacyProvider, this.standardEnvironmentEnabled, this);
        }

        private Builder() {
            this.celOptions = CelOptions.newBuilder().build();
            this.identDeclarations = ImmutableSet.builder();
            this.functionDeclarations = ImmutableSet.builder();
            this.fileTypes = ImmutableSet.builder();
            this.messageTypes = ImmutableSet.builder();
            this.protoTypeMasks = ImmutableSet.builder();
            this.celCheckerLibraries = ImmutableSet.builder();
            this.container = "";
        }

        private Builder(Builder builder) {
            this.celOptions = builder.celOptions;
            this.celTypeProvider = builder.celTypeProvider;
            this.container = builder.container;
            this.customTypeProvider = builder.customTypeProvider;
            this.expectedResultType = builder.expectedResultType;
            this.standardEnvironmentEnabled = builder.standardEnvironmentEnabled;
            this.functionDeclarations = Builder.deepCopy(builder.functionDeclarations);
            this.identDeclarations = Builder.deepCopy(builder.identDeclarations);
            this.fileTypes = Builder.deepCopy(builder.fileTypes);
            this.messageTypes = Builder.deepCopy(builder.messageTypes);
            this.protoTypeMasks = Builder.deepCopy(builder.protoTypeMasks);
            this.celCheckerLibraries = Builder.deepCopy(builder.celCheckerLibraries);
        }

        private static <T> ImmutableSet.Builder<T> deepCopy(ImmutableSet.Builder<T> builderToCopy) {
            ImmutableSet.Builder newBuilder = ImmutableSet.builder();
            newBuilder.addAll((Iterable)builderToCopy.build());
            return newBuilder;
        }
    }
}

