/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.cel.common.CelIssue;
import dev.cel.common.ast.CelExpr;
import dev.cel.parser.CelMacro;
import dev.cel.parser.CelMacroExprFactory;
import dev.cel.parser.Operator;
import java.util.Optional;

public enum CelStandardMacro {
    HAS(CelMacro.newGlobalMacro(Operator.HAS.getFunction(), 1, CelStandardMacro::expandHasMacro)),
    ALL(CelMacro.newReceiverMacro(Operator.ALL.getFunction(), 2, CelStandardMacro::expandAllMacro)),
    EXISTS(CelMacro.newReceiverMacro(Operator.EXISTS.getFunction(), 2, CelStandardMacro::expandExistsMacro)),
    EXISTS_ONE(CelMacro.newReceiverMacro(Operator.EXISTS_ONE.getFunction(), 2, CelStandardMacro::expandExistsOneMacro)),
    MAP(CelMacro.newReceiverMacro(Operator.MAP.getFunction(), 2, CelStandardMacro::expandMapMacro)),
    MAP_FILTER(CelMacro.newReceiverMacro(Operator.MAP.getFunction(), 3, CelStandardMacro::expandMapMacro)),
    FILTER(CelMacro.newReceiverMacro(Operator.FILTER.getFunction(), 2, CelStandardMacro::expandFilterMacro));

    public static final ImmutableSet<CelStandardMacro> STANDARD_MACROS;
    private static final String ACCUMULATOR_VAR = "__result__";
    private final CelMacro macro;

    private CelStandardMacro(CelMacro macro) {
        this.macro = macro;
    }

    public String getFunction() {
        return this.macro.getFunction();
    }

    public CelMacro getDefinition() {
        return this.macro;
    }

    private static Optional<CelExpr> expandHasMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0);
        CelExpr arg = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg.exprKind().getKind() != CelExpr.ExprKind.Kind.SELECT) {
            return Optional.of(exprFactory.reportError("invalid argument to has() macro"));
        }
        return Optional.of(exprFactory.newSelect(arg.select().operand(), arg.select().field(), true));
    }

    private static Optional<CelExpr> expandAllMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CelExpr arg0 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelStandardMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
        CelExpr accuInit = exprFactory.newBoolLiteral(true);
        CelExpr condition = exprFactory.newGlobalCall(Operator.NOT_STRICTLY_FALSE.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR));
        CelExpr step = exprFactory.newGlobalCall(Operator.LOGICAL_AND.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), arg1);
        CelExpr result = exprFactory.newIdentifier(ACCUMULATOR_VAR);
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, ACCUMULATOR_VAR, accuInit, condition, step, result));
    }

    private static Optional<CelExpr> expandExistsMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CelExpr arg0 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelStandardMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
        CelExpr accuInit = exprFactory.newBoolLiteral(false);
        CelExpr condition = exprFactory.newGlobalCall(Operator.NOT_STRICTLY_FALSE.getFunction(), exprFactory.newGlobalCall(Operator.LOGICAL_NOT.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR)));
        CelExpr step = exprFactory.newGlobalCall(Operator.LOGICAL_OR.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), arg1);
        CelExpr result = exprFactory.newIdentifier(ACCUMULATOR_VAR);
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, ACCUMULATOR_VAR, accuInit, condition, step, result));
    }

    private static Optional<CelExpr> expandExistsOneMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CelExpr arg0 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelStandardMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
        CelExpr zeroExpr = exprFactory.newIntLiteral(0L);
        CelExpr oneExpr = exprFactory.newIntLiteral(1L);
        CelExpr accuInit = zeroExpr;
        CelExpr condition = exprFactory.newBoolLiteral(true);
        CelExpr step = exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), arg1, exprFactory.newGlobalCall(Operator.ADD.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), oneExpr), exprFactory.newIdentifier(ACCUMULATOR_VAR));
        CelExpr result = exprFactory.newGlobalCall(Operator.EQUALS.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), oneExpr);
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, ACCUMULATOR_VAR, accuInit, condition, step, result));
    }

    private static Optional<CelExpr> expandMapMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        CelExpr arg1;
        CelExpr arg2;
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 2 || arguments.size() == 3 ? 1 : 0) != 0);
        CelExpr arg0 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(arg0), "argument is not an identifier")));
        }
        if (arguments.size() == 3) {
            arg2 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
            arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(2)));
        } else {
            arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
            arg2 = null;
        }
        CelExpr accuInit = exprFactory.newList(new CelExpr[0]);
        CelExpr condition = exprFactory.newBoolLiteral(true);
        CelExpr step = exprFactory.newGlobalCall(Operator.ADD.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), exprFactory.newList(arg1));
        if (arg2 != null) {
            step = exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), arg2, step, exprFactory.newIdentifier(ACCUMULATOR_VAR));
        }
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, ACCUMULATOR_VAR, accuInit, condition, step, exprFactory.newIdentifier(ACCUMULATOR_VAR)));
    }

    private static Optional<CelExpr> expandFilterMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CelExpr arg0 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelStandardMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
        CelExpr accuInit = exprFactory.newList(new CelExpr[0]);
        CelExpr condition = exprFactory.newBoolLiteral(true);
        CelExpr step = exprFactory.newGlobalCall(Operator.ADD.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), exprFactory.newList(arg0));
        step = exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), arg1, step, exprFactory.newIdentifier(ACCUMULATOR_VAR));
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, ACCUMULATOR_VAR, accuInit, condition, step, exprFactory.newIdentifier(ACCUMULATOR_VAR)));
    }

    private static CelExpr reportArgumentError(CelMacroExprFactory exprFactory, CelExpr argument) {
        return exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(argument), "The argument must be a simple name"));
    }

    static {
        STANDARD_MACROS = ImmutableSet.of((Object)((Object)HAS), (Object)((Object)ALL), (Object)((Object)EXISTS), (Object)((Object)EXISTS_ONE), (Object)((Object)MAP), (Object)((Object)MAP_FILTER), (Object[])new CelStandardMacro[]{FILTER});
    }
}

