/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.AutoValue_NullableType;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.SimpleType;
import java.util.function.Function;

@CheckReturnValue
@Immutable
@AutoValue
public abstract class NullableType
extends CelType {
    @Override
    public abstract CelKind kind();

    @Override
    public abstract String name();

    @Override
    public boolean isAssignableFrom(CelType other) {
        return this.targetType().isAssignableFrom(other) || other.equals(SimpleType.NULL_TYPE);
    }

    public abstract CelType targetType();

    @Override
    public CelType withParameters(ImmutableList<CelType> parameters) {
        return NullableType.create(this.targetType().withParameters(parameters));
    }

    @Override
    public CelType withFreshTypeParamVariables(Function<String, String> varNameGenerator) {
        return NullableType.create(this.targetType().withFreshTypeParamVariables(varNameGenerator));
    }

    public static NullableType create(CelType targetType) {
        return new AutoValue_NullableType(targetType.kind(), targetType.name(), targetType);
    }
}

