/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Empty;
import com.google.protobuf.NullValue;
import dev.cel.common.annotations.Internal;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.ListType;
import dev.cel.common.types.MapType;
import dev.cel.common.types.NullableType;
import dev.cel.common.types.OpaqueType;
import dev.cel.common.types.OptionalType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.types.StructTypeReference;
import dev.cel.common.types.TypeParamType;
import dev.cel.common.types.TypeType;
import dev.cel.common.types.UnspecifiedType;
import dev.cel.expr.Type;
import java.util.Optional;

public final class CelTypes {
    public static final String ANY_MESSAGE = "google.protobuf.Any";
    public static final String DURATION_MESSAGE = "google.protobuf.Duration";
    public static final String LIST_VALUE_MESSAGE = "google.protobuf.ListValue";
    public static final String STRUCT_MESSAGE = "google.protobuf.Struct";
    public static final String TIMESTAMP_MESSAGE = "google.protobuf.Timestamp";
    public static final String VALUE_MESSAGE = "google.protobuf.Value";
    public static final String BOOL_WRAPPER_MESSAGE = "google.protobuf.BoolValue";
    public static final String BYTES_WRAPPER_MESSAGE = "google.protobuf.BytesValue";
    public static final String DOUBLE_WRAPPER_MESSAGE = "google.protobuf.DoubleValue";
    public static final String FLOAT_WRAPPER_MESSAGE = "google.protobuf.FloatValue";
    public static final String INT32_WRAPPER_MESSAGE = "google.protobuf.Int32Value";
    public static final String INT64_WRAPPER_MESSAGE = "google.protobuf.Int64Value";
    public static final String STRING_WRAPPER_MESSAGE = "google.protobuf.StringValue";
    public static final String UINT32_WRAPPER_MESSAGE = "google.protobuf.UInt32Value";
    public static final String UINT64_WRAPPER_MESSAGE = "google.protobuf.UInt64Value";
    public static final Type ERROR = Type.newBuilder().setError(Empty.getDefaultInstance()).build();
    public static final Type DYN = Type.newBuilder().setDyn(Empty.getDefaultInstance()).build();
    public static final Type NULL_TYPE = Type.newBuilder().setNull(NullValue.NULL_VALUE).build();
    public static final Type BOOL = CelTypes.create(Type.PrimitiveType.BOOL);
    public static final Type BYTES = CelTypes.create(Type.PrimitiveType.BYTES);
    public static final Type STRING = CelTypes.create(Type.PrimitiveType.STRING);
    public static final Type DOUBLE = CelTypes.create(Type.PrimitiveType.DOUBLE);
    public static final Type UINT64 = CelTypes.create(Type.PrimitiveType.UINT64);
    public static final Type INT64 = CelTypes.create(Type.PrimitiveType.INT64);
    public static final Type ANY = CelTypes.create(Type.WellKnownType.ANY);
    public static final Type TIMESTAMP = CelTypes.create(Type.WellKnownType.TIMESTAMP);
    public static final Type DURATION = CelTypes.create(Type.WellKnownType.DURATION);
    static final ImmutableMap<String, Type> WELL_KNOWN_TYPE_MAP = ImmutableMap.builder().put((Object)"google.protobuf.DoubleValue", (Object)CelTypes.createWrapper(DOUBLE)).put((Object)"google.protobuf.FloatValue", (Object)CelTypes.createWrapper(DOUBLE)).put((Object)"google.protobuf.Int64Value", (Object)CelTypes.createWrapper(INT64)).put((Object)"google.protobuf.Int32Value", (Object)CelTypes.createWrapper(INT64)).put((Object)"google.protobuf.UInt64Value", (Object)CelTypes.createWrapper(UINT64)).put((Object)"google.protobuf.UInt32Value", (Object)CelTypes.createWrapper(UINT64)).put((Object)"google.protobuf.BoolValue", (Object)CelTypes.createWrapper(BOOL)).put((Object)"google.protobuf.StringValue", (Object)CelTypes.createWrapper(STRING)).put((Object)"google.protobuf.BytesValue", (Object)CelTypes.createWrapper(BYTES)).put((Object)"google.protobuf.Timestamp", (Object)TIMESTAMP).put((Object)"google.protobuf.Duration", (Object)DURATION).put((Object)"google.protobuf.Struct", (Object)CelTypes.createMap(STRING, DYN)).put((Object)"google.protobuf.Value", (Object)DYN).put((Object)"google.protobuf.ListValue", (Object)CelTypes.createList(DYN)).put((Object)"google.protobuf.Any", (Object)ANY).buildOrThrow();
    private static final ImmutableMap<String, CelType> WELL_KNOWN_CEL_TYPE_MAP = ImmutableMap.builder().put((Object)"google.protobuf.BoolValue", (Object)NullableType.create(SimpleType.BOOL)).put((Object)"google.protobuf.BytesValue", (Object)NullableType.create(SimpleType.BYTES)).put((Object)"google.protobuf.FloatValue", (Object)NullableType.create(SimpleType.DOUBLE)).put((Object)"google.protobuf.DoubleValue", (Object)NullableType.create(SimpleType.DOUBLE)).put((Object)"google.protobuf.Int32Value", (Object)NullableType.create(SimpleType.INT)).put((Object)"google.protobuf.Int64Value", (Object)NullableType.create(SimpleType.INT)).put((Object)"google.protobuf.StringValue", (Object)NullableType.create(SimpleType.STRING)).put((Object)"google.protobuf.UInt32Value", (Object)NullableType.create(SimpleType.UINT)).put((Object)"google.protobuf.UInt64Value", (Object)NullableType.create(SimpleType.UINT)).put((Object)"google.protobuf.Any", (Object)SimpleType.ANY).put((Object)"google.protobuf.Duration", (Object)SimpleType.DURATION).put((Object)"google.protobuf.Timestamp", (Object)SimpleType.TIMESTAMP).put((Object)"google.protobuf.ListValue", (Object)ListType.create(SimpleType.DYN)).put((Object)"google.protobuf.Struct", (Object)MapType.create(SimpleType.STRING, SimpleType.DYN)).put((Object)"google.protobuf.Value", (Object)SimpleType.DYN).buildOrThrow();
    static final ImmutableMap<CelKind, Type> SIMPLE_CEL_KIND_TO_TYPE = ImmutableMap.builder().put((Object)CelKind.ERROR, (Object)ERROR).put((Object)CelKind.DYN, (Object)DYN).put((Object)CelKind.ANY, (Object)ANY).put((Object)CelKind.BOOL, (Object)BOOL).put((Object)CelKind.BYTES, (Object)BYTES).put((Object)CelKind.DOUBLE, (Object)DOUBLE).put((Object)CelKind.DURATION, (Object)DURATION).put((Object)CelKind.INT, (Object)INT64).put((Object)CelKind.NULL_TYPE, (Object)NULL_TYPE).put((Object)CelKind.STRING, (Object)STRING).put((Object)CelKind.TIMESTAMP, (Object)TIMESTAMP).put((Object)CelKind.UINT, (Object)UINT64).buildOrThrow();
    private static final ImmutableMap<Type, CelType> PROTOBUF_TYPE_TO_CEL_TYPE_MAP = ImmutableMap.builder().put((Object)BOOL, (Object)SimpleType.BOOL).put((Object)BYTES, (Object)SimpleType.BYTES).put((Object)DOUBLE, (Object)SimpleType.DOUBLE).put((Object)INT64, (Object)SimpleType.INT).put((Object)STRING, (Object)SimpleType.STRING).put((Object)UINT64, (Object)SimpleType.UINT).put((Object)ANY, (Object)SimpleType.ANY).put((Object)DURATION, (Object)SimpleType.DURATION).put((Object)TIMESTAMP, (Object)SimpleType.TIMESTAMP).put((Object)DYN, (Object)SimpleType.DYN).put((Object)NULL_TYPE, (Object)SimpleType.NULL_TYPE).put((Object)ERROR, (Object)SimpleType.ERROR).buildOrThrow();

    public static Type create(Type.PrimitiveType type) {
        return Type.newBuilder().setPrimitive(type).build();
    }

    public static Type create(Type.WellKnownType type) {
        return Type.newBuilder().setWellKnown(type).build();
    }

    public static Type create(Type target) {
        return Type.newBuilder().setType(target).build();
    }

    public static Type createList(Type elemType) {
        return Type.newBuilder().setListType(Type.ListType.newBuilder().setElemType(elemType)).build();
    }

    public static Type createMap(Type keyType, Type valueType) {
        return Type.newBuilder().setMapType(Type.MapType.newBuilder().setKeyType(keyType).setValueType(valueType)).build();
    }

    public static Type createMessage(String messageName) {
        return Type.newBuilder().setMessageType(messageName).build();
    }

    public static Type createMessage(Descriptors.Descriptor descriptor) {
        return CelTypes.createMessage(descriptor.getFullName());
    }

    public static Type createTypeParam(String name) {
        return Type.newBuilder().setTypeParam(name).build();
    }

    public static Type createWrapper(Type.PrimitiveType primitive) {
        return Type.newBuilder().setWrapper(primitive).build();
    }

    public static Type createWrapper(Type type) {
        Preconditions.checkArgument((type.getTypeKindCase() == Type.TypeKindCase.PRIMITIVE ? 1 : 0) != 0);
        return CelTypes.createWrapper(type.getPrimitive());
    }

    public static boolean isWrapperType(String typeName) {
        switch (typeName) {
            case "google.protobuf.BoolValue": 
            case "google.protobuf.BytesValue": 
            case "google.protobuf.DoubleValue": 
            case "google.protobuf.FloatValue": 
            case "google.protobuf.Int32Value": 
            case "google.protobuf.Int64Value": 
            case "google.protobuf.StringValue": 
            case "google.protobuf.UInt32Value": 
            case "google.protobuf.UInt64Value": {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    public static Type createOptionalType(Type paramType) {
        return Type.newBuilder().setAbstractType(Type.AbstractType.newBuilder().setName("optional_type").addParameterTypes(paramType).build()).build();
    }

    public static boolean isOptionalType(Type type) {
        return type.hasAbstractType() && type.getAbstractType().getName().equals("optional_type");
    }

    @Internal
    public static OpaqueType createFunctionType(CelType resultType, Iterable<CelType> argumentTypes) {
        ImmutableList.Builder arguments = ImmutableList.builder();
        arguments.add((Object)resultType);
        arguments.addAll(argumentTypes);
        return OpaqueType.create("function", (ImmutableList<CelType>)arguments.build());
    }

    @Deprecated
    public static String format(Type type) {
        return CelTypes.format(CelTypes.typeToCelType(type), false);
    }

    public static String format(CelType type) {
        return CelTypes.format(type, false);
    }

    private static String format(CelType type, boolean typeParamToDyn) {
        if (type instanceof NullableType) {
            return String.format("wrapper(%s)", CelTypes.format(((NullableType)type).targetType(), typeParamToDyn));
        }
        switch (type.kind()) {
            case DYN: {
                return "dyn";
            }
            case NULL_TYPE: {
                return "null";
            }
            case BOOL: {
                return "bool";
            }
            case INT: {
                return "int";
            }
            case UINT: {
                return "uint";
            }
            case DOUBLE: {
                return "double";
            }
            case STRING: {
                return "string";
            }
            case BYTES: {
                return "bytes";
            }
            case TIMESTAMP: {
                return TIMESTAMP_MESSAGE;
            }
            case DURATION: {
                return DURATION_MESSAGE;
            }
            case ANY: {
                return "any";
            }
            case LIST: {
                ListType listType = (ListType)type;
                return String.format("list(%s)", CelTypes.format(listType.elemType(), typeParamToDyn));
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return String.format("map(%s, %s)", CelTypes.format(mapType.keyType(), typeParamToDyn), CelTypes.format(mapType.valueType(), typeParamToDyn));
            }
            case TYPE: {
                TypeType typeType = (TypeType)type;
                return String.format("type(%s)", CelTypes.format(typeType.type(), typeParamToDyn));
            }
            case ERROR: {
                return "*error*";
            }
            case STRUCT: {
                return type.name();
            }
            case TYPE_PARAM: {
                return typeParamToDyn ? "dyn" : type.name();
            }
            case OPAQUE: {
                if (type.name().equals("function")) {
                    return CelTypes.formatFunction((CelType)type.parameters().get(0), (Iterable<CelType>)type.parameters().subList(1, type.parameters().size()), false, typeParamToDyn);
                }
                String result = type.name();
                if (!type.parameters().isEmpty()) {
                    result = result + CelTypes.formatTypeArgs(type.parameters(), typeParamToDyn);
                }
                return result;
            }
        }
        return "<unknown type>";
    }

    public static String formatFunction(CelType resultType, Iterable<CelType> argTypes, boolean isInstance, boolean typeParamToDyn) {
        String argString = isInstance ? CelTypes.format((CelType)Iterables.get(argTypes, (int)0), typeParamToDyn) + "." + CelTypes.formatTypeArgs(Iterables.skip(argTypes, (int)1), typeParamToDyn) : CelTypes.formatTypeArgs(argTypes, typeParamToDyn);
        if (resultType == null) {
            return argString;
        }
        return argString + " -> " + CelTypes.format(resultType, typeParamToDyn);
    }

    public static boolean isWellKnownType(String typeName) {
        return WELL_KNOWN_TYPE_MAP.containsKey((Object)typeName);
    }

    public static Optional<CelType> getWellKnownCelType(String typeName) {
        return Optional.ofNullable((CelType)WELL_KNOWN_CEL_TYPE_MAP.getOrDefault((Object)typeName, null));
    }

    @Internal
    public static Type celTypeToType(CelType celType) {
        Type type = (Type)SIMPLE_CEL_KIND_TO_TYPE.get((Object)celType.kind());
        if (type != null) {
            if (celType instanceof NullableType) {
                return CelTypes.createWrapper(type);
            }
            return type;
        }
        switch (celType.kind()) {
            case UNSPECIFIED: {
                return Type.getDefaultInstance();
            }
            case LIST: {
                ListType listType = (ListType)celType;
                if (listType.hasElemType()) {
                    return CelTypes.createList(CelTypes.celTypeToType(listType.elemType()));
                }
                return Type.newBuilder().setListType(Type.ListType.getDefaultInstance()).build();
            }
            case MAP: {
                MapType mapType = (MapType)celType;
                return CelTypes.createMap(CelTypes.celTypeToType(mapType.keyType()), CelTypes.celTypeToType(mapType.valueType()));
            }
            case OPAQUE: {
                if (celType.name().equals("function")) {
                    Type.FunctionType.Builder functionBuilder = Type.FunctionType.newBuilder();
                    if (!celType.parameters().isEmpty()) {
                        functionBuilder.setResultType(CelTypes.celTypeToType((CelType)celType.parameters().get(0)));
                        functionBuilder.addAllArgTypes((Iterable)celType.parameters().stream().skip(1L).map(CelTypes::celTypeToType).collect(ImmutableList.toImmutableList()));
                    }
                    return Type.newBuilder().setFunction(functionBuilder).build();
                }
                return Type.newBuilder().setAbstractType(Type.AbstractType.newBuilder().setName(celType.name()).addAllParameterTypes((Iterable)celType.parameters().stream().map(CelTypes::celTypeToType).collect(ImmutableList.toImmutableList()))).build();
            }
            case STRUCT: {
                return CelTypes.createMessage(celType.name());
            }
            case TYPE: {
                TypeType typeType = (TypeType)celType;
                return CelTypes.create(CelTypes.celTypeToType(typeType.type()));
            }
            case TYPE_PARAM: {
                return CelTypes.createTypeParam(celType.name());
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type: %s", celType));
    }

    @Internal
    public static CelType typeToCelType(Type type) {
        CelType celType = (CelType)PROTOBUF_TYPE_TO_CEL_TYPE_MAP.get((Object)type);
        if (celType != null) {
            return celType;
        }
        switch (type.getTypeKindCase()) {
            case TYPEKIND_NOT_SET: {
                return UnspecifiedType.create();
            }
            case WRAPPER: {
                return NullableType.create(CelTypes.typeToCelType(CelTypes.create(type.getWrapper())));
            }
            case MESSAGE_TYPE: {
                return StructTypeReference.create(type.getMessageType());
            }
            case LIST_TYPE: {
                Type.ListType listType = type.getListType();
                if (listType.hasElemType()) {
                    return ListType.create(CelTypes.typeToCelType(listType.getElemType()));
                }
                return ListType.create();
            }
            case MAP_TYPE: {
                Type.MapType mapType = type.getMapType();
                return MapType.create(CelTypes.typeToCelType(mapType.getKeyType()), CelTypes.typeToCelType(mapType.getValueType()));
            }
            case TYPE_PARAM: {
                return TypeParamType.create(type.getTypeParam());
            }
            case ABSTRACT_TYPE: {
                Type.AbstractType abstractType = type.getAbstractType();
                ImmutableList params = (ImmutableList)abstractType.getParameterTypesList().stream().map(CelTypes::typeToCelType).collect(ImmutableList.toImmutableList());
                if (abstractType.getName().equals("optional_type")) {
                    return OptionalType.create((CelType)params.get(0));
                }
                return OpaqueType.create(abstractType.getName(), (ImmutableList<CelType>)params);
            }
            case TYPE: {
                return TypeType.create(CelTypes.typeToCelType(type.getType()));
            }
            case FUNCTION: {
                Type.FunctionType functionType = type.getFunction();
                return CelTypes.createFunctionType(CelTypes.typeToCelType(functionType.getResultType()), (Iterable)functionType.getArgTypesList().stream().map(CelTypes::typeToCelType).collect(ImmutableList.toImmutableList()));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type: %s", type));
    }

    private static String formatTypeArgs(Iterable<CelType> types, boolean typeParamToDyn) {
        return String.format("(%s)", Joiner.on((String)", ").join(Iterables.transform(types, type -> CelTypes.format(type, typeParamToDyn))));
    }

    private CelTypes() {
    }
}

