/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelCodePointArray;
import java.nio.charset.StandardCharsets;

@Immutable
@VisibleForTesting
@Internal
public final class Latin1CodePointArray
extends CelCodePointArray {
    private final byte[] codePoints;
    private final int offset;
    private final int size;

    Latin1CodePointArray(byte[] codePoints, int size) {
        this(codePoints, 0, size);
    }

    Latin1CodePointArray(byte[] codePoints, int offset, int size) {
        this.codePoints = (byte[])Preconditions.checkNotNull((Object)codePoints);
        this.offset = offset;
        this.size = size;
    }

    @Override
    public Latin1CodePointArray slice(int i, int j) {
        Preconditions.checkPositionIndexes((int)i, (int)j, (int)this.size());
        return new Latin1CodePointArray(this.codePoints, this.offset + i, j - i);
    }

    @Override
    public int get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size());
        return Byte.toUnsignedInt(this.codePoints[this.offset + index]);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return new String(this.codePoints, this.offset, this.size, StandardCharsets.ISO_8859_1);
    }
}

