/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.common.base.Preconditions;
import java.util.HashMap;

public final class CelExprIdGeneratorFactory {
    public static MonotonicIdGenerator newMonotonicIdGenerator(long exprId) {
        return new MonotonicIdGenerator(exprId);
    }

    public static StableIdGenerator newStableIdGenerator(long exprId) {
        return new StableIdGenerator(exprId);
    }

    private CelExprIdGeneratorFactory() {
    }

    public static class MonotonicIdGenerator {
        private long exprId;

        public long nextExprId() {
            return ++this.exprId;
        }

        private MonotonicIdGenerator(long exprId) {
            Preconditions.checkArgument((exprId >= 0L ? 1 : 0) != 0);
            this.exprId = exprId;
        }
    }

    public static class StableIdGenerator {
        private final HashMap<Long, Long> idSet;
        private long exprId;

        public boolean hasId(long id) {
            return this.idSet.containsKey(id);
        }

        public long nextExprId() {
            return ++this.exprId;
        }

        public long nextExprId(long id) {
            long nextExprId = ++this.exprId;
            if (id > 0L) {
                this.idSet.put(id, nextExprId);
            }
            return nextExprId;
        }

        public void memoize(long existingId, long newId) {
            this.idSet.put(existingId, newId);
        }

        public long renumberId(long id) {
            Preconditions.checkArgument((id >= 0L ? 1 : 0) != 0, (String)"Expr ID must be positive. Got: %s", (long)id);
            if (id == 0L) {
                return 0L;
            }
            if (this.idSet.containsKey(id)) {
                return this.idSet.get(id);
            }
            long nextExprId = ++this.exprId;
            this.idSet.put(id, nextExprId);
            return nextExprId;
        }

        private StableIdGenerator(long exprId) {
            Preconditions.checkArgument((exprId >= 0L ? 1 : 0) != 0);
            this.idSet = new HashMap();
            this.exprId = exprId;
        }
    }

    @FunctionalInterface
    public static interface ExprIdGenerator {
        public long generate(long var1);
    }
}

