/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.AutoOneOf_CelExpr_ExprKind;
import dev.cel.common.ast.AutoValue_CelExpr;
import dev.cel.common.ast.AutoValue_CelExpr_CelCall;
import dev.cel.common.ast.AutoValue_CelExpr_CelComprehension;
import dev.cel.common.ast.AutoValue_CelExpr_CelCreateList;
import dev.cel.common.ast.AutoValue_CelExpr_CelCreateMap;
import dev.cel.common.ast.AutoValue_CelExpr_CelCreateMap_Entry;
import dev.cel.common.ast.AutoValue_CelExpr_CelCreateStruct;
import dev.cel.common.ast.AutoValue_CelExpr_CelCreateStruct_Entry;
import dev.cel.common.ast.AutoValue_CelExpr_CelIdent;
import dev.cel.common.ast.AutoValue_CelExpr_CelNotSet;
import dev.cel.common.ast.AutoValue_CelExpr_CelSelect;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExprFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@Immutable
@AutoValue
@Internal
public abstract class CelExpr {
    public abstract long id();

    public abstract ExprKind exprKind();

    public CelConstant constant() {
        return this.exprKind().constant();
    }

    public CelIdent ident() {
        return this.exprKind().ident();
    }

    public CelSelect select() {
        return this.exprKind().select();
    }

    public CelCall call() {
        return this.exprKind().call();
    }

    public CelCreateList createList() {
        return this.exprKind().createList();
    }

    public CelCreateStruct createStruct() {
        return this.exprKind().createStruct();
    }

    public CelCreateMap createMap() {
        return this.exprKind().createMap();
    }

    public CelComprehension comprehension() {
        return this.exprKind().comprehension();
    }

    public CelConstant constantOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.CONSTANT) ? this.exprKind().constant() : CelConstant.ofNotSet();
    }

    public CelIdent identOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.IDENT) ? this.exprKind().ident() : CelIdent.newBuilder().build();
    }

    public CelSelect selectOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.SELECT) ? this.exprKind().select() : CelSelect.newBuilder().build();
    }

    public CelCall callOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.CALL) ? this.exprKind().call() : CelCall.newBuilder().build();
    }

    public CelCreateList createListOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.CREATE_LIST) ? this.exprKind().createList() : CelCreateList.newBuilder().build();
    }

    public CelCreateStruct createStructOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.CREATE_STRUCT) ? this.exprKind().createStruct() : CelCreateStruct.newBuilder().build();
    }

    public CelCreateMap createMapOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.CREATE_MAP) ? this.exprKind().createMap() : CelCreateMap.newBuilder().build();
    }

    public CelComprehension comprehensionOrDefault() {
        return this.exprKind().getKind().equals((Object)ExprKind.Kind.COMPREHENSION) ? this.exprKind().comprehension() : CelComprehension.newBuilder().build();
    }

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_CelExpr.Builder().setId(0L).setExprKind(AutoOneOf_CelExpr_ExprKind.notSet(new AutoValue_CelExpr_CelNotSet()));
    }

    public static CelExpr ofNotSet(long id) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.notSet(new AutoValue_CelExpr_CelNotSet())).build();
    }

    public static CelExpr ofConstantExpr(long id, CelConstant celConstant) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.constant(celConstant)).build();
    }

    public static CelExpr ofIdentExpr(long id, String identName) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.ident(CelIdent.newBuilder().setName(identName).build())).build();
    }

    public static CelExpr ofSelectExpr(long id, CelExpr operandExpr, String field, boolean isTestOnly) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.select(CelSelect.newBuilder().setOperand(operandExpr).setField(field).setTestOnly(isTestOnly).build())).build();
    }

    public static CelExpr ofCallExpr(long id, Optional<CelExpr> targetExpr, String function, ImmutableList<CelExpr> arguments) {
        CelCall.Builder celCallBuilder = CelCall.newBuilder().setFunction(function).addArgs((Iterable<CelExpr>)arguments);
        targetExpr.ifPresent(celCallBuilder::setTarget);
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.call(celCallBuilder.build())).build();
    }

    public static CelExpr ofCreateListExpr(long id, ImmutableList<CelExpr> elements, ImmutableList<Integer> optionalIndices) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.createList(CelCreateList.newBuilder().addElements((Iterable<CelExpr>)elements).addOptionalIndices((Iterable<Integer>)optionalIndices).build())).build();
    }

    public static CelExpr ofCreateStructExpr(long id, String messageName, ImmutableList<CelCreateStruct.Entry> entries) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.createStruct(CelCreateStruct.newBuilder().setMessageName(messageName).addEntries((Iterable<CelCreateStruct.Entry>)entries).build())).build();
    }

    public static CelExpr ofCreateMapExpr(long id, ImmutableList<CelCreateMap.Entry> entries) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.createMap(CelCreateMap.newBuilder().addEntries((Iterable<CelCreateMap.Entry>)entries).build())).build();
    }

    public static CelCreateStruct.Entry ofCreateStructEntryExpr(long id, String fieldKey, CelExpr value, boolean isOptionalEntry) {
        return CelCreateStruct.Entry.newBuilder().setId(id).setFieldKey(fieldKey).setValue(value).setOptionalEntry(isOptionalEntry).build();
    }

    public static CelCreateMap.Entry ofCreateMapEntryExpr(long id, CelExpr mapKey, CelExpr value, boolean isOptionalEntry) {
        return CelCreateMap.Entry.newBuilder().setId(id).setKey(mapKey).setValue(value).setOptionalEntry(isOptionalEntry).build();
    }

    public static CelExpr ofComprehension(long id, String iterVar, CelExpr iterRange, String accuVar, CelExpr accuInit, CelExpr loopCondition, CelExpr loopStep, CelExpr result) {
        return CelExpr.newBuilder().setId(id).setExprKind(AutoOneOf_CelExpr_ExprKind.comprehension(CelComprehension.newBuilder().setIterVar(iterVar).setIterRange(iterRange).setAccuVar(accuVar).setAccuInit(accuInit).setLoopCondition(loopCondition).setLoopStep(loopStep).setResult(result).build())).build();
    }

    public final String toString() {
        return CelExprFormatter.format(this);
    }

    @Immutable
    @AutoOneOf(value=Kind.class)
    public static abstract class ExprKind {
        public abstract Kind getKind();

        public abstract CelNotSet notSet();

        public abstract CelConstant constant();

        public abstract CelIdent ident();

        public abstract CelSelect select();

        public abstract CelCall call();

        public abstract CelCreateList createList();

        public abstract CelCreateStruct createStruct();

        public abstract CelCreateMap createMap();

        public abstract CelComprehension comprehension();

        public static enum Kind {
            NOT_SET,
            CONSTANT,
            IDENT,
            SELECT,
            CALL,
            CREATE_LIST,
            CREATE_STRUCT,
            CREATE_MAP,
            COMPREHENSION;

        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelIdent {
        public abstract String name();

        public abstract Builder toBuilder();

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelIdent.Builder().setName("");
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setName(String var1);

            @CheckReturnValue
            public abstract CelIdent build();
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelSelect {
        public abstract CelExpr operand();

        public abstract String field();

        public abstract boolean testOnly();

        public abstract Builder toBuilder();

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelSelect.Builder().setField("").setOperand(CelExpr.newBuilder().build()).setTestOnly(false);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract CelExpr operand();

            public abstract String field();

            public abstract boolean testOnly();

            public abstract Builder setOperand(CelExpr var1);

            public abstract Builder setField(String var1);

            public abstract Builder setTestOnly(boolean var1);

            @CheckReturnValue
            public abstract CelSelect build();
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelCall {
        public abstract Optional<CelExpr> target();

        public abstract String function();

        public abstract ImmutableList<CelExpr> args();

        abstract Builder autoToBuilder();

        public Builder toBuilder() {
            Builder builder = this.autoToBuilder();
            builder.mutableArgs = new ArrayList<CelExpr>((Collection<CelExpr>)builder.args());
            return builder;
        }

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelCall.Builder().setFunction("");
        }

        @AutoValue.Builder
        public static abstract class Builder {
            private List<CelExpr> mutableArgs = new ArrayList<CelExpr>();

            abstract ImmutableList<CelExpr> args();

            public abstract Builder setTarget(CelExpr var1);

            public abstract Builder setTarget(Optional<CelExpr> var1);

            public abstract Builder setFunction(String var1);

            public abstract Optional<CelExpr> target();

            abstract Builder setArgs(ImmutableList<CelExpr> var1);

            public ImmutableList<CelExpr> getArgs() {
                return ImmutableList.copyOf(this.mutableArgs);
            }

            public ImmutableList<dev.cel.common.ast.CelExpr$Builder> getArgsBuilders() {
                return (ImmutableList)this.mutableArgs.stream().map(CelExpr::toBuilder).collect(ImmutableList.toImmutableList());
            }

            @CanIgnoreReturnValue
            public Builder clearArgs() {
                this.mutableArgs.clear();
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setArg(int index, CelExpr arg) {
                Preconditions.checkNotNull((Object)arg);
                this.mutableArgs.set(index, arg);
                return this;
            }

            public Builder clearTarget() {
                return this.setTarget(Optional.empty());
            }

            @CanIgnoreReturnValue
            public Builder addArgs(CelExpr ... args) {
                Preconditions.checkNotNull((Object)args);
                return this.addArgs(Arrays.asList(args));
            }

            @CanIgnoreReturnValue
            public Builder addArgs(Iterable<CelExpr> args) {
                Preconditions.checkNotNull(args);
                args.forEach(this.mutableArgs::add);
                return this;
            }

            @CheckReturnValue
            abstract CelCall autoBuild();

            public CelCall build() {
                this.setArgs((ImmutableList<CelExpr>)ImmutableList.copyOf(this.mutableArgs));
                return this.autoBuild();
            }
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelCreateList {
        public abstract ImmutableList<CelExpr> elements();

        public abstract ImmutableList<Integer> optionalIndices();

        abstract Builder autoToBuilder();

        public Builder toBuilder() {
            Builder builder = this.autoToBuilder();
            builder.mutableElements = new ArrayList<CelExpr>((Collection<CelExpr>)builder.elements());
            return builder;
        }

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelCreateList.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            private List<CelExpr> mutableElements = new ArrayList<CelExpr>();

            abstract ImmutableList<CelExpr> elements();

            abstract ImmutableList.Builder<Integer> optionalIndicesBuilder();

            @CanIgnoreReturnValue
            abstract Builder setElements(ImmutableList<CelExpr> var1);

            public ImmutableList<CelExpr> getElements() {
                return ImmutableList.copyOf(this.mutableElements);
            }

            public ImmutableList<dev.cel.common.ast.CelExpr$Builder> getElementsBuilders() {
                return (ImmutableList)this.mutableElements.stream().map(CelExpr::toBuilder).collect(ImmutableList.toImmutableList());
            }

            @CanIgnoreReturnValue
            public Builder setElement(int index, CelExpr element) {
                Preconditions.checkNotNull((Object)element);
                this.mutableElements.set(index, element);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addElements(CelExpr ... elements) {
                Preconditions.checkNotNull((Object)elements);
                return this.addElements(Arrays.asList(elements));
            }

            @CanIgnoreReturnValue
            public Builder addElements(Iterable<CelExpr> elements) {
                Preconditions.checkNotNull(elements);
                elements.forEach(this.mutableElements::add);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addOptionalIndices(Integer ... indices) {
                Preconditions.checkNotNull((Object)indices);
                return this.addOptionalIndices(Arrays.asList(indices));
            }

            @CanIgnoreReturnValue
            public Builder addOptionalIndices(Iterable<Integer> indices) {
                Preconditions.checkNotNull(indices);
                this.optionalIndicesBuilder().addAll(indices);
                return this;
            }

            abstract CelCreateList autoBuild();

            @CheckReturnValue
            public CelCreateList build() {
                this.setElements((ImmutableList<CelExpr>)ImmutableList.copyOf(this.mutableElements));
                return this.autoBuild();
            }
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelCreateStruct {
        public abstract String messageName();

        public abstract ImmutableList<Entry> entries();

        abstract Builder autoToBuilder();

        public Builder toBuilder() {
            Builder builder = this.autoToBuilder();
            builder.mutableEntries = new ArrayList<Entry>((Collection<Entry>)builder.entries());
            return builder;
        }

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelCreateStruct.Builder().setMessageName("");
        }

        @AutoValue.Builder
        public static abstract class Builder {
            private List<Entry> mutableEntries = new ArrayList<Entry>();

            abstract ImmutableList<Entry> entries();

            @CanIgnoreReturnValue
            public abstract Builder setMessageName(String var1);

            @CanIgnoreReturnValue
            abstract Builder setEntries(ImmutableList<Entry> var1);

            public ImmutableList<Entry> getEntries() {
                return ImmutableList.copyOf(this.mutableEntries);
            }

            public ImmutableList<Entry.Builder> getEntriesBuilders() {
                return (ImmutableList)this.mutableEntries.stream().map(Entry::toBuilder).collect(ImmutableList.toImmutableList());
            }

            @CanIgnoreReturnValue
            public Builder setEntry(int index, Entry entry) {
                Preconditions.checkNotNull((Object)entry);
                this.mutableEntries.set(index, entry);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addEntries(Entry ... entries) {
                Preconditions.checkNotNull((Object)entries);
                return this.addEntries(Arrays.asList(entries));
            }

            @CanIgnoreReturnValue
            public Builder addEntries(Iterable<Entry> entries) {
                Preconditions.checkNotNull(entries);
                entries.forEach(this.mutableEntries::add);
                return this;
            }

            abstract CelCreateStruct autoBuild();

            @CheckReturnValue
            public CelCreateStruct build() {
                this.setEntries((ImmutableList<Entry>)ImmutableList.copyOf(this.mutableEntries));
                return this.autoBuild();
            }
        }

        @Immutable
        @AutoValue
        public static abstract class Entry {
            public abstract long id();

            public abstract String fieldKey();

            public abstract CelExpr value();

            public abstract boolean optionalEntry();

            public abstract Builder toBuilder();

            public static Builder newBuilder() {
                return new AutoValue_CelExpr_CelCreateStruct_Entry.Builder().setId(0L).setOptionalEntry(false);
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract long id();

                public abstract CelExpr value();

                public abstract Builder setId(long var1);

                public abstract Builder setFieldKey(String var1);

                public abstract Builder setValue(CelExpr var1);

                public abstract Builder setOptionalEntry(boolean var1);

                @CheckReturnValue
                public abstract Entry build();
            }
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelCreateMap {
        public abstract ImmutableList<Entry> entries();

        abstract Builder autoToBuilder();

        public Builder toBuilder() {
            Builder builder = this.autoToBuilder();
            builder.mutableEntries = new ArrayList<Entry>((Collection<Entry>)builder.entries());
            return builder;
        }

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelCreateMap.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            private List<Entry> mutableEntries = new ArrayList<Entry>();

            abstract ImmutableList<Entry> entries();

            @CanIgnoreReturnValue
            abstract Builder setEntries(ImmutableList<Entry> var1);

            public ImmutableList<Entry> getEntries() {
                return ImmutableList.copyOf(this.mutableEntries);
            }

            public ImmutableList<Entry.Builder> getEntriesBuilders() {
                return (ImmutableList)this.mutableEntries.stream().map(Entry::toBuilder).collect(ImmutableList.toImmutableList());
            }

            @CanIgnoreReturnValue
            public Builder setEntry(int index, Entry entry) {
                Preconditions.checkNotNull((Object)entry);
                this.mutableEntries.set(index, entry);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addEntries(Entry ... entries) {
                Preconditions.checkNotNull((Object)entries);
                return this.addEntries(Arrays.asList(entries));
            }

            @CanIgnoreReturnValue
            public Builder addEntries(Iterable<Entry> entries) {
                Preconditions.checkNotNull(entries);
                entries.forEach(this.mutableEntries::add);
                return this;
            }

            abstract CelCreateMap autoBuild();

            @CheckReturnValue
            public CelCreateMap build() {
                this.setEntries((ImmutableList<Entry>)ImmutableList.copyOf(this.mutableEntries));
                return this.autoBuild();
            }
        }

        @Immutable
        @AutoValue
        public static abstract class Entry {
            public abstract long id();

            public abstract CelExpr key();

            public abstract CelExpr value();

            public abstract boolean optionalEntry();

            public abstract Builder toBuilder();

            public static Builder newBuilder() {
                return new AutoValue_CelExpr_CelCreateMap_Entry.Builder().setId(0L).setOptionalEntry(false);
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract long id();

                public abstract CelExpr key();

                public abstract CelExpr value();

                public abstract Builder setId(long var1);

                public abstract Builder setKey(CelExpr var1);

                public abstract Builder setValue(CelExpr var1);

                public abstract Builder setOptionalEntry(boolean var1);

                @CheckReturnValue
                public abstract Entry build();
            }
        }
    }

    @Immutable
    @AutoValue
    public static abstract class CelComprehension {
        public abstract String iterVar();

        public abstract CelExpr iterRange();

        public abstract String accuVar();

        public abstract CelExpr accuInit();

        public abstract CelExpr loopCondition();

        public abstract CelExpr loopStep();

        public abstract CelExpr result();

        public abstract Builder toBuilder();

        public static Builder newBuilder() {
            return new AutoValue_CelExpr_CelComprehension.Builder().setIterVar("").setIterRange(CelExpr.newBuilder().build()).setAccuVar("").setAccuInit(CelExpr.newBuilder().build()).setLoopCondition(CelExpr.newBuilder().build()).setLoopStep(CelExpr.newBuilder().build()).setResult(CelExpr.newBuilder().build());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract String accuVar();

            public abstract CelExpr iterRange();

            public abstract CelExpr accuInit();

            public abstract CelExpr loopCondition();

            public abstract CelExpr loopStep();

            public abstract CelExpr result();

            public abstract Builder setIterVar(String var1);

            public abstract Builder setIterRange(CelExpr var1);

            public abstract Builder setAccuVar(String var1);

            public abstract Builder setAccuInit(CelExpr var1);

            public abstract Builder setLoopCondition(CelExpr var1);

            public abstract Builder setLoopStep(CelExpr var1);

            public abstract Builder setResult(CelExpr var1);

            @CheckReturnValue
            public abstract CelComprehension build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract long id();

        public abstract Builder setId(long var1);

        public abstract Builder setExprKind(ExprKind var1);

        public abstract ExprKind exprKind();

        public CelConstant constant() {
            return this.exprKind().constant();
        }

        public CelIdent ident() {
            return this.exprKind().ident();
        }

        public CelSelect select() {
            return this.exprKind().select();
        }

        public CelCall call() {
            return this.exprKind().call();
        }

        public CelCreateList createList() {
            return this.exprKind().createList();
        }

        public CelCreateStruct createStruct() {
            return this.exprKind().createStruct();
        }

        public CelCreateMap createMap() {
            return this.exprKind().createMap();
        }

        public CelComprehension comprehension() {
            return this.exprKind().comprehension();
        }

        public Builder setConstant(CelConstant constant) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.constant(constant));
        }

        public Builder setIdent(CelIdent ident) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.ident(ident));
        }

        public Builder setCall(CelCall call) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.call(call));
        }

        public Builder setSelect(CelSelect select) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.select(select));
        }

        public Builder setCreateList(CelCreateList createList) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.createList(createList));
        }

        public Builder setCreateStruct(CelCreateStruct createStruct) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.createStruct(createStruct));
        }

        public Builder setCreateMap(CelCreateMap createMap) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.createMap(createMap));
        }

        public Builder setComprehension(CelComprehension comprehension) {
            return this.setExprKind(AutoOneOf_CelExpr_ExprKind.comprehension(comprehension));
        }

        @CheckReturnValue
        public abstract CelExpr build();
    }

    @Immutable
    @AutoValue
    public static abstract class CelNotSet {
    }
}

