/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dev.cel.common.CelException;
import dev.cel.common.CelIssue;
import dev.cel.common.CelSource;
import java.util.List;

public final class CelValidationException
extends CelException {
    private static final Joiner JOINER = Joiner.on((char)'\n');
    private static final int MAX_ERRORS_TO_REPORT = 1000;
    private final CelSource source;
    private final ImmutableList<CelIssue> errors;

    @VisibleForTesting
    public CelValidationException(CelSource source, List<CelIssue> errors) {
        super(CelValidationException.safeJoinErrorMessage(source, errors));
        this.source = source;
        this.errors = ImmutableList.copyOf(errors);
    }

    CelValidationException(CelSource source, Iterable<CelIssue> errors, String message, Throwable cause) {
        super(message, cause);
        this.source = source;
        this.errors = ImmutableList.copyOf(errors);
    }

    private static String safeJoinErrorMessage(CelSource source, List<CelIssue> errors) {
        if (errors.size() <= 1000) {
            return JOINER.join(Iterables.transform(errors, error -> error.toDisplayString(source)));
        }
        List<CelIssue> truncatedErrors = errors.subList(0, 1000);
        StringBuilder sb = new StringBuilder();
        JOINER.appendTo(sb, Iterables.transform(truncatedErrors, error -> error.toDisplayString(source)));
        sb.append(String.format("%n...and %d more errors (truncated)", errors.size() - 1000));
        return sb.toString();
    }

    public CelSource getSource() {
        return this.source;
    }

    public ImmutableList<CelIssue> getErrors() {
        return this.errors;
    }
}

