/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.AutoValue_CelOverloadDecl;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypes;
import dev.cel.expr.Decl;
import java.util.Arrays;
import java.util.List;

@Immutable
@AutoValue
public abstract class CelOverloadDecl {
    public abstract String overloadId();

    public abstract ImmutableList<CelType> parameterTypes();

    public abstract ImmutableSet<String> typeParameterNames();

    public abstract CelType resultType();

    public abstract boolean isInstanceFunction();

    public abstract String doc();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_CelOverloadDecl.Builder().setDoc("");
    }

    @CheckReturnValue
    public static CelOverloadDecl newMemberOverload(String overloadId, CelType resultType, CelType ... paramTypes) {
        return CelOverloadDecl.newMemberOverload(overloadId, resultType, Arrays.asList(paramTypes));
    }

    @CheckReturnValue
    public static CelOverloadDecl newMemberOverload(String overloadId, CelType resultType, List<CelType> paramTypes) {
        return CelOverloadDecl.newMemberOverload(overloadId, "", resultType, paramTypes);
    }

    @CheckReturnValue
    public static CelOverloadDecl newMemberOverload(String overloadId, String doc, CelType resultType, CelType ... paramTypes) {
        return CelOverloadDecl.newMemberOverload(overloadId, doc, resultType, Arrays.asList(paramTypes));
    }

    @CheckReturnValue
    public static CelOverloadDecl newMemberOverload(String overloadId, String doc, CelType resultType, List<CelType> paramTypes) {
        return CelOverloadDecl.newOverload(overloadId, doc, resultType, paramTypes, true);
    }

    @CheckReturnValue
    public static CelOverloadDecl newGlobalOverload(String overloadId, CelType resultType, CelType ... paramTypes) {
        return CelOverloadDecl.newGlobalOverload(overloadId, resultType, Arrays.asList(paramTypes));
    }

    @CheckReturnValue
    public static CelOverloadDecl newGlobalOverload(String overloadId, CelType resultType, List<CelType> paramTypes) {
        return CelOverloadDecl.newGlobalOverload(overloadId, "", resultType, paramTypes);
    }

    @CheckReturnValue
    public static CelOverloadDecl newGlobalOverload(String overloadId, String doc, CelType resultType, CelType ... paramTypes) {
        return CelOverloadDecl.newGlobalOverload(overloadId, doc, resultType, Arrays.asList(paramTypes));
    }

    @CheckReturnValue
    public static CelOverloadDecl newGlobalOverload(String overloadId, String doc, CelType resultType, List<CelType> paramTypes) {
        return CelOverloadDecl.newOverload(overloadId, doc, resultType, paramTypes, false);
    }

    private static CelOverloadDecl newOverload(String overloadId, String doc, CelType resultType, List<CelType> paramTypes, boolean isInstanceFunction) {
        return CelOverloadDecl.newBuilder().setOverloadId(overloadId).setIsInstanceFunction(isInstanceFunction).setResultType(resultType).addParameterTypes(paramTypes).setDoc(doc).build();
    }

    public static Decl.FunctionDecl.Overload celOverloadToOverload(CelOverloadDecl overload) {
        return Decl.FunctionDecl.Overload.newBuilder().setIsInstanceFunction(overload.isInstanceFunction()).setOverloadId(overload.overloadId()).setResultType(CelTypes.celTypeToType(overload.resultType())).addAllParams((Iterable)overload.parameterTypes().stream().map(CelTypes::celTypeToType).collect(ImmutableList.toImmutableList())).addAllTypeParams((Iterable<String>)overload.typeParameterNames()).setDoc(overload.doc()).build();
    }

    public static CelOverloadDecl overloadToCelOverload(Decl.FunctionDecl.Overload overload) {
        return CelOverloadDecl.newBuilder().setIsInstanceFunction(overload.getIsInstanceFunction()).setOverloadId(overload.getOverloadId()).setResultType(CelTypes.typeToCelType(overload.getResultType())).setDoc(overload.getDoc()).addParameterTypes((Iterable)overload.getParamsList().stream().map(CelTypes::typeToCelType).collect(ImmutableList.toImmutableList())).build();
    }

    private static void collectParamNames(ImmutableSet.Builder<String> typeParamNames, CelType type) {
        if (type.kind().equals((Object)CelKind.TYPE_PARAM)) {
            typeParamNames.add((Object)type.name());
        }
        for (CelType param : type.parameters()) {
            CelOverloadDecl.collectParamNames(typeParamNames, param);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setOverloadId(String var1);

        public abstract Builder setParameterTypes(ImmutableSet<CelType> var1);

        public abstract CelType resultType();

        public abstract Builder setResultType(CelType var1);

        public abstract Builder setIsInstanceFunction(boolean var1);

        public abstract Builder setDoc(String var1);

        public abstract boolean isInstanceFunction();

        public abstract ImmutableList<CelType> parameterTypes();

        abstract Builder setTypeParameterNames(ImmutableSet<String> var1);

        abstract ImmutableList.Builder<CelType> parameterTypesBuilder();

        @CanIgnoreReturnValue
        public final Builder addParameterTypes(Iterable<CelType> parameterTypes) {
            Preconditions.checkNotNull(parameterTypes);
            this.parameterTypesBuilder().addAll(parameterTypes);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addParameterTypes(CelType ... parameterTypes) {
            Preconditions.checkNotNull((Object)parameterTypes);
            this.parameterTypesBuilder().add((Object[])parameterTypes);
            return this;
        }

        @CheckReturnValue
        abstract CelOverloadDecl autoBuild();

        @CheckReturnValue
        public CelOverloadDecl build() {
            ImmutableSet.Builder typeParamNameBuilder = new ImmutableSet.Builder();
            for (CelType type : this.parameterTypes()) {
                CelOverloadDecl.collectParamNames((ImmutableSet.Builder<String>)typeParamNameBuilder, type);
            }
            CelOverloadDecl.collectParamNames((ImmutableSet.Builder<String>)typeParamNameBuilder, this.resultType());
            this.setTypeParameterNames((ImmutableSet<String>)typeParamNameBuilder.build());
            return this.autoBuild();
        }
    }
}

