/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.checker.TypeProvider;
import dev.cel.common.annotations.Internal;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypeProvider;
import dev.cel.common.types.CelTypes;
import dev.cel.common.types.EnumType;
import dev.cel.common.types.ProtoMessageType;
import dev.cel.common.types.StructType;
import dev.cel.common.types.TypeType;
import dev.cel.expr.Type;
import java.util.Optional;
import org.jspecify.nullness.Nullable;

@CheckReturnValue
@Internal
final class TypeProviderLegacyImpl
implements TypeProvider {
    private final CelTypeProvider celTypeProvider;

    TypeProviderLegacyImpl(CelTypeProvider celTypeProvider) {
        this.celTypeProvider = celTypeProvider;
    }

    @Override
    public @Nullable Type lookupType(String typeName) {
        return this.lookupCelType(typeName).map(CelTypes::celTypeToType).orElse(null);
    }

    @Override
    public Optional<CelType> lookupCelType(String typeName) {
        return this.celTypeProvider.findType(typeName).map(TypeType::create);
    }

    @Override
    public @Nullable TypeProvider.FieldType lookupFieldType(CelType type, String fieldName) {
        String messageType = type.name();
        StructType structType = this.celTypeProvider.findType(messageType).filter(t -> t instanceof StructType).orElse(null);
        if (structType == null) {
            return null;
        }
        return structType.findField(fieldName).map(f -> TypeProvider.FieldType.of(CelTypes.celTypeToType(f.type()))).orElse(null);
    }

    @Override
    public @Nullable TypeProvider.FieldType lookupFieldType(Type type, String fieldName) {
        return this.lookupFieldType(CelTypes.typeToCelType(type), fieldName);
    }

    @Override
    public @Nullable ImmutableSet<String> lookupFieldNames(Type type) {
        String messageType = type.getMessageType();
        return this.celTypeProvider.findType(messageType).filter(t -> t instanceof StructType).map(t -> ((StructType)t).fieldNames()).orElse(null);
    }

    @Override
    public @Nullable Integer lookupEnumValue(String enumName) {
        int dotIndex = enumName.lastIndexOf(".");
        if (dotIndex < 0 || dotIndex == enumName.length() - 1) {
            return null;
        }
        String enumTypeName = enumName.substring(0, dotIndex);
        String localEnumName = enumName.substring(dotIndex + 1);
        return this.celTypeProvider.findType(enumTypeName).filter(t -> t instanceof EnumType).flatMap(t -> ((EnumType)t).findNumberByName(localEnumName)).orElse(null);
    }

    @Override
    public @Nullable TypeProvider.ExtensionFieldType lookupExtensionType(String extensionName) {
        Optional<ProtoMessageType.Extension> extension = this.celTypeProvider.types().stream().filter(t -> t instanceof ProtoMessageType).map(t -> (ProtoMessageType)t).map(t -> t.findExtension(extensionName)).filter(Optional::isPresent).map(Optional::get).findFirst();
        return extension.map(et -> TypeProvider.ExtensionFieldType.of(CelTypes.celTypeToType(et.type()), CelTypes.celTypeToType(et.messageType()))).orElse(null);
    }
}

