/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.parser;

import com.google.common.collect.ImmutableMap;
import dev.cel.common.ast.CelExpr;
import java.util.Objects;
import java.util.Optional;

public enum Operator {
    CONDITIONAL("_?_:_"),
    LOGICAL_AND("_&&_", "&&"),
    LOGICAL_OR("_||_", "||"),
    LOGICAL_NOT("!_", "!"),
    EQUALS("_==_", "=="),
    NOT_EQUALS("_!=_", "!="),
    LESS("_<_", "<"),
    LESS_EQUALS("_<=_", "<="),
    GREATER("_>_", ">"),
    GREATER_EQUALS("_>=_", ">="),
    ADD("_+_", "+"),
    SUBTRACT("_-_", "-"),
    MULTIPLY("_*_", "*"),
    DIVIDE("_/_", "/"),
    MODULO("_%_", "%"),
    NEGATE("-_", "-"),
    INDEX("_[_]"),
    HAS("has"),
    ALL("all"),
    EXISTS("exists"),
    EXISTS_ONE("exists_one"),
    MAP("map"),
    FILTER("filter"),
    NOT_STRICTLY_FALSE("@not_strictly_false"),
    IN("@in", "in"),
    OPTIONAL_INDEX("_[?_]"),
    OPTIONAL_SELECT("_?._"),
    OLD_NOT_STRICTLY_FALSE("__not_strictly_false__"),
    OLD_IN("_in_");

    private final String functionName;
    private final String displayName;
    private static final ImmutableMap<String, Operator> OPERATORS;
    private static final ImmutableMap<String, Operator> REVERSE_OPERATORS;
    private static final ImmutableMap<String, Integer> PRECEDENCES;
    private static final ImmutableMap<String, String> UNARY_OPERATORS;
    private static final ImmutableMap<String, String> BINARY_OPERATORS;

    private Operator(String functionName) {
        this(functionName, "");
    }

    private Operator(String functionName, String displayName) {
        this.functionName = functionName;
        this.displayName = displayName;
    }

    public String getFunction() {
        return this.functionName;
    }

    String getSymbol() {
        return this.displayName;
    }

    static Optional<Operator> find(String text) {
        return Optional.ofNullable((Operator)((Object)OPERATORS.get((Object)text)));
    }

    static Optional<Operator> findReverse(String op) {
        return Optional.ofNullable((Operator)((Object)REVERSE_OPERATORS.get((Object)op)));
    }

    static Optional<Operator> findReverseBinaryOperator(String op) {
        if (Objects.equals(op, LOGICAL_NOT.getFunction()) || Objects.equals(op, NEGATE.getFunction())) {
            return Optional.empty();
        }
        return Optional.ofNullable((Operator)((Object)REVERSE_OPERATORS.get((Object)op)));
    }

    static int lookupPrecedence(String op) {
        return (Integer)PRECEDENCES.getOrDefault((Object)op, (Object)0);
    }

    static Optional<String> lookupUnaryOperator(String op) {
        return Optional.ofNullable((String)UNARY_OPERATORS.get((Object)op));
    }

    static Optional<String> lookupBinaryOperator(String op) {
        return Optional.ofNullable((String)BINARY_OPERATORS.get((Object)op));
    }

    static boolean isOperatorLowerPrecedence(String op, CelExpr expr) {
        if (!expr.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.CALL)) {
            return false;
        }
        return Operator.lookupPrecedence(op) < Operator.lookupPrecedence(expr.call().function());
    }

    static boolean isOperatorLeftRecursive(String op) {
        return !op.equals(LOGICAL_AND.getFunction()) && !op.equals(LOGICAL_OR.getFunction());
    }

    static {
        OPERATORS = ImmutableMap.builder().put((Object)ADD.getSymbol(), (Object)ADD).put((Object)DIVIDE.getSymbol(), (Object)DIVIDE).put((Object)EQUALS.getSymbol(), (Object)EQUALS).put((Object)GREATER.getSymbol(), (Object)GREATER).put((Object)GREATER_EQUALS.getSymbol(), (Object)GREATER_EQUALS).put((Object)IN.getSymbol(), (Object)IN).put((Object)LESS.getSymbol(), (Object)LESS).put((Object)LESS_EQUALS.getSymbol(), (Object)LESS_EQUALS).put((Object)MODULO.getSymbol(), (Object)MODULO).put((Object)MULTIPLY.getSymbol(), (Object)MULTIPLY).put((Object)NOT_EQUALS.getSymbol(), (Object)NOT_EQUALS).put((Object)SUBTRACT.getSymbol(), (Object)SUBTRACT).buildOrThrow();
        REVERSE_OPERATORS = ImmutableMap.builder().put((Object)ADD.getFunction(), (Object)ADD).put((Object)DIVIDE.getFunction(), (Object)DIVIDE).put((Object)EQUALS.getFunction(), (Object)EQUALS).put((Object)GREATER.getFunction(), (Object)GREATER).put((Object)GREATER_EQUALS.getFunction(), (Object)GREATER_EQUALS).put((Object)IN.getFunction(), (Object)IN).put((Object)LESS.getFunction(), (Object)LESS).put((Object)LESS_EQUALS.getFunction(), (Object)LESS_EQUALS).put((Object)LOGICAL_AND.getFunction(), (Object)LOGICAL_AND).put((Object)LOGICAL_NOT.getFunction(), (Object)LOGICAL_NOT).put((Object)LOGICAL_OR.getFunction(), (Object)LOGICAL_OR).put((Object)MODULO.getFunction(), (Object)MODULO).put((Object)MULTIPLY.getFunction(), (Object)MULTIPLY).put((Object)NEGATE.getFunction(), (Object)NEGATE).put((Object)NOT_EQUALS.getFunction(), (Object)NOT_EQUALS).put((Object)SUBTRACT.getFunction(), (Object)SUBTRACT).put((Object)OLD_IN.getFunction(), (Object)OLD_IN).buildOrThrow();
        PRECEDENCES = ImmutableMap.builder().put((Object)CONDITIONAL.getFunction(), (Object)8).put((Object)LOGICAL_OR.getFunction(), (Object)7).put((Object)LOGICAL_AND.getFunction(), (Object)6).put((Object)EQUALS.getFunction(), (Object)5).put((Object)GREATER.getFunction(), (Object)5).put((Object)GREATER_EQUALS.getFunction(), (Object)5).put((Object)IN.getFunction(), (Object)5).put((Object)LESS.getFunction(), (Object)5).put((Object)LESS_EQUALS.getFunction(), (Object)5).put((Object)NOT_EQUALS.getFunction(), (Object)5).put((Object)ADD.getFunction(), (Object)4).put((Object)SUBTRACT.getFunction(), (Object)4).put((Object)DIVIDE.getFunction(), (Object)3).put((Object)MODULO.getFunction(), (Object)3).put((Object)MULTIPLY.getFunction(), (Object)3).put((Object)LOGICAL_NOT.getFunction(), (Object)2).put((Object)NEGATE.getFunction(), (Object)2).put((Object)INDEX.getFunction(), (Object)1).buildOrThrow();
        UNARY_OPERATORS = ImmutableMap.builder().put((Object)NEGATE.getFunction(), (Object)"-").put((Object)LOGICAL_NOT.getFunction(), (Object)"!").buildOrThrow();
        BINARY_OPERATORS = ImmutableMap.builder().put((Object)LOGICAL_OR.getFunction(), (Object)"||").put((Object)LOGICAL_AND.getFunction(), (Object)"&&").put((Object)LESS_EQUALS.getFunction(), (Object)"<=").put((Object)LESS.getFunction(), (Object)"<").put((Object)GREATER_EQUALS.getFunction(), (Object)">=").put((Object)GREATER.getFunction(), (Object)">").put((Object)EQUALS.getFunction(), (Object)"==").put((Object)NOT_EQUALS.getFunction(), (Object)"!=").put((Object)IN.getFunction(), (Object)"in").put((Object)ADD.getFunction(), (Object)"+").put((Object)SUBTRACT.getFunction(), (Object)"-").put((Object)MULTIPLY.getFunction(), (Object)"*").put((Object)DIVIDE.getFunction(), (Object)"/").put((Object)MODULO.getFunction(), (Object)"%").buildOrThrow();
    }
}

