/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.parser;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.CelIssue;
import dev.cel.common.ast.CelExpr;
import dev.cel.parser.AutoValue_CelMacro;
import dev.cel.parser.CelMacroExpander;
import dev.cel.parser.CelMacroExprFactory;
import dev.cel.parser.Operator;
import java.util.Optional;

@Immutable
@AutoValue
public abstract class CelMacro
implements Comparable<CelMacro> {
    private static final String ACCUMULATOR_VAR = "__result__";
    public static final CelMacro HAS = CelMacro.newGlobalMacro(Operator.HAS.getFunction(), 1, CelMacro::expandHasMacro);
    public static final CelMacro ALL = CelMacro.newReceiverMacro(Operator.ALL.getFunction(), 2, CelMacro::expandAllMacro);
    public static final CelMacro EXISTS = CelMacro.newReceiverMacro(Operator.EXISTS.getFunction(), 2, CelMacro::expandExistsMacro);
    public static final CelMacro EXISTS_ONE = CelMacro.newReceiverMacro(Operator.EXISTS_ONE.getFunction(), 2, CelMacro::expandExistsOneMacro);
    public static final CelMacro MAP = CelMacro.newReceiverMacro(Operator.MAP.getFunction(), 2, CelMacro::expandMapMacro);
    public static final CelMacro MAP_FILTER = CelMacro.newReceiverMacro(Operator.MAP.getFunction(), 3, CelMacro::expandMapMacro);
    public static final CelMacro FILTER = CelMacro.newReceiverMacro(Operator.FILTER.getFunction(), 2, CelMacro::expandFilterMacro);
    public static final ImmutableList<CelMacro> STANDARD_MACROS = ImmutableList.of((Object)HAS, (Object)ALL, (Object)EXISTS, (Object)EXISTS_ONE, (Object)MAP, (Object)MAP_FILTER, (Object)FILTER);

    CelMacro() {
    }

    public abstract String getFunction();

    public abstract int getArgumentCount();

    abstract boolean getReceiverStyle();

    public final boolean isReceiverStyle() {
        return this.getReceiverStyle();
    }

    public abstract String getKey();

    abstract boolean getVariadic();

    public final boolean isVariadic() {
        return this.getVariadic();
    }

    public abstract CelMacroExpander getExpander();

    @Override
    public final int compareTo(CelMacro other) {
        if (other == null) {
            return 1;
        }
        int diff = this.getFunction().compareTo(other.getFunction());
        if (diff != 0) {
            return diff;
        }
        diff = Boolean.compare(!this.isVariadic(), !other.isVariadic());
        if (diff != 0) {
            return diff;
        }
        if (!this.isVariadic() && (diff = Integer.compare(this.getArgumentCount(), other.getArgumentCount())) != 0) {
            return diff;
        }
        return Boolean.compare(this.isReceiverStyle(), other.isReceiverStyle());
    }

    public final String toString() {
        return this.getKey();
    }

    public final int hashCode() {
        return this.getKey().hashCode();
    }

    public final boolean equals(Object other) {
        return other instanceof CelMacro && this.getKey().equals(((CelMacro)other).getKey());
    }

    static Builder newBuilder() {
        return new AutoValue_CelMacro.Builder();
    }

    public static CelMacro newGlobalMacro(String function, int argCount, CelMacroExpander expander) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        Preconditions.checkArgument((argCount >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)expander);
        return CelMacro.newBuilder().setFunction(function).setArgumentCount(argCount).setReceiverStyle(false).setKey(CelMacro.formatKey(function, argCount, false)).setVariadic(false).setExpander(expander).build();
    }

    public static CelMacro newGlobalVarArgMacro(String function, CelMacroExpander expander) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)expander);
        return CelMacro.newBuilder().setFunction(function).setArgumentCount(0).setReceiverStyle(false).setKey(CelMacro.formatVarArgKey(function, false)).setVariadic(true).setExpander(expander).build();
    }

    public static CelMacro newReceiverMacro(String function, int argCount, CelMacroExpander expander) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        Preconditions.checkArgument((argCount >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)expander);
        return CelMacro.newBuilder().setFunction(function).setArgumentCount(argCount).setReceiverStyle(true).setKey(CelMacro.formatKey(function, argCount, true)).setVariadic(false).setExpander(expander).build();
    }

    public static CelMacro newReceiverVarArgMacro(String function, CelMacroExpander expander) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)expander);
        return CelMacro.newBuilder().setFunction(function).setArgumentCount(0).setReceiverStyle(true).setKey(CelMacro.formatVarArgKey(function, true)).setVariadic(true).setExpander(expander).build();
    }

    static String formatKey(String function, int argCount, boolean receiverStyle) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        Preconditions.checkArgument((argCount >= 0 ? 1 : 0) != 0);
        return String.format("%s:%d:%s", function, argCount, receiverStyle);
    }

    static String formatVarArgKey(String function, boolean receiverStyle) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        return String.format("%s:*:%s", function, receiverStyle);
    }

    private static Optional<CelExpr> expandHasMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0);
        CelExpr arg = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg.exprKind().getKind() != CelExpr.ExprKind.Kind.SELECT) {
            return Optional.of(exprFactory.reportError("invalid argument to has() macro"));
        }
        return Optional.of(exprFactory.newSelect(arg.select().operand(), arg.select().field(), true));
    }

    private static Optional<CelExpr> expandAllMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CelExpr arg0 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
        CelExpr accuInit = exprFactory.newBoolLiteral(true);
        CelExpr condition = exprFactory.newGlobalCall(Operator.NOT_STRICTLY_FALSE.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR));
        CelExpr step = exprFactory.newGlobalCall(Operator.LOGICAL_AND.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), arg1);
        CelExpr result = exprFactory.newIdentifier(ACCUMULATOR_VAR);
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, ACCUMULATOR_VAR, accuInit, condition, step, result));
    }

    private static Optional<CelExpr> expandExistsMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CelExpr arg0 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
        CelExpr accuInit = exprFactory.newBoolLiteral(false);
        CelExpr condition = exprFactory.newGlobalCall(Operator.NOT_STRICTLY_FALSE.getFunction(), exprFactory.newGlobalCall(Operator.LOGICAL_NOT.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR)));
        CelExpr step = exprFactory.newGlobalCall(Operator.LOGICAL_OR.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), arg1);
        CelExpr result = exprFactory.newIdentifier(ACCUMULATOR_VAR);
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, ACCUMULATOR_VAR, accuInit, condition, step, result));
    }

    private static Optional<CelExpr> expandExistsOneMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CelExpr arg0 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
        CelExpr zeroExpr = exprFactory.newIntLiteral(0L);
        CelExpr oneExpr = exprFactory.newIntLiteral(1L);
        CelExpr accuInit = zeroExpr;
        CelExpr condition = exprFactory.newBoolLiteral(true);
        CelExpr step = exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), arg1, exprFactory.newGlobalCall(Operator.ADD.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), oneExpr), exprFactory.newIdentifier(ACCUMULATOR_VAR));
        CelExpr result = exprFactory.newGlobalCall(Operator.EQUALS.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), oneExpr);
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, ACCUMULATOR_VAR, accuInit, condition, step, result));
    }

    private static Optional<CelExpr> expandMapMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        CelExpr arg1;
        CelExpr arg2;
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 2 || arguments.size() == 3 ? 1 : 0) != 0);
        CelExpr arg0 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(arg0), "argument is not an identifier")));
        }
        if (arguments.size() == 3) {
            arg2 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
            arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(2)));
        } else {
            arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
            arg2 = null;
        }
        CelExpr accuInit = exprFactory.newList(new CelExpr[0]);
        CelExpr condition = exprFactory.newBoolLiteral(true);
        CelExpr step = exprFactory.newGlobalCall(Operator.ADD.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), exprFactory.newList(arg1));
        if (arg2 != null) {
            step = exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), arg2, step, exprFactory.newIdentifier(ACCUMULATOR_VAR));
        }
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, ACCUMULATOR_VAR, accuInit, condition, step, exprFactory.newIdentifier(ACCUMULATOR_VAR)));
    }

    private static Optional<CelExpr> expandFilterMacro(CelMacroExprFactory exprFactory, CelExpr target, ImmutableList<CelExpr> arguments) {
        Preconditions.checkNotNull((Object)exprFactory);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CelExpr arg0 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(0)));
        if (arg0.exprKind().getKind() != CelExpr.ExprKind.Kind.IDENT) {
            return Optional.of(CelMacro.reportArgumentError(exprFactory, arg0));
        }
        CelExpr arg1 = (CelExpr)Preconditions.checkNotNull((Object)((CelExpr)arguments.get(1)));
        CelExpr accuInit = exprFactory.newList(new CelExpr[0]);
        CelExpr condition = exprFactory.newBoolLiteral(true);
        CelExpr step = exprFactory.newGlobalCall(Operator.ADD.getFunction(), exprFactory.newIdentifier(ACCUMULATOR_VAR), exprFactory.newList(arg0));
        step = exprFactory.newGlobalCall(Operator.CONDITIONAL.getFunction(), arg1, step, exprFactory.newIdentifier(ACCUMULATOR_VAR));
        return Optional.of(exprFactory.fold(arg0.ident().name(), target, ACCUMULATOR_VAR, accuInit, condition, step, exprFactory.newIdentifier(ACCUMULATOR_VAR)));
    }

    private static CelExpr reportArgumentError(CelMacroExprFactory exprFactory, CelExpr argument) {
        return exprFactory.reportError(CelIssue.formatError(exprFactory.getSourceLocation(argument), "The argument must be a simple name"));
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setFunction(String var1);

        abstract Builder setArgumentCount(int var1);

        abstract Builder setReceiverStyle(boolean var1);

        abstract Builder setKey(String var1);

        abstract Builder setVariadic(boolean var1);

        abstract Builder setExpander(CelMacroExpander var1);

        @CheckReturnValue
        abstract CelMacro build();
    }
}

