/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.types;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.types.CelType;
import java.util.LinkedHashMap;
import java.util.Optional;

@CheckReturnValue
@Immutable
public interface CelTypeProvider {
    public ImmutableCollection<CelType> types();

    public Optional<CelType> findType(String var1);

    @Immutable
    public static final class CombinedCelTypeProvider
    implements CelTypeProvider {
        private final ImmutableMap<String, CelType> allTypes;

        public CombinedCelTypeProvider(CelTypeProvider first, CelTypeProvider second) {
            this((ImmutableList<CelTypeProvider>)ImmutableList.of((Object)first, (Object)second));
        }

        public CombinedCelTypeProvider(ImmutableList<CelTypeProvider> typeProviders) {
            LinkedHashMap allTypes = new LinkedHashMap();
            typeProviders.forEach(typeProvider -> typeProvider.types().forEach(type -> allTypes.putIfAbsent(type.name(), type)));
            this.allTypes = ImmutableMap.copyOf(allTypes);
        }

        @Override
        public ImmutableCollection<CelType> types() {
            return this.allTypes.values();
        }

        @Override
        public Optional<CelType> findType(String typeName) {
            return Optional.ofNullable((CelType)this.allTypes.get((Object)typeName));
        }
    }
}

