/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.BasicCodePointArray;
import dev.cel.common.internal.CelCodePointArray;

@Immutable
@Internal
final class EmptyCodePointArray
extends CelCodePointArray {
    static final EmptyCodePointArray INSTANCE = new EmptyCodePointArray();

    private EmptyCodePointArray() {
    }

    @Override
    public BasicCodePointArray slice(int i, int j) {
        if (i < 0) {
            throw new IndexOutOfBoundsException(String.format("index (%s) must not be negative", i));
        }
        throw new IndexOutOfBoundsException(String.format("index (%s) must not be greater than size (0)", i));
    }

    @Override
    @DoNotCall
    public int get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.format("index (%s) must not be negative", index));
        }
        throw new IndexOutOfBoundsException(String.format("index (%s) must not be greater than size (0)", index));
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public String toString() {
        return "";
    }
}

