/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.CelCodePointArray;

@Immutable
@VisibleForTesting
@Internal
public final class BasicCodePointArray
extends CelCodePointArray {
    private final char[] codePoints;
    private final int offset;
    private final int size;

    BasicCodePointArray(char[] codePoints, int size) {
        this(codePoints, 0, size);
    }

    BasicCodePointArray(char[] codePoints, int offset, int size) {
        this.codePoints = (char[])Preconditions.checkNotNull((Object)codePoints);
        this.offset = offset;
        this.size = size;
    }

    @Override
    public BasicCodePointArray slice(int i, int j) {
        Preconditions.checkPositionIndexes((int)i, (int)j, (int)this.size());
        return new BasicCodePointArray(this.codePoints, this.offset + i, j - i);
    }

    @Override
    public int get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size());
        return this.codePoints[this.offset + index] & 0xFFFF;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return new String(this.codePoints, this.offset, this.size);
    }
}

