/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.ByteString;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelExprIdGeneratorFactory;
import java.util.Arrays;

public class CelExprFactory {
    private final CelExprIdGeneratorFactory.MonotonicIdGenerator idGenerator = CelExprIdGeneratorFactory.newMonotonicIdGenerator(0L);

    public static CelExprFactory newInstance() {
        return new CelExprFactory();
    }

    public final CelExpr newConstant(CelConstant constant) {
        return CelExpr.newBuilder().setId(this.nextExprId()).setConstant(constant).build();
    }

    public final CelExpr newBoolLiteral(boolean value) {
        return this.newConstant(CelConstant.ofValue(value));
    }

    public final CelExpr newBytesLiteral(ByteString value) {
        return this.newConstant(CelConstant.ofValue(value));
    }

    public final CelExpr newBytesLiteral(byte[] value) {
        return this.newBytesLiteral(value, 0, value.length);
    }

    public final CelExpr newBytesLiteral(byte[] value, int offset, int size) {
        return this.newBytesLiteral(ByteString.copyFrom((byte[])value, (int)offset, (int)size));
    }

    public final CelExpr newBytesLiteral(String value) {
        return this.newBytesLiteral(ByteString.copyFromUtf8((String)value));
    }

    public final CelExpr newDoubleLiteral(double value) {
        return this.newConstant(CelConstant.ofValue(value));
    }

    public final CelExpr newIntLiteral(long value) {
        return this.newConstant(CelConstant.ofValue(value));
    }

    public final CelExpr newStringLiteral(String value) {
        return this.newConstant(CelConstant.ofValue(value));
    }

    public final CelExpr newUintLiteral(long value) {
        return this.newConstant(CelConstant.ofValue(UnsignedLong.fromLongBits((long)value)));
    }

    public final CelExpr newList(CelExpr ... elements) {
        return this.newList(Arrays.asList(elements));
    }

    public final CelExpr newList(Iterable<CelExpr> elements) {
        return CelExpr.newBuilder().setId(this.nextExprId()).setCreateList(CelExpr.CelCreateList.newBuilder().addElements(elements).build()).build();
    }

    public final CelExpr newMap(CelExpr.CelCreateMap.Entry ... entries) {
        return this.newMap(Arrays.asList(entries));
    }

    public final CelExpr newMap(Iterable<CelExpr.CelCreateMap.Entry> entries) {
        return CelExpr.newBuilder().setId(this.nextExprId()).setCreateMap(CelExpr.CelCreateMap.newBuilder().addEntries(entries).build()).build();
    }

    public final CelExpr.CelCreateMap.Entry newMapEntry(CelExpr key, CelExpr value) {
        return CelExpr.CelCreateMap.Entry.newBuilder().setId(this.nextExprId()).setKey(key).setValue(value).build();
    }

    public final CelExpr newMessage(String typeName, CelExpr.CelCreateStruct.Entry ... fields) {
        return this.newMessage(typeName, Arrays.asList(fields));
    }

    public final CelExpr newMessage(String typeName, Iterable<CelExpr.CelCreateStruct.Entry> fields) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)typeName) ? 1 : 0) != 0);
        return CelExpr.newBuilder().setId(this.nextExprId()).setCreateStruct(CelExpr.CelCreateStruct.newBuilder().setMessageName(typeName).addEntries(fields).build()).build();
    }

    public final CelExpr.CelCreateStruct.Entry newMessageField(String field, CelExpr value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)field) ? 1 : 0) != 0);
        return CelExpr.CelCreateStruct.Entry.newBuilder().setId(this.nextExprId()).setFieldKey(field).setValue(value).build();
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr accuInit, CelExpr condition, CelExpr step, CelExpr result) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)iterVar) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accuVar) ? 1 : 0) != 0);
        return CelExpr.newBuilder().setId(this.nextExprId()).setComprehension(CelExpr.CelComprehension.newBuilder().setIterVar(iterVar).setIterRange(iterRange).setAccuVar(accuVar).setAccuInit(accuInit).setLoopCondition(condition).setLoopStep(step).setResult(result).build()).build();
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr accuInit, CelExpr condition, CelExpr step, CelExpr result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit, condition, step, result);
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr.Builder accuInit, CelExpr condition, CelExpr step, CelExpr result) {
        return this.fold(iterVar, iterRange, accuVar, accuInit.build(), condition, step, result);
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr accuInit, CelExpr.Builder condition, CelExpr step, CelExpr result) {
        return this.fold(iterVar, iterRange, accuVar, accuInit, condition.build(), step, result);
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr accuInit, CelExpr condition, CelExpr.Builder step, CelExpr result) {
        return this.fold(iterVar, iterRange, accuVar, accuInit, condition, step.build(), result);
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr accuInit, CelExpr condition, CelExpr step, CelExpr.Builder result) {
        return this.fold(iterVar, iterRange, accuVar, accuInit, condition, step, result.build());
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr.Builder accuInit, CelExpr condition, CelExpr step, CelExpr result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit.build(), condition, step, result);
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr accuInit, CelExpr.Builder condition, CelExpr step, CelExpr result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit, condition.build(), step, result);
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr accuInit, CelExpr condition, CelExpr.Builder step, CelExpr result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit, condition, step.build(), result);
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr accuInit, CelExpr condition, CelExpr step, CelExpr.Builder result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit, condition, step, result.build());
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr.Builder accuInit, CelExpr.Builder condition, CelExpr step, CelExpr result) {
        return this.fold(iterVar, iterRange, accuVar, accuInit.build(), condition.build(), step, result);
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr.Builder accuInit, CelExpr condition, CelExpr.Builder step, CelExpr result) {
        return this.fold(iterVar, iterRange, accuVar, accuInit.build(), condition, step.build(), result);
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr.Builder accuInit, CelExpr condition, CelExpr step, CelExpr.Builder result) {
        return this.fold(iterVar, iterRange, accuVar, accuInit.build(), condition, step, result.build());
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr accuInit, CelExpr.Builder condition, CelExpr.Builder step, CelExpr result) {
        return this.fold(iterVar, iterRange, accuVar, accuInit, condition.build(), step.build(), result);
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr accuInit, CelExpr.Builder condition, CelExpr step, CelExpr.Builder result) {
        return this.fold(iterVar, iterRange, accuVar, accuInit, condition.build(), step, result.build());
    }

    public final CelExpr fold(String iterVar, CelExpr iterRange, String accuVar, CelExpr accuInit, CelExpr condition, CelExpr.Builder step, CelExpr.Builder result) {
        return this.fold(iterVar, iterRange, accuVar, accuInit, condition, step.build(), result.build());
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr accuInit, CelExpr.Builder condition, CelExpr.Builder step, CelExpr result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit, condition.build(), step.build(), result);
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr accuInit, CelExpr.Builder condition, CelExpr step, CelExpr.Builder result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit, condition.build(), step, result.build());
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr.Builder accuInit, CelExpr.Builder condition, CelExpr.Builder step, CelExpr result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit.build(), condition.build(), step.build(), result);
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr.Builder accuInit, CelExpr condition, CelExpr step, CelExpr.Builder result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit.build(), condition, step, result.build());
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr.Builder accuInit, CelExpr condition, CelExpr.Builder step, CelExpr result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit.build(), condition, step.build(), result);
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr.Builder accuInit, CelExpr.Builder condition, CelExpr step, CelExpr result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit.build(), condition.build(), step, result);
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr accuInit, CelExpr.Builder condition, CelExpr.Builder step, CelExpr.Builder result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit, condition.build(), step.build(), result.build());
    }

    public final CelExpr fold(String iterVar, CelExpr.Builder iterRange, String accuVar, CelExpr.Builder accuInit, CelExpr.Builder condition, CelExpr.Builder step, CelExpr.Builder result) {
        return this.fold(iterVar, iterRange.build(), accuVar, accuInit.build(), condition.build(), step.build(), result.build());
    }

    public final CelExpr newIdentifier(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return CelExpr.newBuilder().setId(this.nextExprId()).setIdent(CelExpr.CelIdent.newBuilder().setName(name).build()).build();
    }

    public final CelExpr newGlobalCall(String function, CelExpr ... arguments) {
        return this.newGlobalCall(function, Arrays.asList(arguments));
    }

    public final CelExpr newGlobalCall(String function, Iterable<CelExpr> arguments) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        return CelExpr.newBuilder().setId(this.nextExprId()).setCall(CelExpr.CelCall.newBuilder().setFunction(function).addArgs(arguments).build()).build();
    }

    public final CelExpr newReceiverCall(String function, CelExpr target, CelExpr ... arguments) {
        return this.newReceiverCall(function, target, Arrays.asList(arguments));
    }

    public final CelExpr newReceiverCall(String function, CelExpr target, Iterable<CelExpr> arguments) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)function) ? 1 : 0) != 0);
        return CelExpr.newBuilder().setId(this.nextExprId()).setCall(CelExpr.CelCall.newBuilder().setFunction(function).setTarget(target).addArgs(arguments).build()).build();
    }

    public final CelExpr newSelect(CelExpr operand, String field, boolean testOnly) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)field) ? 1 : 0) != 0);
        return CelExpr.newBuilder().setId(this.nextExprId()).setSelect(CelExpr.CelSelect.newBuilder().setOperand(operand).setField(field).setTestOnly(testOnly).build()).build();
    }

    protected long nextExprId() {
        return this.idGenerator.nextExprId();
    }

    protected CelExprFactory() {
    }
}

