/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLong;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelReference;
import dev.cel.expr.Constant;
import dev.cel.expr.Expr;
import dev.cel.expr.Reference;
import java.util.Map;
import java.util.Optional;

public final class CelExprConverter {
    private CelExprConverter() {
    }

    public static Expr fromCelExpr(CelExpr celExpr) {
        CelExpr.ExprKind celExprKind = celExpr.exprKind();
        Expr.Builder expr = CelExprConverter.newExprBuilder(celExpr);
        switch (celExprKind.getKind()) {
            case CONSTANT: {
                return expr.setConstExpr(CelExprConverter.celConstantToExprConstant(celExprKind.constant())).build();
            }
            case IDENT: {
                return expr.setIdentExpr(Expr.Ident.newBuilder().setName(celExprKind.ident().name())).build();
            }
            case SELECT: {
                CelExpr.CelSelect celSelect = celExprKind.select();
                return expr.setSelectExpr(Expr.Select.newBuilder().setField(celSelect.field()).setOperand(CelExprConverter.fromCelExpr(celSelect.operand())).setTestOnly(celSelect.testOnly())).build();
            }
            case CALL: {
                CelExpr.CelCall celCall = celExprKind.call();
                Expr.Call.Builder callBuilder = Expr.Call.newBuilder().setFunction(celCall.function()).addAllArgs((Iterable<? extends Expr>)CelExprConverter.fromCelExprList(celCall.args()));
                celCall.target().ifPresent(target -> callBuilder.setTarget(CelExprConverter.fromCelExpr(target)));
                return expr.setCallExpr(callBuilder).build();
            }
            case CREATE_LIST: {
                CelExpr.CelCreateList celCreateList = celExprKind.createList();
                return expr.setListExpr(Expr.CreateList.newBuilder().addAllElements((Iterable<? extends Expr>)CelExprConverter.fromCelExprList(celCreateList.elements())).addAllOptionalIndices((Iterable<? extends Integer>)celCreateList.optionalIndices())).build();
            }
            case CREATE_STRUCT: {
                return expr.setStructExpr(CelExprConverter.celStructToExprStruct(celExprKind.createStruct())).build();
            }
            case CREATE_MAP: {
                return expr.setStructExpr(CelExprConverter.celMapToExprStruct(celExprKind.createMap())).build();
            }
            case COMPREHENSION: {
                CelExpr.CelComprehension celComprehension = celExprKind.comprehension();
                return expr.setComprehensionExpr(Expr.Comprehension.newBuilder().setIterVar(celComprehension.iterVar()).setIterRange(CelExprConverter.fromCelExpr(celComprehension.iterRange())).setAccuVar(celComprehension.accuVar()).setAccuInit(CelExprConverter.fromCelExpr(celComprehension.accuInit())).setLoopCondition(CelExprConverter.fromCelExpr(celComprehension.loopCondition())).setLoopStep(CelExprConverter.fromCelExpr(celComprehension.loopStep())).setResult(CelExprConverter.fromCelExpr(celComprehension.result()))).build();
            }
            case NOT_SET: {
                return expr.build();
            }
        }
        throw new IllegalArgumentException("Unexpected expression kind case: " + (Object)((Object)celExpr.exprKind().getKind()));
    }

    public static CelExpr fromExpr(Expr expr) {
        switch (expr.getExprKindCase()) {
            case CONST_EXPR: {
                return CelExpr.ofConstantExpr(expr.getId(), CelExprConverter.exprConstantToCelConstant(expr.getConstExpr()));
            }
            case IDENT_EXPR: {
                return CelExpr.ofIdentExpr(expr.getId(), expr.getIdentExpr().getName());
            }
            case SELECT_EXPR: {
                Expr.Select selectExpr = expr.getSelectExpr();
                return CelExpr.ofSelectExpr(expr.getId(), CelExprConverter.fromExpr(selectExpr.getOperand()), selectExpr.getField(), selectExpr.getTestOnly());
            }
            case CALL_EXPR: {
                Expr.Call callExpr = expr.getCallExpr();
                return CelExpr.ofCallExpr(expr.getId(), callExpr.hasTarget() ? Optional.of(CelExprConverter.fromExpr(callExpr.getTarget())) : Optional.empty(), callExpr.getFunction(), CelExprConverter.fromExprList(callExpr.getArgsList()));
            }
            case LIST_EXPR: {
                Expr.CreateList createListExpr = expr.getListExpr();
                return CelExpr.ofCreateListExpr(expr.getId(), CelExprConverter.fromExprList(createListExpr.getElementsList()), (ImmutableList<Integer>)ImmutableList.copyOf(createListExpr.getOptionalIndicesList()));
            }
            case STRUCT_EXPR: {
                return CelExprConverter.exprStructToCelStruct(expr.getId(), expr.getStructExpr());
            }
            case COMPREHENSION_EXPR: {
                Expr.Comprehension comprehensionExpr = expr.getComprehensionExpr();
                return CelExpr.ofComprehension(expr.getId(), comprehensionExpr.getIterVar(), CelExprConverter.fromExpr(comprehensionExpr.getIterRange()), comprehensionExpr.getAccuVar(), CelExprConverter.fromExpr(comprehensionExpr.getAccuInit()), CelExprConverter.fromExpr(comprehensionExpr.getLoopCondition()), CelExprConverter.fromExpr(comprehensionExpr.getLoopStep()), CelExprConverter.fromExpr(comprehensionExpr.getResult()));
            }
            case EXPRKIND_NOT_SET: {
                return CelExpr.ofNotSet(expr.getId());
            }
        }
        throw new IllegalArgumentException("Unexpected expression kind case: " + (Object)((Object)expr.getExprKindCase()));
    }

    private static ImmutableList<CelExpr> fromExprList(Iterable<Expr> exprList) {
        ImmutableList.Builder celExprListBuilder = ImmutableList.builder();
        for (Expr expr : exprList) {
            celExprListBuilder.add((Object)CelExprConverter.fromExpr(expr));
        }
        return celExprListBuilder.build();
    }

    public static CelReference exprReferenceToCelReference(Reference reference) {
        CelReference.Builder builder = CelReference.newBuilder().setName(reference.getName()).addOverloadIds((Iterable<String>)reference.getOverloadIdList());
        if (reference.hasValue()) {
            builder.setValue(CelExprConverter.exprConstantToCelConstant(reference.getValue()));
        }
        return builder.build();
    }

    public static CelConstant exprConstantToCelConstant(Constant constExpr) {
        switch (constExpr.getConstantKindCase()) {
            case CONSTANTKIND_NOT_SET: {
                return CelConstant.ofNotSet();
            }
            case NULL_VALUE: {
                return CelConstant.ofValue(constExpr.getNullValue());
            }
            case BOOL_VALUE: {
                return CelConstant.ofValue(constExpr.getBoolValue());
            }
            case INT64_VALUE: {
                return CelConstant.ofValue(constExpr.getInt64Value());
            }
            case UINT64_VALUE: {
                return CelConstant.ofValue(UnsignedLong.fromLongBits((long)constExpr.getUint64Value()));
            }
            case DOUBLE_VALUE: {
                return CelConstant.ofValue(constExpr.getDoubleValue());
            }
            case STRING_VALUE: {
                return CelConstant.ofValue(constExpr.getStringValue());
            }
            case BYTES_VALUE: {
                return CelConstant.ofValue(constExpr.getBytesValue());
            }
            case DURATION_VALUE: {
                return CelConstant.ofValue(constExpr.getDurationValue());
            }
            case TIMESTAMP_VALUE: {
                return CelConstant.ofValue(constExpr.getTimestampValue());
            }
        }
        throw new IllegalStateException("unsupported constant case: " + (Object)((Object)constExpr.getConstantKindCase()));
    }

    private static CelExpr exprStructToCelStruct(long id, Expr.CreateStruct structExpr) {
        if (!structExpr.getMessageName().isEmpty()) {
            ImmutableList.Builder entries = ImmutableList.builder();
            for (Expr.CreateStruct.Entry structExprEntry : structExpr.getEntriesList()) {
                if (!structExprEntry.getKeyKindCase().equals((Object)Expr.CreateStruct.Entry.KeyKindCase.FIELD_KEY)) {
                    throw new IllegalArgumentException("Unexpected struct key kind case: " + (Object)((Object)structExprEntry.getKeyKindCase()));
                }
                entries.add((Object)CelExpr.ofCreateStructEntryExpr(structExprEntry.getId(), structExprEntry.getFieldKey(), CelExprConverter.fromExpr(structExprEntry.getValue()), structExprEntry.getOptionalEntry()));
            }
            return CelExpr.ofCreateStructExpr(id, structExpr.getMessageName(), (ImmutableList<CelExpr.CelCreateStruct.Entry>)entries.build());
        }
        ImmutableList.Builder entries = ImmutableList.builder();
        for (Expr.CreateStruct.Entry mapExprEntry : structExpr.getEntriesList()) {
            if (!mapExprEntry.getKeyKindCase().equals((Object)Expr.CreateStruct.Entry.KeyKindCase.MAP_KEY)) {
                throw new IllegalArgumentException("Unexpected map key kind case: " + (Object)((Object)mapExprEntry.getKeyKindCase()));
            }
            entries.add((Object)CelExpr.ofCreateMapEntryExpr(mapExprEntry.getId(), CelExprConverter.fromExpr(mapExprEntry.getMapKey()), CelExprConverter.fromExpr(mapExprEntry.getValue()), mapExprEntry.getOptionalEntry()));
        }
        return CelExpr.ofCreateMapExpr(id, (ImmutableList<CelExpr.CelCreateMap.Entry>)entries.build());
    }

    private static Expr.Builder newExprBuilder(CelExpr expr) {
        return Expr.newBuilder().setId(expr.id());
    }

    public static Constant celConstantToExprConstant(CelConstant celConstant) {
        switch (celConstant.getKind()) {
            case NOT_SET: {
                return Constant.getDefaultInstance();
            }
            case NULL_VALUE: {
                return Constant.newBuilder().setNullValue(celConstant.nullValue()).build();
            }
            case BOOLEAN_VALUE: {
                return Constant.newBuilder().setBoolValue(celConstant.booleanValue()).build();
            }
            case INT64_VALUE: {
                return Constant.newBuilder().setInt64Value(celConstant.int64Value()).build();
            }
            case UINT64_VALUE: {
                return Constant.newBuilder().setUint64Value(celConstant.uint64Value().longValue()).build();
            }
            case DOUBLE_VALUE: {
                return Constant.newBuilder().setDoubleValue(celConstant.doubleValue()).build();
            }
            case STRING_VALUE: {
                return Constant.newBuilder().setStringValue(celConstant.stringValue()).build();
            }
            case BYTES_VALUE: {
                return Constant.newBuilder().setBytesValue(celConstant.bytesValue()).build();
            }
            case DURATION_VALUE: {
                return Constant.newBuilder().setDurationValue(celConstant.durationValue()).build();
            }
            case TIMESTAMP_VALUE: {
                return Constant.newBuilder().setTimestampValue(celConstant.timestampValue()).build();
            }
        }
        throw new IllegalStateException("unsupported constant case: " + (Object)((Object)celConstant.getKind()));
    }

    private static Expr.CreateStruct celStructToExprStruct(CelExpr.CelCreateStruct celCreateStruct) {
        ImmutableList.Builder entries = ImmutableList.builder();
        for (CelExpr.CelCreateStruct.Entry celStructExprEntry : celCreateStruct.entries()) {
            entries.add((Object)Expr.CreateStruct.Entry.newBuilder().setId(celStructExprEntry.id()).setFieldKey(celStructExprEntry.fieldKey()).setValue(CelExprConverter.fromCelExpr(celStructExprEntry.value())).setOptionalEntry(celStructExprEntry.optionalEntry()).build());
        }
        return Expr.CreateStruct.newBuilder().setMessageName(celCreateStruct.messageName()).addAllEntries((Iterable<? extends Expr.CreateStruct.Entry>)entries.build()).build();
    }

    private static Expr.CreateStruct celMapToExprStruct(CelExpr.CelCreateMap celCreateMap) {
        ImmutableList.Builder entries = ImmutableList.builder();
        for (CelExpr.CelCreateMap.Entry celMapEntry : celCreateMap.entries()) {
            Expr.CreateStruct.Entry exprMapEntry = Expr.CreateStruct.Entry.newBuilder().setId(celMapEntry.id()).setMapKey(CelExprConverter.fromCelExpr(celMapEntry.key())).setValue(CelExprConverter.fromCelExpr(celMapEntry.value())).setOptionalEntry(celMapEntry.optionalEntry()).build();
            entries.add((Object)exprMapEntry);
        }
        return Expr.CreateStruct.newBuilder().addAllEntries((Iterable<? extends Expr.CreateStruct.Entry>)entries.build()).build();
    }

    private static ImmutableList<Expr> fromCelExprList(Iterable<CelExpr> celExprList) {
        ImmutableList.Builder celExprListBuilder = ImmutableList.builder();
        for (CelExpr celExpr : celExprList) {
            celExprListBuilder.add((Object)CelExprConverter.fromCelExpr(celExpr));
        }
        return celExprListBuilder.build();
    }

    public static Reference celReferenceToExprReference(CelReference reference) {
        Reference.Builder builder = Reference.newBuilder().setName(reference.name()).addAllOverloadId((Iterable<String>)reference.overloadIds());
        reference.value().ifPresent(celConstant -> builder.setValue(CelExprConverter.celConstantToExprConstant(celConstant)));
        return builder.build();
    }

    public static ImmutableMap<Long, CelExpr> exprMacroCallsToCelExprMacroCalls(Map<Long, Expr> macroCalls) {
        return (ImmutableMap)macroCalls.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelExprConverter.fromExpr((Expr)v.getValue())));
    }
}

