/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.NullValue;
import com.google.protobuf.Timestamp;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.AutoOneOf_CelConstant;
import dev.cel.common.ast.AutoValue_CelConstant_CelConstantNotSet;

@Immutable
@AutoOneOf(value=Kind.class)
@Internal
public abstract class CelConstant {
    private static final ImmutableSet<Class<?>> CONSTANT_CLASSES = ImmutableSet.of(NullValue.class, Boolean.class, Long.class, UnsignedLong.class, Double.class, String.class, (Object[])new Class[]{ByteString.class});

    public abstract Kind getKind();

    public abstract CelConstantNotSet notSet();

    public abstract NullValue nullValue();

    public abstract boolean booleanValue();

    public abstract long int64Value();

    public abstract UnsignedLong uint64Value();

    public abstract double doubleValue();

    public abstract String stringValue();

    public abstract ByteString bytesValue();

    @Deprecated
    public abstract Timestamp timestampValue();

    @Deprecated
    public abstract Duration durationValue();

    public static CelConstant ofNotSet() {
        return AutoOneOf_CelConstant.notSet(new AutoValue_CelConstant_CelConstantNotSet());
    }

    public static CelConstant ofValue(NullValue value) {
        return AutoOneOf_CelConstant.nullValue(value);
    }

    public static CelConstant ofValue(boolean value) {
        return AutoOneOf_CelConstant.booleanValue(value);
    }

    public static CelConstant ofValue(long value) {
        return AutoOneOf_CelConstant.int64Value(value);
    }

    public static CelConstant ofValue(UnsignedLong value) {
        return AutoOneOf_CelConstant.uint64Value(value);
    }

    public static CelConstant ofValue(double value) {
        return AutoOneOf_CelConstant.doubleValue(value);
    }

    public static CelConstant ofValue(String value) {
        return AutoOneOf_CelConstant.stringValue(value);
    }

    public static CelConstant ofValue(ByteString value) {
        return AutoOneOf_CelConstant.bytesValue(value);
    }

    public static boolean isConstantValue(Object value) {
        return CONSTANT_CLASSES.contains(value.getClass());
    }

    public static CelConstant ofObjectValue(Object value) {
        if (value instanceof NullValue) {
            return CelConstant.ofValue((NullValue)value);
        }
        if (value instanceof Boolean) {
            return CelConstant.ofValue((Boolean)value);
        }
        if (value instanceof Long) {
            return CelConstant.ofValue((Long)value);
        }
        if (value instanceof UnsignedLong) {
            return CelConstant.ofValue((UnsignedLong)value);
        }
        if (value instanceof Double) {
            return CelConstant.ofValue((Double)value);
        }
        if (value instanceof String) {
            return CelConstant.ofValue((String)value);
        }
        if (value instanceof ByteString) {
            return CelConstant.ofValue((ByteString)value);
        }
        throw new IllegalArgumentException("Value is not a CelConstant: " + value);
    }

    @Deprecated
    public static CelConstant ofValue(Duration value) {
        return AutoOneOf_CelConstant.durationValue(value);
    }

    @Deprecated
    public static CelConstant ofValue(Timestamp value) {
        return AutoOneOf_CelConstant.timestampValue(value);
    }

    @Immutable
    @AutoValue
    public static abstract class CelConstantNotSet {
    }

    public static enum Kind {
        NOT_SET,
        NULL_VALUE,
        BOOLEAN_VALUE,
        INT64_VALUE,
        UINT64_VALUE,
        DOUBLE_VALUE,
        STRING_VALUE,
        BYTES_VALUE,
        TIMESTAMP_VALUE,
        DURATION_VALUE;

    }
}

