/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common.ast;

import com.google.common.primitives.UnsignedLong;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.NullValue;
import com.google.protobuf.Timestamp;
import dev.cel.common.ast.CelConstant;
import org.jspecify.nullness.Nullable;

final class AutoOneOf_CelConstant {
    private AutoOneOf_CelConstant() {
    }

    static CelConstant notSet(CelConstant.CelConstantNotSet notSet) {
        if (notSet == null) {
            throw new NullPointerException();
        }
        return new Impl_notSet(notSet);
    }

    static CelConstant nullValue(NullValue nullValue) {
        if (nullValue == null) {
            throw new NullPointerException();
        }
        return new Impl_nullValue(nullValue);
    }

    static CelConstant booleanValue(boolean booleanValue) {
        return new Impl_booleanValue(booleanValue);
    }

    static CelConstant int64Value(long int64Value) {
        return new Impl_int64Value(int64Value);
    }

    static CelConstant uint64Value(UnsignedLong uint64Value) {
        if (uint64Value == null) {
            throw new NullPointerException();
        }
        return new Impl_uint64Value(uint64Value);
    }

    static CelConstant doubleValue(double doubleValue) {
        return new Impl_doubleValue(doubleValue);
    }

    static CelConstant stringValue(String stringValue) {
        if (stringValue == null) {
            throw new NullPointerException();
        }
        return new Impl_stringValue(stringValue);
    }

    static CelConstant bytesValue(ByteString bytesValue) {
        if (bytesValue == null) {
            throw new NullPointerException();
        }
        return new Impl_bytesValue(bytesValue);
    }

    static CelConstant timestampValue(Timestamp timestampValue) {
        if (timestampValue == null) {
            throw new NullPointerException();
        }
        return new Impl_timestampValue(timestampValue);
    }

    static CelConstant durationValue(Duration durationValue) {
        if (durationValue == null) {
            throw new NullPointerException();
        }
        return new Impl_durationValue(durationValue);
    }

    private static final class Impl_notSet
    extends Parent_ {
        private final CelConstant.CelConstantNotSet notSet;

        Impl_notSet(CelConstant.CelConstantNotSet notSet) {
            this.notSet = notSet;
        }

        @Override
        public CelConstant.CelConstantNotSet notSet() {
            return this.notSet;
        }

        public String toString() {
            return "CelConstant{notSet=" + this.notSet + "}";
        }

        public boolean equals(@Nullable Object x) {
            if (x instanceof CelConstant) {
                CelConstant that = (CelConstant)x;
                return this.getKind() == that.getKind() && this.notSet.equals(that.notSet());
            }
            return false;
        }

        public int hashCode() {
            return this.notSet.hashCode();
        }

        @Override
        public CelConstant.Kind getKind() {
            return CelConstant.Kind.NOT_SET;
        }
    }

    private static final class Impl_nullValue
    extends Parent_ {
        private final NullValue nullValue;

        Impl_nullValue(NullValue nullValue) {
            this.nullValue = nullValue;
        }

        @Override
        public NullValue nullValue() {
            return this.nullValue;
        }

        public String toString() {
            return "CelConstant{nullValue=" + this.nullValue + "}";
        }

        public boolean equals(@Nullable Object x) {
            if (x instanceof CelConstant) {
                CelConstant that = (CelConstant)x;
                return this.getKind() == that.getKind() && this.nullValue.equals((Object)that.nullValue());
            }
            return false;
        }

        public int hashCode() {
            return this.nullValue.hashCode();
        }

        @Override
        public CelConstant.Kind getKind() {
            return CelConstant.Kind.NULL_VALUE;
        }
    }

    private static final class Impl_booleanValue
    extends Parent_ {
        private final boolean booleanValue;

        Impl_booleanValue(boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        public boolean booleanValue() {
            return this.booleanValue;
        }

        public String toString() {
            return "CelConstant{booleanValue=" + this.booleanValue + "}";
        }

        public boolean equals(@Nullable Object x) {
            if (x instanceof CelConstant) {
                CelConstant that = (CelConstant)x;
                return this.getKind() == that.getKind() && this.booleanValue == that.booleanValue();
            }
            return false;
        }

        public int hashCode() {
            return this.booleanValue ? 1231 : 1237;
        }

        @Override
        public CelConstant.Kind getKind() {
            return CelConstant.Kind.BOOLEAN_VALUE;
        }
    }

    private static final class Impl_int64Value
    extends Parent_ {
        private final long int64Value;

        Impl_int64Value(long int64Value) {
            this.int64Value = int64Value;
        }

        @Override
        public long int64Value() {
            return this.int64Value;
        }

        public String toString() {
            return "CelConstant{int64Value=" + this.int64Value + "}";
        }

        public boolean equals(@Nullable Object x) {
            if (x instanceof CelConstant) {
                CelConstant that = (CelConstant)x;
                return this.getKind() == that.getKind() && this.int64Value == that.int64Value();
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.int64Value >>> 32 ^ this.int64Value);
        }

        @Override
        public CelConstant.Kind getKind() {
            return CelConstant.Kind.INT64_VALUE;
        }
    }

    private static final class Impl_uint64Value
    extends Parent_ {
        private final UnsignedLong uint64Value;

        Impl_uint64Value(UnsignedLong uint64Value) {
            this.uint64Value = uint64Value;
        }

        @Override
        public UnsignedLong uint64Value() {
            return this.uint64Value;
        }

        public String toString() {
            return "CelConstant{uint64Value=" + this.uint64Value + "}";
        }

        public boolean equals(@Nullable Object x) {
            if (x instanceof CelConstant) {
                CelConstant that = (CelConstant)x;
                return this.getKind() == that.getKind() && this.uint64Value.equals((Object)that.uint64Value());
            }
            return false;
        }

        public int hashCode() {
            return this.uint64Value.hashCode();
        }

        @Override
        public CelConstant.Kind getKind() {
            return CelConstant.Kind.UINT64_VALUE;
        }
    }

    private static final class Impl_doubleValue
    extends Parent_ {
        private final double doubleValue;

        Impl_doubleValue(double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        public double doubleValue() {
            return this.doubleValue;
        }

        public String toString() {
            return "CelConstant{doubleValue=" + this.doubleValue + "}";
        }

        public boolean equals(@Nullable Object x) {
            if (x instanceof CelConstant) {
                CelConstant that = (CelConstant)x;
                return this.getKind() == that.getKind() && Double.doubleToLongBits(this.doubleValue) == Double.doubleToLongBits(that.doubleValue());
            }
            return false;
        }

        public int hashCode() {
            return (int)(Double.doubleToLongBits(this.doubleValue) >>> 32 ^ Double.doubleToLongBits(this.doubleValue));
        }

        @Override
        public CelConstant.Kind getKind() {
            return CelConstant.Kind.DOUBLE_VALUE;
        }
    }

    private static final class Impl_stringValue
    extends Parent_ {
        private final String stringValue;

        Impl_stringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public String stringValue() {
            return this.stringValue;
        }

        public String toString() {
            return "CelConstant{stringValue=" + this.stringValue + "}";
        }

        public boolean equals(@Nullable Object x) {
            if (x instanceof CelConstant) {
                CelConstant that = (CelConstant)x;
                return this.getKind() == that.getKind() && this.stringValue.equals(that.stringValue());
            }
            return false;
        }

        public int hashCode() {
            return this.stringValue.hashCode();
        }

        @Override
        public CelConstant.Kind getKind() {
            return CelConstant.Kind.STRING_VALUE;
        }
    }

    private static final class Impl_bytesValue
    extends Parent_ {
        private final ByteString bytesValue;

        Impl_bytesValue(ByteString bytesValue) {
            this.bytesValue = bytesValue;
        }

        @Override
        public ByteString bytesValue() {
            return this.bytesValue;
        }

        public String toString() {
            return "CelConstant{bytesValue=" + this.bytesValue + "}";
        }

        public boolean equals(@Nullable Object x) {
            if (x instanceof CelConstant) {
                CelConstant that = (CelConstant)x;
                return this.getKind() == that.getKind() && this.bytesValue.equals((Object)that.bytesValue());
            }
            return false;
        }

        public int hashCode() {
            return this.bytesValue.hashCode();
        }

        @Override
        public CelConstant.Kind getKind() {
            return CelConstant.Kind.BYTES_VALUE;
        }
    }

    private static final class Impl_timestampValue
    extends Parent_ {
        private final Timestamp timestampValue;

        Impl_timestampValue(Timestamp timestampValue) {
            this.timestampValue = timestampValue;
        }

        @Override
        public Timestamp timestampValue() {
            return this.timestampValue;
        }

        public String toString() {
            return "CelConstant{timestampValue=" + this.timestampValue + "}";
        }

        public boolean equals(@Nullable Object x) {
            if (x instanceof CelConstant) {
                CelConstant that = (CelConstant)x;
                return this.getKind() == that.getKind() && this.timestampValue.equals((Object)that.timestampValue());
            }
            return false;
        }

        public int hashCode() {
            return this.timestampValue.hashCode();
        }

        @Override
        public CelConstant.Kind getKind() {
            return CelConstant.Kind.TIMESTAMP_VALUE;
        }
    }

    private static final class Impl_durationValue
    extends Parent_ {
        private final Duration durationValue;

        Impl_durationValue(Duration durationValue) {
            this.durationValue = durationValue;
        }

        @Override
        public Duration durationValue() {
            return this.durationValue;
        }

        public String toString() {
            return "CelConstant{durationValue=" + this.durationValue + "}";
        }

        public boolean equals(@Nullable Object x) {
            if (x instanceof CelConstant) {
                CelConstant that = (CelConstant)x;
                return this.getKind() == that.getKind() && this.durationValue.equals((Object)that.durationValue());
            }
            return false;
        }

        public int hashCode() {
            return this.durationValue.hashCode();
        }

        @Override
        public CelConstant.Kind getKind() {
            return CelConstant.Kind.DURATION_VALUE;
        }
    }

    private static abstract class Parent_
    extends CelConstant {
        private Parent_() {
        }

        @Override
        public CelConstant.CelConstantNotSet notSet() {
            throw new UnsupportedOperationException(this.getKind().toString());
        }

        @Override
        public NullValue nullValue() {
            throw new UnsupportedOperationException(this.getKind().toString());
        }

        @Override
        public boolean booleanValue() {
            throw new UnsupportedOperationException(this.getKind().toString());
        }

        @Override
        public long int64Value() {
            throw new UnsupportedOperationException(this.getKind().toString());
        }

        @Override
        public UnsignedLong uint64Value() {
            throw new UnsupportedOperationException(this.getKind().toString());
        }

        @Override
        public double doubleValue() {
            throw new UnsupportedOperationException(this.getKind().toString());
        }

        @Override
        public String stringValue() {
            throw new UnsupportedOperationException(this.getKind().toString());
        }

        @Override
        public ByteString bytesValue() {
            throw new UnsupportedOperationException(this.getKind().toString());
        }

        @Override
        public Timestamp timestampValue() {
            throw new UnsupportedOperationException(this.getKind().toString());
        }

        @Override
        public Duration durationValue() {
            throw new UnsupportedOperationException(this.getKind().toString());
        }
    }
}

