/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.InlineMe;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelIssue;
import dev.cel.common.CelSource;
import dev.cel.common.CelValidationException;
import dev.cel.common.annotations.Internal;
import java.util.Comparator;
import org.jspecify.nullness.Nullable;

@Immutable
public final class CelValidationResult {
    private static final Joiner JOINER = Joiner.on((char)'\n');
    private final @Nullable Throwable failure;
    private final @Nullable CelAbstractSyntaxTree ast;
    private final CelSource source;
    private final ImmutableList<CelIssue> issues;
    private final boolean hasError;

    @Internal
    public CelValidationResult(CelSource source, ImmutableList<CelIssue> issues) {
        this(null, source, issues, null);
    }

    @Internal
    public CelValidationResult(CelSource source, Throwable failure, ImmutableList<CelIssue> issues) {
        this(null, source, issues, failure);
    }

    @Internal
    public CelValidationResult(CelAbstractSyntaxTree ast, ImmutableList<CelIssue> issues) {
        this(ast, ast.getSource(), issues, null);
    }

    private CelValidationResult(@Nullable CelAbstractSyntaxTree ast, CelSource source, ImmutableList<CelIssue> issues, @Nullable Throwable failure) {
        this.ast = ast;
        this.source = source;
        this.issues = ImmutableList.sortedCopyOf(Comparator.comparing(CelIssue::getSourceLocation), issues);
        this.hasError = issues.stream().anyMatch(CelValidationResult::issueIsError) || failure != null;
        this.failure = failure;
    }

    @CanIgnoreReturnValue
    public CelAbstractSyntaxTree getAst() throws CelValidationException {
        if (this.hasError) {
            if (this.failure != null) {
                throw new CelValidationException(this.source, (Iterable<CelIssue>)this.getErrors(), this.failure.getMessage(), this.failure);
            }
            throw new CelValidationException(this.source, (Iterable<CelIssue>)this.getErrors());
        }
        return this.ast;
    }

    public CelSource getSource() {
        return this.source;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public ImmutableList<CelIssue> getErrors() {
        return (ImmutableList)this.issues.stream().filter(CelValidationResult::issueIsError).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<CelIssue> getAllIssues() {
        return this.issues;
    }

    public String getIssueString() {
        return JOINER.join(Iterables.transform(this.issues, iss -> iss.toDisplayString(this.source)));
    }

    @Deprecated
    @InlineMe(replacement="this.getIssueString()")
    public String getDebugString() {
        return this.getIssueString();
    }

    public String getErrorString() {
        return JOINER.join(Iterables.transform(this.getErrors(), error -> error.toDisplayString(this.source)));
    }

    private static boolean issueIsError(CelIssue iss) {
        return iss.getSeverity() == CelIssue.Severity.ERROR;
    }
}

