/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dev.cel.common.CelException;
import dev.cel.common.CelIssue;
import dev.cel.common.CelSource;

public final class CelValidationException
extends CelException {
    private static final Joiner JOINER = Joiner.on((char)'\n');
    private final CelSource source;
    private final ImmutableList<CelIssue> errors;

    @VisibleForTesting
    public CelValidationException(CelSource source, Iterable<CelIssue> errors) {
        super(JOINER.join(Iterables.transform(errors, error -> error.toDisplayString(source))));
        this.source = source;
        this.errors = ImmutableList.copyOf(errors);
    }

    CelValidationException(CelSource source, Iterable<CelIssue> errors, String message, Throwable cause) {
        super(message, cause);
        this.source = source;
        this.errors = ImmutableList.copyOf(errors);
    }

    public CelSource getSource() {
        return this.source;
    }

    public ImmutableList<CelIssue> getErrors() {
        return this.errors;
    }
}

