/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelSource;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelExprConverter;
import dev.cel.common.ast.CelReference;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypes;
import dev.cel.expr.CheckedExpr;
import dev.cel.expr.Expr;
import dev.cel.expr.ParsedExpr;
import dev.cel.expr.Reference;
import dev.cel.expr.SourceInfo;
import dev.cel.expr.Type;
import java.util.Map;

public final class CelProtoAbstractSyntaxTree {
    private final CheckedExpr checkedExpr;
    private final CelAbstractSyntaxTree ast;

    private CelProtoAbstractSyntaxTree(CheckedExpr checkedExpr) {
        this.checkedExpr = checkedExpr;
        this.ast = CelAbstractSyntaxTree.newCheckedAst(CelExprConverter.fromExpr(checkedExpr.getExpr()), CelSource.newBuilder().addAllLineOffsets(checkedExpr.getSourceInfo().getLineOffsetsList()).addPositionsMap(checkedExpr.getSourceInfo().getPositionsMap()).addAllMacroCalls((Map<Long, CelExpr>)CelExprConverter.exprMacroCallsToCelExprMacroCalls(checkedExpr.getSourceInfo().getMacroCallsMap())).setDescription(checkedExpr.getSourceInfo().getLocation()).build(), (Map)checkedExpr.getReferenceMapMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelExprConverter.exprReferenceToCelReference((Reference)v.getValue()))), (Map)checkedExpr.getTypeMapMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelTypes.typeToCelType((Type)v.getValue()))));
    }

    private CelProtoAbstractSyntaxTree(CelAbstractSyntaxTree ast) {
        this.ast = ast;
        CheckedExpr.Builder checkedExprBuilder = CheckedExpr.newBuilder().setSourceInfo(SourceInfo.newBuilder().setLocation(ast.getSource().getDescription()).addAllLineOffsets((Iterable<? extends Integer>)ast.getSource().getLineOffsets()).putAllMacroCalls((Map)ast.getSource().getMacroCalls().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelExprConverter.fromCelExpr((CelExpr)v.getValue())))).putAllPositions((Map<Long, Integer>)ast.getSource().getPositionsMap())).setExpr(CelExprConverter.fromCelExpr(ast.getExpr()));
        if (ast.isChecked()) {
            checkedExprBuilder.putAllReferenceMap((Map)ast.getReferenceMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelExprConverter.celReferenceToExprReference((CelReference)v.getValue()))));
            checkedExprBuilder.putAllTypeMap((Map)ast.getTypeMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, v -> CelTypes.celTypeToType((CelType)v.getValue()))));
        }
        this.checkedExpr = checkedExprBuilder.build();
    }

    public static CelProtoAbstractSyntaxTree fromCheckedExpr(CheckedExpr checkedExpr) {
        return new CelProtoAbstractSyntaxTree(checkedExpr);
    }

    public static CelProtoAbstractSyntaxTree fromParsedExpr(ParsedExpr parsedExpr) {
        return new CelProtoAbstractSyntaxTree(CheckedExpr.newBuilder().setExpr(parsedExpr.getExpr()).setSourceInfo(parsedExpr.getSourceInfo()).build());
    }

    public static CelProtoAbstractSyntaxTree fromCelAst(CelAbstractSyntaxTree ast) {
        return new CelProtoAbstractSyntaxTree(ast);
    }

    public boolean isChecked() {
        return this.ast.isChecked();
    }

    @CheckReturnValue
    public CelAbstractSyntaxTree getAst() {
        return this.ast;
    }

    @CheckReturnValue
    public Expr getExpr() {
        return this.checkedExpr.getExpr();
    }

    @CheckReturnValue
    public CheckedExpr toCheckedExpr() {
        Preconditions.checkState((boolean)this.isChecked(), (Object)"CelAbstractSyntaxTree must be checked before it can be converted to CheckedExpr");
        return this.checkedExpr;
    }

    @CheckReturnValue
    public SourceInfo getSourceInfo() {
        return this.checkedExpr.getSourceInfo();
    }

    @CheckReturnValue
    public ParsedExpr toParsedExpr() {
        return ParsedExpr.newBuilder().setExpr(this.getExpr()).setSourceInfo(this.getSourceInfo()).build();
    }

    @CheckReturnValue
    public Type getProtoResultType() {
        return CelTypes.celTypeToType(this.ast.getResultType());
    }
}

