/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import dev.cel.common.AutoValue_CelFunctionDecl;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.annotations.Internal;
import dev.cel.expr.Decl;
import java.util.Arrays;

@Immutable
@AutoValue
public abstract class CelFunctionDecl {
    public abstract String name();

    public abstract ImmutableList<CelOverloadDecl> overloads();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_CelFunctionDecl.Builder().setOverloads((ImmutableList<CelOverloadDecl>)ImmutableList.of());
    }

    public static CelFunctionDecl newFunctionDeclaration(String functionName, CelOverloadDecl ... overloads) {
        return CelFunctionDecl.newFunctionDeclaration(functionName, Arrays.asList(overloads));
    }

    public static CelFunctionDecl newFunctionDeclaration(String functionName, Iterable<CelOverloadDecl> overloads) {
        return CelFunctionDecl.newBuilder().setName(functionName).addOverloads(overloads).build();
    }

    @Internal
    public static Decl celFunctionDeclToDecl(CelFunctionDecl celFunctionDecl) {
        return Decl.newBuilder().setName(celFunctionDecl.name()).setFunction(Decl.FunctionDecl.newBuilder().addAllOverloads((Iterable)celFunctionDecl.overloads().stream().map(CelOverloadDecl::celOverloadToOverload).collect(ImmutableList.toImmutableList()))).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract String name();

        public abstract Builder setName(String var1);

        public abstract ImmutableList<CelOverloadDecl> overloads();

        public abstract ImmutableList.Builder<CelOverloadDecl> overloadsBuilder();

        @CanIgnoreReturnValue
        public abstract Builder setOverloads(ImmutableList<CelOverloadDecl> var1);

        @CanIgnoreReturnValue
        public Builder addOverloads(CelOverloadDecl ... overloads) {
            Preconditions.checkNotNull((Object)overloads);
            return this.addOverloads(Arrays.asList(overloads));
        }

        @CanIgnoreReturnValue
        public Builder addOverloads(Iterable<CelOverloadDecl> overloads) {
            Preconditions.checkNotNull(overloads);
            this.overloadsBuilder().addAll(overloads);
            return this;
        }

        @CheckReturnValue
        public abstract CelFunctionDecl build();
    }
}

