/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import dev.cel.common.CelDescriptors;
import dev.cel.common.internal.FileDescriptorSetConverter;
import dev.cel.common.types.CelTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class CelDescriptorUtil {
    private CelDescriptorUtil() {
    }

    public static <T extends Descriptors.GenericDescriptor> ImmutableMap<String, T> descriptorCollectionToMap(Collection<T> descriptors) {
        ImmutableMap.Builder descriptorMapBuilder = new ImmutableMap.Builder();
        descriptors.forEach(d -> descriptorMapBuilder.put((Object)d.getFullName(), d));
        return descriptorMapBuilder.buildOrThrow();
    }

    public static ImmutableSet<Descriptors.FileDescriptor> getFileDescriptorsForDescriptors(Iterable<Descriptors.Descriptor> descriptors) {
        ImmutableSet.Builder fileDescriptors = ImmutableSet.builder();
        descriptors.forEach(d -> fileDescriptors.add((Object)d.getFile()));
        return CelDescriptorUtil.getFileDescriptorsAndDependencies((Iterable<Descriptors.FileDescriptor>)fileDescriptors.build());
    }

    public static ImmutableSet<Descriptors.FileDescriptor> getFileDescriptorsFromFileDescriptorSet(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        return FileDescriptorSetConverter.convert(fileDescriptorSet);
    }

    public static CelDescriptors getAllDescriptorsFromFileDescriptor(Descriptors.FileDescriptor ... fileDescriptors) {
        return CelDescriptorUtil.getAllDescriptorsFromFileDescriptor(Arrays.asList(fileDescriptors));
    }

    public static CelDescriptors getAllDescriptorsFromFileDescriptor(Iterable<Descriptors.FileDescriptor> fileDescriptors) {
        return CelDescriptorUtil.getAllDescriptorsFromFileDescriptor(fileDescriptors, true);
    }

    public static CelDescriptors getAllDescriptorsFromFileDescriptor(Iterable<Descriptors.FileDescriptor> fileDescriptors, boolean resolveTypeDependencies) {
        ImmutableSet allFileDescriptors = resolveTypeDependencies ? CelDescriptorUtil.getFileDescriptorsAndDependencies(fileDescriptors) : ImmutableSet.copyOf(fileDescriptors);
        CelDescriptors.Builder celDescriptorsBuilder = CelDescriptors.builder();
        allFileDescriptors.forEach(fd -> CelDescriptorUtil.collectAllDescriptorsFromFileDescriptor(fd, celDescriptorsBuilder));
        return celDescriptorsBuilder.build();
    }

    private static void collectAllDescriptorsFromFileDescriptor(Descriptors.FileDescriptor fileDescriptor, CelDescriptors.Builder celDescriptors) {
        celDescriptors.addFileDescriptors(fileDescriptor);
        CelDescriptorUtil.collectEnumDescriptors(fileDescriptor, celDescriptors);
        CelDescriptorUtil.collectMessageTypeDescriptors(fileDescriptor, celDescriptors);
        CelDescriptorUtil.collectExtensions(fileDescriptor, celDescriptors);
    }

    private static void collectEnumDescriptors(Descriptors.FileDescriptor fileDescriptor, CelDescriptors.Builder celDescriptors) {
        HashSet visitedDescriptors = new HashSet();
        celDescriptors.addEnumDescriptors(fileDescriptor.getEnumTypes());
        fileDescriptor.getMessageTypes().forEach(d -> CelDescriptorUtil.collectEnumDescriptors(d, visitedDescriptors, celDescriptors));
        fileDescriptor.getExtensions().forEach(ext -> CelDescriptorUtil.collectEnumDescriptors(ext, celDescriptors));
    }

    private static void collectEnumDescriptors(Descriptors.Descriptor descriptor, Set<String> visitedDescriptors, CelDescriptors.Builder celDescriptors) {
        if (visitedDescriptors.contains(descriptor.getFullName())) {
            return;
        }
        visitedDescriptors.add(descriptor.getFullName());
        celDescriptors.addEnumDescriptors(descriptor.getEnumTypes());
        descriptor.getFields().forEach(field -> CelDescriptorUtil.collectEnumDescriptors(field, celDescriptors));
        descriptor.getNestedTypes().forEach(nested -> CelDescriptorUtil.collectEnumDescriptors(nested, visitedDescriptors, celDescriptors));
    }

    private static void collectEnumDescriptors(Descriptors.FieldDescriptor fieldDescriptor, CelDescriptors.Builder celDescriptors) {
        if (!fieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.ENUM)) {
            return;
        }
        celDescriptors.addEnumDescriptors(fieldDescriptor.getEnumType());
    }

    private static void collectMessageTypeDescriptors(Descriptors.FileDescriptor descriptor, CelDescriptors.Builder celDescriptors) {
        HashSet visited = new HashSet();
        descriptor.getMessageTypes().forEach(d -> CelDescriptorUtil.collectMessageTypeDescriptors(d, visited, celDescriptors));
    }

    private static void collectMessageTypeDescriptors(Descriptors.Descriptor descriptor, Set<String> visited, CelDescriptors.Builder celDescriptors) {
        String messageName = descriptor.getFullName();
        if (visited.contains(messageName)) {
            return;
        }
        if (!descriptor.getOptions().getMapEntry()) {
            visited.add(messageName);
            celDescriptors.addMessageTypeDescriptors(descriptor);
        }
        if (CelTypes.getWellKnownCelType(messageName).isPresent()) {
            return;
        }
        descriptor.getNestedTypes().forEach(nested -> CelDescriptorUtil.collectMessageTypeDescriptors(nested, visited, celDescriptors));
        descriptor.getFields().forEach(field -> CelDescriptorUtil.collectFieldDescriptors(field, visited, celDescriptors));
        celDescriptors.addExtensionDescriptors(descriptor.getExtensions());
    }

    private static void collectExtensions(Descriptors.FileDescriptor fileDescriptor, CelDescriptors.Builder celDescriptors) {
        celDescriptors.addExtensionDescriptors(fileDescriptor.getExtensions());
        HashSet visited = new HashSet();
        fileDescriptor.getExtensions().forEach(d -> CelDescriptorUtil.collectFieldDescriptors(d, visited, celDescriptors));
    }

    private static void collectFieldDescriptors(Descriptors.FieldDescriptor fieldDescriptor, Set<String> visited, CelDescriptors.Builder celDescriptors) {
        if (!fieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
            return;
        }
        Descriptors.Descriptor fieldMessageType = fieldDescriptor.getMessageType();
        if (fieldDescriptor.isMapField()) {
            Descriptors.FieldDescriptor valueDescriptor = (Descriptors.FieldDescriptor)fieldDescriptor.getMessageType().getFields().get(1);
            if (valueDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
                CelDescriptorUtil.collectMessageTypeDescriptors(valueDescriptor.getMessageType(), visited, celDescriptors);
            }
        } else {
            CelDescriptorUtil.collectMessageTypeDescriptors(fieldMessageType, visited, celDescriptors);
        }
    }

    private static ImmutableSet<Descriptors.FileDescriptor> getFileDescriptorsAndDependencies(Iterable<Descriptors.FileDescriptor> fileDescriptors) {
        HashSet visited = new HashSet();
        ImmutableSet.Builder expandedFileDescriptors = ImmutableSet.builder();
        ImmutableSet.copyOf(fileDescriptors).forEach(fd -> CelDescriptorUtil.copyToFileDescriptorSet(visited, fd, (ImmutableSet.Builder<Descriptors.FileDescriptor>)expandedFileDescriptors));
        return expandedFileDescriptors.build();
    }

    private static void copyToFileDescriptorSet(Set<String> visited, Descriptors.FileDescriptor fd, ImmutableSet.Builder<Descriptors.FileDescriptor> files) {
        if (visited.contains(fd.getFullName())) {
            return;
        }
        visited.add(fd.getFullName());
        for (Descriptors.FileDescriptor dep : fd.getDependencies()) {
            CelDescriptorUtil.copyToFileDescriptorSet(visited, dep, files);
        }
        files.add((Object)fd);
    }
}

