/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Empty;
import com.google.protobuf.NullValue;
import dev.cel.common.annotations.Internal;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypes;
import dev.cel.common.types.ListType;
import dev.cel.common.types.MapType;
import dev.cel.common.types.NullableType;
import dev.cel.common.types.OpaqueType;
import dev.cel.common.types.OptionalType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.types.TypeType;
import dev.cel.expr.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.nullness.Nullable;

@Internal
public final class Types {
    public static final String ANY_MESSAGE = "google.protobuf.Any";
    public static final String DURATION_MESSAGE = "google.protobuf.Duration";
    public static final String LIST_VALUE_MESSAGE = "google.protobuf.ListValue";
    public static final String STRUCT_MESSAGE = "google.protobuf.Struct";
    public static final String TIMESTAMP_MESSAGE = "google.protobuf.Timestamp";
    public static final String VALUE_MESSAGE = "google.protobuf.Value";
    public static final String BOOL_WRAPPER_MESSAGE = "google.protobuf.BoolValue";
    public static final String BYTES_WRAPPER_MESSAGE = "google.protobuf.BytesValue";
    public static final String DOUBLE_WRAPPER_MESSAGE = "google.protobuf.DoubleValue";
    public static final String FLOAT_WRAPPER_MESSAGE = "google.protobuf.FloatValue";
    public static final String INT32_WRAPPER_MESSAGE = "google.protobuf.Int32Value";
    public static final String INT64_WRAPPER_MESSAGE = "google.protobuf.Int64Value";
    public static final String STRING_WRAPPER_MESSAGE = "google.protobuf.StringValue";
    public static final String UINT32_WRAPPER_MESSAGE = "google.protobuf.UInt32Value";
    public static final String UINT64_WRAPPER_MESSAGE = "google.protobuf.UInt64Value";
    public static final Type ERROR = Type.newBuilder().setError(Empty.getDefaultInstance()).build();
    public static final Type DYN = Type.newBuilder().setDyn(Empty.getDefaultInstance()).build();
    public static final Type NULL_TYPE = Type.newBuilder().setNull(NullValue.NULL_VALUE).build();
    public static final Type BOOL = Types.create(Type.PrimitiveType.BOOL);
    public static final Type BYTES = Types.create(Type.PrimitiveType.BYTES);
    public static final Type STRING = Types.create(Type.PrimitiveType.STRING);
    public static final Type DOUBLE = Types.create(Type.PrimitiveType.DOUBLE);
    public static final Type UINT64 = Types.create(Type.PrimitiveType.UINT64);
    public static final Type INT64 = Types.create(Type.PrimitiveType.INT64);
    public static final Type ANY = Types.create(Type.WellKnownType.ANY);
    public static final Type TIMESTAMP = Types.create(Type.WellKnownType.TIMESTAMP);
    public static final Type DURATION = Types.create(Type.WellKnownType.DURATION);
    static final ImmutableMap<String, Type> WELL_KNOWN_TYPE_MAP = ImmutableMap.builder().put((Object)"google.protobuf.DoubleValue", (Object)Types.createWrapper(DOUBLE)).put((Object)"google.protobuf.FloatValue", (Object)Types.createWrapper(DOUBLE)).put((Object)"google.protobuf.Int64Value", (Object)Types.createWrapper(INT64)).put((Object)"google.protobuf.Int32Value", (Object)Types.createWrapper(INT64)).put((Object)"google.protobuf.UInt64Value", (Object)Types.createWrapper(UINT64)).put((Object)"google.protobuf.UInt32Value", (Object)Types.createWrapper(UINT64)).put((Object)"google.protobuf.BoolValue", (Object)Types.createWrapper(BOOL)).put((Object)"google.protobuf.StringValue", (Object)Types.createWrapper(STRING)).put((Object)"google.protobuf.BytesValue", (Object)Types.createWrapper(BYTES)).put((Object)"google.protobuf.Timestamp", (Object)TIMESTAMP).put((Object)"google.protobuf.Duration", (Object)DURATION).put((Object)"google.protobuf.Struct", (Object)Types.createMap(STRING, DYN)).put((Object)"google.protobuf.Value", (Object)DYN).put((Object)"google.protobuf.ListValue", (Object)Types.createList(DYN)).put((Object)"google.protobuf.Any", (Object)ANY).buildOrThrow();
    static final ImmutableMap<DescriptorProtos.FieldDescriptorProto.Type, Type> PRIMITIVE_TYPE_MAP = ImmutableMap.builder().put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE, (Object)DOUBLE).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT, (Object)DOUBLE).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32, (Object)INT64).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64, (Object)INT64).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32, (Object)INT64).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64, (Object)INT64).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32, (Object)INT64).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64, (Object)INT64).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32, (Object)UINT64).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64, (Object)UINT64).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32, (Object)UINT64).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64, (Object)UINT64).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL, (Object)BOOL).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING, (Object)STRING).put((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES, (Object)BYTES).buildOrThrow();

    public static Type create(Type.PrimitiveType type) {
        return Type.newBuilder().setPrimitive(type).build();
    }

    public static Type create(Type.WellKnownType type) {
        return Type.newBuilder().setWellKnown(type).build();
    }

    public static Type create(Type target) {
        return Type.newBuilder().setType(target).build();
    }

    public static Type createList(Type elemType) {
        return Type.newBuilder().setListType(Type.ListType.newBuilder().setElemType(elemType)).build();
    }

    public static Type createMap(Type keyType, Type valueType) {
        return Type.newBuilder().setMapType(Type.MapType.newBuilder().setKeyType(keyType).setValueType(valueType)).build();
    }

    public static Type createMessage(String messageName) {
        return Type.newBuilder().setMessageType(messageName).build();
    }

    public static Type createTypeParam(String name) {
        return Type.newBuilder().setTypeParam(name).build();
    }

    public static Type createWrapper(Type.PrimitiveType primitive) {
        return Type.newBuilder().setWrapper(primitive).build();
    }

    public static Type createWrapper(Type type) {
        Preconditions.checkArgument((type.getTypeKindCase() == Type.TypeKindCase.PRIMITIVE ? 1 : 0) != 0);
        return Types.createWrapper(type.getPrimitive());
    }

    @Deprecated
    public static boolean isDynOrError(Type type) {
        return Types.isDynOrError(CelTypes.typeToCelType(type));
    }

    public static boolean isDynOrError(CelType type) {
        switch (type.kind()) {
            case ERROR: {
                return true;
            }
        }
        return Types.isDyn(type);
    }

    public static boolean isDyn(CelType type) {
        switch (type.kind()) {
            case DYN: 
            case ANY: {
                return true;
            }
        }
        return false;
    }

    private static boolean isTypeParam(CelType type) {
        return type.kind().equals((Object)CelKind.TYPE_PARAM);
    }

    public static CelType mostGeneral(CelType type1, CelType type2) {
        return Types.isEqualOrLessSpecific(type1, type2) ? type1 : type2;
    }

    public static @Nullable Map<CelType, CelType> isAssignable(Map<CelType, CelType> subs, CelType type1, CelType type2) {
        HashMap<CelType, CelType> subsCopy = new HashMap<CelType, CelType>(subs);
        if (Types.internalIsAssignable(subsCopy, type1, type2)) {
            return subsCopy;
        }
        return null;
    }

    @Deprecated
    public static @Nullable Map<Type, Type> isAssignable(Map<Type, Type> subs, Type type1, Type type2) {
        HashMap subsCopy = subs.entrySet().stream().collect(Collectors.toMap(k -> CelTypes.typeToCelType((Type)k.getKey()), v -> CelTypes.typeToCelType((Type)v.getValue()), (prev, next) -> next, HashMap::new));
        if (Types.internalIsAssignable((Map<CelType, CelType>)subsCopy, CelTypes.typeToCelType(type1), CelTypes.typeToCelType(type2))) {
            return subsCopy.entrySet().stream().collect(Collectors.toMap(k -> CelTypes.celTypeToType((CelType)k.getKey()), v -> CelTypes.celTypeToType((CelType)v.getValue()), (prev, next) -> next, HashMap::new));
        }
        return null;
    }

    public static @Nullable Map<CelType, CelType> isAssignable(Map<CelType, CelType> subs, List<CelType> list1, List<CelType> list2) {
        HashMap<CelType, CelType> subsCopy = new HashMap<CelType, CelType>(subs);
        if (Types.internalIsAssignable(subsCopy, list1, list2)) {
            return subsCopy;
        }
        return null;
    }

    private static boolean internalIsAssignable(Map<CelType, CelType> subs, CelType type1, CelType type2) {
        if (type1.equals(type2)) {
            return true;
        }
        if (Types.isTypeParam(type2)) {
            if (subs.containsKey(type2)) {
                CelType t2Sub = subs.get(type2);
                if (!Types.internalIsAssignable(subs, type1, t2Sub)) {
                    return false;
                }
                CelType t2New = Types.mostGeneral(type1, t2Sub);
                if (Types.notReferencedIn(subs, type2, t2New)) {
                    subs.put(type2, t2New);
                }
                return true;
            }
            if (Types.notReferencedIn(subs, type2, type1)) {
                subs.put(type2, type1);
                return true;
            }
        }
        if (Types.isTypeParam(type1)) {
            if (subs.containsKey(type1)) {
                CelType t1Sub = subs.get(type1);
                if (!Types.internalIsAssignable(subs, t1Sub, type2)) {
                    return false;
                }
                CelType t1New = Types.mostGeneral(t1Sub, type2);
                if (Types.notReferencedIn(subs, type1, t1New)) {
                    subs.put(type1, t1New);
                }
                return true;
            }
            if (Types.notReferencedIn(subs, type1, type2)) {
                subs.put(type1, type2);
                return true;
            }
        }
        if (Types.isDynOrError(type1) || Types.isDynOrError(type2)) {
            return true;
        }
        if (type1.kind() == CelKind.NULL_TYPE) {
            return Types.isAssignableFromNull(type2);
        }
        if (type2.kind() == CelKind.NULL_TYPE) {
            return Types.isAssignableFromNull(type1);
        }
        if (type1.kind() != type2.kind()) {
            return false;
        }
        switch (type1.kind()) {
            case TYPE: {
                return true;
            }
            case OPAQUE: 
            case LIST: 
            case MAP: {
                return Types.internalIsCandidateAssignableToTarget(subs, type1, type2);
            }
        }
        return type2.isAssignableFrom(type1);
    }

    private static boolean internalIsAssignable(Map<CelType, CelType> subs, List<CelType> list1, List<CelType> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        int i = 0;
        for (CelType type : list1) {
            if (Types.internalIsAssignable(subs, type, list2.get(i++))) continue;
            return false;
        }
        return true;
    }

    private static boolean internalIsCandidateAssignableToTarget(Map<CelType, CelType> subs, CelType candidate, CelType target) {
        return candidate.name().equals(target.name()) && Types.internalIsAssignable(subs, candidate.parameters(), target.parameters());
    }

    private static boolean isAssignableFromNull(CelType targetType) {
        switch (targetType.kind()) {
            case OPAQUE: 
            case STRUCT: 
            case DURATION: 
            case TIMESTAMP: {
                return true;
            }
        }
        return targetType.isAssignableFrom(SimpleType.NULL_TYPE);
    }

    @Deprecated
    public static boolean isEqualOrLessSpecific(Type type1, Type type2) {
        return Types.isEqualOrLessSpecific(CelTypes.typeToCelType(type1), CelTypes.typeToCelType(type2));
    }

    public static boolean isEqualOrLessSpecific(CelType type1, CelType type2) {
        if (Types.isDyn(type1) || Types.isTypeParam(type1)) {
            return true;
        }
        if (Types.isDyn(type2) || Types.isTypeParam(type2)) {
            return false;
        }
        if (type1.kind() != type2.kind()) {
            return false;
        }
        switch (type1.kind()) {
            case OPAQUE: 
            case LIST: 
            case MAP: {
                if (!type1.kind().equals((Object)type2.kind())) {
                    return false;
                }
                if (!type1.name().equals(type2.name())) {
                    return false;
                }
                return Types.isEqualOrLessSpecific(type1.parameters(), type2.parameters());
            }
            case TYPE: {
                TypeType typeType1 = (TypeType)type1;
                TypeType typeType2 = (TypeType)type2;
                return Types.isEqualOrLessSpecific(typeType1.type(), typeType2.type());
            }
        }
        return type1.equals(type2);
    }

    private static boolean isEqualOrLessSpecific(List<CelType> types1, List<CelType> types2) {
        if (types1.size() != types2.size()) {
            return false;
        }
        for (int i = 0; i < types1.size(); ++i) {
            if (Types.isEqualOrLessSpecific(types1.get(i), types2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean notReferencedIn(Map<CelType, CelType> subs, CelType type, CelType withinType) {
        if (type.equals(withinType)) {
            return false;
        }
        if (withinType instanceof NullableType) {
            return Types.notReferencedIn(subs, type, ((NullableType)withinType).targetType());
        }
        switch (withinType.kind()) {
            case TYPE_PARAM: {
                return !subs.containsKey(withinType) || Types.notReferencedIn(subs, type, subs.get(withinType));
            }
            case OPAQUE: {
                for (CelType typeArg : withinType.parameters()) {
                    if (Types.notReferencedIn(subs, type, typeArg)) continue;
                    return false;
                }
                return true;
            }
            case LIST: {
                ListType listType = (ListType)withinType;
                return Types.notReferencedIn(subs, type, listType.elemType());
            }
            case MAP: {
                MapType mapType = (MapType)withinType;
                return Types.notReferencedIn(subs, type, mapType.keyType()) && Types.notReferencedIn(subs, type, mapType.valueType());
            }
            case TYPE: {
                TypeType typeType = (TypeType)withinType;
                return Types.notReferencedIn(subs, type, typeType.type());
            }
        }
        return true;
    }

    @Deprecated
    public static Type substitute(Map<Type, Type> subs, Type type, boolean typeParamToDyn) {
        ImmutableMap.Builder subsMap = ImmutableMap.builder();
        for (Map.Entry<Type, Type> sub : subs.entrySet()) {
            subsMap.put((Object)CelTypes.typeToCelType(sub.getKey()), (Object)CelTypes.typeToCelType(sub.getValue()));
        }
        return CelTypes.celTypeToType(Types.substitute((Map<CelType, CelType>)subsMap.buildOrThrow(), CelTypes.typeToCelType(type), typeParamToDyn));
    }

    public static CelType substitute(Map<CelType, CelType> subs, CelType type, boolean typeParamToDyn) {
        if (subs.containsKey(type)) {
            return Types.substitute(subs, subs.get(type), typeParamToDyn);
        }
        if (typeParamToDyn && Types.isTypeParam(type)) {
            return SimpleType.DYN;
        }
        switch (type.kind()) {
            case OPAQUE: {
                ImmutableList.Builder parameterTypes = new ImmutableList.Builder();
                for (int i = 0; i < type.parameters().size(); ++i) {
                    parameterTypes.add((Object)Types.substitute(subs, (CelType)type.parameters().get(i), typeParamToDyn));
                }
                if (type instanceof OptionalType) {
                    return OptionalType.create((CelType)parameterTypes.build().get(0));
                }
                return OpaqueType.create(type.name(), new CelType[0]).withParameters((ImmutableList<CelType>)parameterTypes.build());
            }
            case LIST: {
                ListType listType = (ListType)type;
                return ListType.create(Types.substitute(subs, listType.elemType(), typeParamToDyn));
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return MapType.create(Types.substitute(subs, mapType.keyType(), typeParamToDyn), Types.substitute(subs, mapType.valueType(), typeParamToDyn));
            }
            case TYPE: {
                TypeType newType = (TypeType)type;
                return TypeType.create(Types.substitute(subs, newType.type(), typeParamToDyn));
            }
        }
        return type;
    }

    private Types() {
    }
}

