/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import dev.cel.checker.CelIdentDecl;
import dev.cel.checker.ProtoTypeMask;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypeProvider;
import dev.cel.common.types.ProtoMessageType;
import dev.cel.common.types.StructType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

@Immutable
public final class ProtoTypeMaskTypeProvider
implements CelTypeProvider {
    private final ImmutableMap<String, CelType> allTypes;
    private final ImmutableList<ProtoTypeMask> protoTypeMasks;

    ProtoTypeMaskTypeProvider(CelTypeProvider delegateProvider, ImmutableList<ProtoTypeMask> protoTypeMasks) {
        this.protoTypeMasks = protoTypeMasks;
        this.allTypes = ProtoTypeMaskTypeProvider.computeVisibleFieldsMap(delegateProvider, protoTypeMasks);
    }

    @Override
    public ImmutableCollection<CelType> types() {
        return this.allTypes.values();
    }

    @Override
    public Optional<CelType> findType(String typeName) {
        return Optional.ofNullable((CelType)this.allTypes.get((Object)typeName));
    }

    ImmutableList<CelIdentDecl> computeDeclsFromProtoTypeMasks() {
        ImmutableList.Builder decls = ImmutableList.builder();
        for (ProtoTypeMask typeMask : this.protoTypeMasks) {
            Optional<CelType> celType;
            if (!typeMask.fieldsAreVariableDeclarations() || !(celType = this.findType(typeMask.getTypeName())).isPresent() || celType.get().kind() != CelKind.STRUCT) continue;
            StructType celStruct = (StructType)celType.get();
            for (StructType.Field field : celStruct.fields()) {
                decls.add((Object)CelIdentDecl.newIdentDeclaration(field.name(), field.type()));
            }
        }
        return decls.build();
    }

    private static ImmutableMap<String, CelType> computeVisibleFieldsMap(CelTypeProvider delegateProvider, ImmutableList<ProtoTypeMask> protoTypeMasks) {
        HashMap<String, Set> fieldMap = new HashMap<String, Set>();
        for (ProtoTypeMask typeMask : protoTypeMasks) {
            Optional<CelType> rootType = delegateProvider.findType(typeMask.getTypeName());
            Preconditions.checkArgument((boolean)rootType.isPresent(), (String)"message not registered: %s", (Object)typeMask.getTypeName());
            if (typeMask.areAllFieldPathsExposed()) continue;
            CelType type = rootType.get();
            Preconditions.checkArgument((boolean)(type instanceof ProtoMessageType), (String)"type is not a protobuf: %s", (Object)type.name());
            block1: for (ProtoTypeMask.FieldPath fieldPath : typeMask.getFieldPathsExposed()) {
                CelType targetType = type;
                for (String fieldName : fieldPath.getFieldSelection()) {
                    Preconditions.checkArgument((boolean)(targetType instanceof ProtoMessageType), (String)"could not select field %s from type %s", (Object)fieldName, (Object)targetType.name());
                    ProtoMessageType messageType = (ProtoMessageType)targetType;
                    String messageTypeName = targetType.name();
                    if (fieldName.equals("*")) continue block1;
                    Optional<StructType.Field> fieldType = messageType.findField(fieldName);
                    Preconditions.checkArgument((boolean)fieldType.isPresent(), (String)"message %s does not declare field: %s", (Object)messageTypeName, (Object)fieldName);
                    Set fields = fieldMap.computeIfAbsent(messageTypeName, unused -> new HashSet());
                    fields.add(fieldName);
                    targetType = fieldType.get().type();
                }
            }
        }
        ImmutableMap.Builder maskedTypes = ImmutableMap.builder();
        for (CelType type : delegateProvider.types()) {
            if (fieldMap.containsKey(type.name())) {
                ProtoMessageType messageType = (ProtoMessageType)type;
                messageType = messageType.withVisibleFields((ImmutableSet<String>)ImmutableSet.copyOf((Collection)((Collection)fieldMap.get(type.name()))));
                maskedTypes.put((Object)type.name(), (Object)messageType);
                continue;
            }
            maskedTypes.put((Object)type.name(), (Object)type);
        }
        return maskedTypes.buildOrThrow();
    }
}

