/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.checker;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CheckReturnValue;
import dev.cel.checker.AutoValue_ExprChecker_OverloadResolution;
import dev.cel.checker.CelIdentDecl;
import dev.cel.checker.Env;
import dev.cel.checker.InferenceContext;
import dev.cel.checker.TypeFormatter;
import dev.cel.checker.TypeProvider;
import dev.cel.checker.Types;
import dev.cel.common.CelAbstractSyntaxTree;
import dev.cel.common.CelFunctionDecl;
import dev.cel.common.CelOverloadDecl;
import dev.cel.common.CelProtoAbstractSyntaxTree;
import dev.cel.common.annotations.Internal;
import dev.cel.common.ast.CelConstant;
import dev.cel.common.ast.CelExpr;
import dev.cel.common.ast.CelReference;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.CelTypes;
import dev.cel.common.types.ListType;
import dev.cel.common.types.MapType;
import dev.cel.common.types.OptionalType;
import dev.cel.common.types.SimpleType;
import dev.cel.common.types.TypeType;
import dev.cel.expr.CheckedExpr;
import dev.cel.expr.ParsedExpr;
import dev.cel.expr.Type;
import dev.cel.parser.Operator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jspecify.nullness.Nullable;

@Deprecated
@Internal
public final class ExprChecker {
    private final Env env;
    private final TypeProvider typeProvider;
    private final String inContainer;
    private final Map<Long, Integer> positionMap;
    private final InferenceContext inferenceContext;
    private final boolean compileTimeOverloadResolution;
    private final boolean homogeneousLiterals;
    private final boolean namespacedDeclarations;
    private static final TypeProvider.FieldType ERROR = TypeProvider.FieldType.of(Types.ERROR);

    @CheckReturnValue
    @Deprecated
    public static CheckedExpr check(Env env, String inContainer, ParsedExpr parsedExpr) {
        return ExprChecker.typecheck(env, inContainer, parsedExpr, (Optional<Type>)Optional.absent());
    }

    @CheckReturnValue
    @Deprecated
    public static CheckedExpr typecheck(Env env, String inContainer, ParsedExpr parsedExpr, Optional<Type> expectedResultType) {
        Optional type = expectedResultType.isPresent() ? Optional.of((Object)CelTypes.typeToCelType((Type)expectedResultType.get())) : Optional.absent();
        CelAbstractSyntaxTree ast = ExprChecker.typecheck(env, inContainer, CelProtoAbstractSyntaxTree.fromParsedExpr(parsedExpr).getAst(), (Optional<CelType>)type);
        if (ast.isChecked()) {
            return CelProtoAbstractSyntaxTree.fromCelAst(ast).toCheckedExpr();
        }
        return CheckedExpr.newBuilder().setExpr(parsedExpr.getExpr()).setSourceInfo(parsedExpr.getSourceInfo()).build();
    }

    @CheckReturnValue
    @Internal
    public static CelAbstractSyntaxTree typecheck(Env env, String inContainer, CelAbstractSyntaxTree ast, Optional<CelType> expectedResultType) {
        env.resetTypeAndRefMaps();
        ExprChecker checker = new ExprChecker(env, inContainer, (Map<Long, Integer>)ast.getSource().getPositionsMap(), new InferenceContext(), env.enableCompileTimeOverloadResolution(), env.enableHomogeneousLiterals(), env.enableNamespacedDeclarations());
        CelExpr expr = checker.visit(ast.getExpr());
        if (expectedResultType.isPresent()) {
            checker.assertType(expr, (CelType)expectedResultType.get());
        }
        Map typeMap = Maps.transformValues(env.getTypeMap(), checker.inferenceContext::finalize);
        return CelAbstractSyntaxTree.newCheckedAst(expr, ast.getSource(), env.getRefMap(), typeMap);
    }

    private ExprChecker(Env env, String inContainer, Map<Long, Integer> positionMap, InferenceContext inferenceContext, boolean compileTimeOverloadResolution, boolean homogeneousLiterals, boolean namespacedDeclarations) {
        this.env = (Env)Preconditions.checkNotNull((Object)env);
        this.typeProvider = env.getTypeProvider();
        this.positionMap = (Map)Preconditions.checkNotNull(positionMap);
        this.inContainer = (String)Preconditions.checkNotNull((Object)inContainer);
        this.inferenceContext = (InferenceContext)Preconditions.checkNotNull((Object)inferenceContext);
        this.compileTimeOverloadResolution = compileTimeOverloadResolution;
        this.homogeneousLiterals = homogeneousLiterals;
        this.namespacedDeclarations = namespacedDeclarations;
    }

    @CheckReturnValue
    public CelExpr visit(CelExpr expr) {
        switch (expr.exprKind().getKind()) {
            case CONSTANT: {
                return this.visit(expr, expr.constant());
            }
            case IDENT: {
                return this.visit(expr, expr.ident());
            }
            case SELECT: {
                return this.visit(expr, expr.select());
            }
            case CALL: {
                return this.visit(expr, expr.call());
            }
            case CREATE_LIST: {
                return this.visit(expr, expr.createList());
            }
            case CREATE_STRUCT: {
                return this.visit(expr, expr.createStruct());
            }
            case CREATE_MAP: {
                return this.visit(expr, expr.createMap());
            }
            case COMPREHENSION: {
                return this.visit(expr, expr.comprehension());
            }
        }
        throw new IllegalArgumentException("unexpected expr kind");
    }

    @CheckReturnValue
    private CelExpr visit(CelExpr expr, CelConstant constant) {
        switch (constant.getKind()) {
            case INT64_VALUE: {
                this.env.setType(expr, SimpleType.INT);
                break;
            }
            case UINT64_VALUE: {
                this.env.setType(expr, SimpleType.UINT);
                break;
            }
            case STRING_VALUE: {
                this.env.setType(expr, SimpleType.STRING);
                break;
            }
            case BYTES_VALUE: {
                this.env.setType(expr, SimpleType.BYTES);
                break;
            }
            case BOOLEAN_VALUE: {
                this.env.setType(expr, SimpleType.BOOL);
                break;
            }
            case NULL_VALUE: {
                this.env.setType(expr, SimpleType.NULL_TYPE);
                break;
            }
            case DOUBLE_VALUE: {
                this.env.setType(expr, SimpleType.DOUBLE);
                break;
            }
            case TIMESTAMP_VALUE: {
                this.env.setType(expr, SimpleType.TIMESTAMP);
                break;
            }
            case DURATION_VALUE: {
                this.env.setType(expr, SimpleType.DURATION);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected constant case: " + (Object)((Object)constant.getKind()));
            }
        }
        return expr;
    }

    @CheckReturnValue
    private CelExpr visit(CelExpr expr, CelExpr.CelIdent ident) {
        CelIdentDecl decl = this.env.lookupIdent(this.getPosition(expr), this.inContainer, ident.name());
        Preconditions.checkNotNull((Object)decl);
        if (decl.equals(Env.ERROR_IDENT_DECL)) {
            this.env.setType(expr, SimpleType.ERROR);
            this.env.setRef(expr, this.makeReference(decl));
            return expr;
        }
        if (!decl.name().equals(ident.name())) {
            expr = ExprChecker.replaceIdentSubtree(expr, decl.name());
        }
        this.env.setType(expr, decl.type());
        this.env.setRef(expr, this.makeReference(decl));
        return expr;
    }

    @CheckReturnValue
    private CelExpr visit(CelExpr expr, CelExpr.CelSelect select) {
        CelIdentDecl decl;
        String qname = this.asQualifiedName(expr);
        if (qname != null && (decl = this.env.tryLookupCelIdent(this.inContainer, qname)) != null) {
            if (select.testOnly()) {
                this.env.reportError(this.getPosition(expr), "expression does not select a field", new Object[0]);
                this.env.setType(expr, SimpleType.BOOL);
            } else {
                if (this.namespacedDeclarations) {
                    expr = ExprChecker.replaceIdentSubtree(expr, decl.name());
                }
                this.env.setType(expr, decl.type());
                this.env.setRef(expr, this.makeReference(decl));
            }
            return expr;
        }
        CelExpr visitedOperand = this.visit(select.operand());
        if (this.namespacedDeclarations && !select.operand().equals(visitedOperand)) {
            expr = ExprChecker.replaceSelectOperandSubtree(expr, visitedOperand);
        }
        CelType resultType = this.visitSelectField(expr, visitedOperand, select.field(), false);
        if (select.testOnly()) {
            resultType = SimpleType.BOOL;
        }
        this.env.setType(expr, resultType);
        return expr;
    }

    @CheckReturnValue
    private CelExpr visit(CelExpr expr, CelExpr.CelCall call) {
        OverloadResolution resolution;
        String functionName = call.function();
        if (Operator.OPTIONAL_SELECT.getFunction().equals(functionName)) {
            return this.visitOptionalCall(expr, call);
        }
        ImmutableList<CelExpr> argsList = call.args();
        for (int i = 0; i < argsList.size(); ++i) {
            CelExpr arg = (CelExpr)argsList.get(i);
            CelExpr visitedArg = this.visit(arg);
            if (!this.namespacedDeclarations || visitedArg.equals(arg)) continue;
            expr = ExprChecker.replaceCallArgumentSubtree(expr, visitedArg, i);
        }
        int position = this.getPosition(expr);
        if (!call.target().isPresent()) {
            CelFunctionDecl decl = this.env.lookupFunction(position, this.inContainer, call.function());
            resolution = this.resolveOverload(position, decl, null, (List<CelExpr>)call.args());
            if (!decl.name().equals(call.function()) && this.namespacedDeclarations) {
                expr = ExprChecker.replaceCallSubtree(expr, decl.name());
            }
        } else {
            String qualifiedName = this.asQualifiedName(call.target().get());
            CelFunctionDecl decl = this.env.tryLookupCelFunction(this.inContainer, qualifiedName + "." + call.function());
            if (decl != null) {
                resolution = this.resolveOverload(position, decl, null, (List<CelExpr>)call.args());
                if (this.namespacedDeclarations) {
                    expr = ExprChecker.replaceCallSubtree(expr, decl.name());
                }
            } else {
                CelExpr target = call.target().get();
                CelExpr visitedTargetExpr = this.visit(target);
                if (this.namespacedDeclarations && !visitedTargetExpr.equals(target)) {
                    expr = ExprChecker.replaceCallSubtree(expr, visitedTargetExpr);
                }
                resolution = this.resolveOverload(position, this.env.lookupFunction(this.getPosition(expr), this.inContainer, call.function()), target, (List<CelExpr>)call.args());
            }
        }
        this.env.setType(expr, resolution.type());
        this.env.setRef(expr, resolution.reference());
        return expr;
    }

    @CheckReturnValue
    private CelExpr visit(CelExpr expr, CelExpr.CelCreateStruct createStruct) {
        CelType messageType = SimpleType.ERROR;
        CelIdentDecl decl = this.env.lookupIdent(this.getPosition(expr), this.inContainer, createStruct.messageName());
        this.env.setRef(expr, CelReference.newBuilder().setName(decl.name()).build());
        CelType type = decl.type();
        if (type.kind() != CelKind.ERROR) {
            if (type.kind() != CelKind.TYPE) {
                this.env.reportError(this.getPosition(expr), "'%s' is not a type", CelTypes.format(type));
            } else {
                messageType = ((TypeType)type).type();
                if (messageType.kind() != CelKind.STRUCT) {
                    this.env.reportError(this.getPosition(expr), "'%s' is not a message type", CelTypes.format(messageType));
                    messageType = SimpleType.ERROR;
                }
            }
        }
        if (Env.isWellKnownType(messageType)) {
            this.env.setType(expr, Env.getWellKnownType(messageType));
        } else {
            this.env.setType(expr, messageType);
        }
        ImmutableList<CelExpr.CelCreateStruct.Entry> entriesList = createStruct.entries();
        for (int i = 0; i < entriesList.size(); ++i) {
            CelExpr.CelCreateStruct.Entry entry = (CelExpr.CelCreateStruct.Entry)entriesList.get(i);
            CelExpr visitedValueExpr = this.visit(entry.value());
            if (this.namespacedDeclarations && !visitedValueExpr.equals(entry.value())) {
                expr = ExprChecker.replaceStructEntryValueSubtree(expr, visitedValueExpr, i);
            }
            CelType fieldType = this.getFieldType(this.getPosition(entry), messageType, entry.fieldKey()).celType();
            CelType valueType = this.env.getType(visitedValueExpr);
            if (entry.optionalEntry()) {
                if (valueType instanceof OptionalType) {
                    valueType = this.unwrapOptional(valueType);
                } else {
                    this.assertIsAssignable(this.getPosition(visitedValueExpr), valueType, OptionalType.create(valueType));
                }
            }
            if (this.inferenceContext.isAssignable(fieldType, valueType)) continue;
            this.env.reportError(this.getPosition(entry), "expected type of field '%s' is '%s' but provided type is '%s'", entry.fieldKey(), CelTypes.format(fieldType), CelTypes.format(valueType));
        }
        return expr;
    }

    @CheckReturnValue
    private CelExpr visit(CelExpr expr, CelExpr.CelCreateMap createMap) {
        CelType mapKeyType = null;
        CelType mapValueType = null;
        ImmutableList<CelExpr.CelCreateMap.Entry> entriesList = createMap.entries();
        for (int i = 0; i < entriesList.size(); ++i) {
            CelExpr.CelCreateMap.Entry entry = (CelExpr.CelCreateMap.Entry)entriesList.get(i);
            CelExpr visitedMapKeyExpr = this.visit(entry.key());
            if (this.namespacedDeclarations && !visitedMapKeyExpr.equals(entry.key())) {
                expr = ExprChecker.replaceMapEntryKeySubtree(expr, visitedMapKeyExpr, i);
            }
            mapKeyType = this.joinTypes(this.getPosition(visitedMapKeyExpr), mapKeyType, this.env.getType(visitedMapKeyExpr));
            CelExpr visitedValueExpr = this.visit(entry.value());
            if (this.namespacedDeclarations && !visitedValueExpr.equals(entry.value())) {
                expr = ExprChecker.replaceMapEntryValueSubtree(expr, visitedValueExpr, i);
            }
            CelType valueType = this.env.getType(visitedValueExpr);
            if (entry.optionalEntry()) {
                if (valueType instanceof OptionalType) {
                    valueType = this.unwrapOptional(valueType);
                } else {
                    this.assertIsAssignable(this.getPosition(visitedValueExpr), valueType, OptionalType.create(valueType));
                }
            }
            mapValueType = this.joinTypes(this.getPosition(visitedValueExpr), mapValueType, valueType);
        }
        if (mapKeyType == null) {
            mapKeyType = this.inferenceContext.newTypeVar("key");
            mapValueType = this.inferenceContext.newTypeVar("value");
        }
        this.env.setType(expr, MapType.create(mapKeyType, mapValueType));
        return expr;
    }

    @CheckReturnValue
    private CelExpr visit(CelExpr expr, CelExpr.CelCreateList createList) {
        CelType elemsType = null;
        ImmutableList<CelExpr> elementsList = createList.elements();
        HashSet<Integer> optionalIndices = new HashSet<Integer>((Collection<Integer>)createList.optionalIndices());
        for (int i = 0; i < elementsList.size(); ++i) {
            CelExpr visitedElem = this.visit((CelExpr)elementsList.get(i));
            if (this.namespacedDeclarations && !visitedElem.equals(elementsList.get(i))) {
                expr = ExprChecker.replaceListElementSubtree(expr, visitedElem, i);
            }
            CelType elemType = this.env.getType(visitedElem);
            if (optionalIndices.contains(i)) {
                if (elemType instanceof OptionalType) {
                    elemType = this.unwrapOptional(elemType);
                } else {
                    this.assertIsAssignable(this.getPosition(visitedElem), elemType, OptionalType.create(elemType));
                }
            }
            elemsType = this.joinTypes(this.getPosition(visitedElem), elemsType, elemType);
        }
        if (elemsType == null) {
            elemsType = this.inferenceContext.newTypeVar("elem");
        }
        this.env.setType(expr, ListType.create(elemsType));
        return expr;
    }

    @CheckReturnValue
    private CelExpr visit(CelExpr expr, CelExpr.CelComprehension compre) {
        CelType varType;
        CelExpr visitedRange = this.visit(compre.iterRange());
        if (this.namespacedDeclarations && !visitedRange.equals(compre.iterRange())) {
            expr = ExprChecker.replaceComprehensionRangeSubtree(expr, visitedRange);
        }
        CelExpr init = this.visit(compre.accuInit());
        CelType accuType = this.env.getType(init);
        CelType rangeType = this.inferenceContext.specialize(this.env.getType(visitedRange));
        switch (rangeType.kind()) {
            case LIST: {
                varType = ((ListType)rangeType).elemType();
                break;
            }
            case MAP: {
                varType = ((MapType)rangeType).keyType();
                break;
            }
            case DYN: 
            case ERROR: {
                varType = SimpleType.DYN;
                break;
            }
            case TYPE_PARAM: {
                this.inferenceContext.isAssignable(SimpleType.DYN, rangeType);
                varType = SimpleType.DYN;
                break;
            }
            default: {
                this.env.reportError(this.getPosition(visitedRange), "expression of type '%s' cannot be range of a comprehension (must be list, map, or dynamic)", CelTypes.format(rangeType));
                varType = SimpleType.DYN;
            }
        }
        this.env.enterScope();
        this.env.add(CelIdentDecl.newIdentDeclaration(compre.accuVar(), accuType));
        this.env.enterScope();
        this.env.add(CelIdentDecl.newIdentDeclaration(compre.iterVar(), varType));
        CelExpr condition = this.visit(compre.loopCondition());
        this.assertType(condition, SimpleType.BOOL);
        CelExpr visitedStep = this.visit(compre.loopStep());
        if (this.namespacedDeclarations && !visitedStep.equals(compre.loopStep())) {
            expr = ExprChecker.replaceComprehensionStepSubtree(expr, visitedStep);
        }
        this.assertType(visitedStep, accuType);
        this.env.exitScope();
        CelExpr visitedResult = this.visit(compre.result());
        if (this.namespacedDeclarations && !visitedResult.equals(compre.result())) {
            expr = ExprChecker.replaceComprehensionResultSubtree(expr, visitedResult);
        }
        this.env.exitScope();
        this.env.setType(expr, this.inferenceContext.specialize(this.env.getType(visitedResult)));
        return expr;
    }

    private CelReference makeReference(CelIdentDecl decl) {
        CelReference.Builder ref = CelReference.newBuilder().setName(decl.name());
        if (decl.constant().isPresent()) {
            ref.setValue(decl.constant().get());
        }
        return ref.build();
    }

    private OverloadResolution resolveOverload(int position, @Nullable CelFunctionDecl function, @Nullable CelExpr target, List<CelExpr> args) {
        if (function == null || function.equals(Env.ERROR_FUNCTION_DECL)) {
            return OverloadResolution.of(CelReference.newBuilder().build(), SimpleType.ERROR);
        }
        ArrayList<CelType> argTypes = new ArrayList<CelType>();
        if (target != null) {
            argTypes.add(this.env.getType(target));
        }
        for (CelExpr arg : args) {
            argTypes.add(this.env.getType(arg));
        }
        CelType resultType = null;
        String firstCandString = null;
        CelReference.Builder refBuilder = CelReference.newBuilder();
        ArrayList<String> excludedCands = new ArrayList<String>();
        String expectedString = TypeFormatter.formatFunction(this.inferenceContext.specialize(argTypes), target != null);
        for (CelOverloadDecl overload : function.overloads()) {
            boolean isInstance = overload.isInstanceFunction();
            if (target == null && isInstance || target != null && !isInstance) continue;
            CelType overloadType = CelTypes.createFunctionType(overload.resultType(), overload.parameterTypes());
            if (!overload.typeParameterNames().isEmpty()) {
                overloadType = this.inferenceContext.newInstance((Iterable<String>)overload.typeParameterNames(), overloadType);
            }
            ImmutableList candArgTypes = overloadType.parameters().subList(1, overloadType.parameters().size());
            String candString = TypeFormatter.formatFunction(this.inferenceContext.specialize((List<CelType>)candArgTypes), target != null);
            if (this.inferenceContext.isAssignable(argTypes, (List<CelType>)candArgTypes)) {
                refBuilder.addOverloadIds(overload.overloadId());
                if (resultType == null) {
                    resultType = this.inferenceContext.specialize((CelType)overloadType.parameters().get(0));
                    firstCandString = candString;
                    continue;
                }
                CelType fnResultType = (CelType)this.inferenceContext.specialize(overloadType).parameters().get(0);
                if (!Types.isDyn(resultType) && !resultType.equals(fnResultType)) {
                    resultType = SimpleType.DYN;
                }
                if (!this.compileTimeOverloadResolution) continue;
                this.env.reportError(position, "found more than one matching overload for '%s' applied to '%s': %s and also %s", function.name(), expectedString, firstCandString, candString);
                continue;
            }
            excludedCands.add(candString);
        }
        if (resultType == null) {
            this.env.reportError(position, "found no matching overload for '%s' applied to '%s'%s", function.name(), expectedString, excludedCands.isEmpty() ? "" : " (candidates: " + Joiner.on((char)',').join(excludedCands) + ")");
            resultType = SimpleType.ERROR;
        }
        return OverloadResolution.of(refBuilder.build(), resultType);
    }

    private CelType visitSelectField(CelExpr expr, CelExpr operand, String field, boolean isOptional) {
        CelType operandType = this.inferenceContext.specialize(this.env.getType(operand));
        CelType resultType = SimpleType.ERROR;
        if (operandType instanceof OptionalType) {
            isOptional = true;
            operandType = this.unwrapOptional(operandType);
        }
        if (!Types.isDynOrError(operandType)) {
            if (operandType.kind() == CelKind.STRUCT) {
                TypeProvider.FieldType fieldType = this.getFieldType(this.getPosition(expr), operandType, field);
                resultType = fieldType.celType();
            } else if (operandType.kind() == CelKind.MAP) {
                resultType = ((MapType)operandType).valueType();
            } else if (operandType.kind() == CelKind.TYPE_PARAM) {
                this.inferenceContext.isAssignable(SimpleType.DYN, operandType);
                resultType = SimpleType.DYN;
            } else {
                this.env.reportError(this.getPosition(expr), "type '%s' does not support field selection", CelTypes.format(operandType));
            }
        } else {
            resultType = SimpleType.DYN;
        }
        if (isOptional) {
            resultType = OptionalType.create(resultType);
        }
        return resultType;
    }

    private CelExpr visitOptionalCall(CelExpr expr, CelExpr.CelCall call) {
        CelExpr operand = (CelExpr)call.args().get(0);
        CelExpr field = (CelExpr)call.args().get(1);
        if (!field.exprKind().getKind().equals((Object)CelExpr.ExprKind.Kind.CONSTANT) || field.constant().getKind() != CelConstant.Kind.STRING_VALUE) {
            this.env.reportError(this.getPosition(field), "unsupported optional field selection", new Object[0]);
            return expr;
        }
        CelExpr visitedOperand = this.visit(operand);
        if (this.namespacedDeclarations && !operand.equals(visitedOperand)) {
            expr = ExprChecker.replaceSelectOperandSubtree(expr, visitedOperand);
        }
        CelType resultType = this.visitSelectField(expr, operand, field.constant().stringValue(), true);
        this.env.setType(expr, resultType);
        this.env.setRef(expr, CelReference.newBuilder().addOverloadIds("select_optional_field").build());
        return expr;
    }

    private @Nullable String asQualifiedName(CelExpr expr) {
        switch (expr.exprKind().getKind()) {
            case IDENT: {
                return expr.ident().name();
            }
            case SELECT: {
                String qname = this.asQualifiedName(expr.select().operand());
                if (qname != null) {
                    return qname + "." + expr.select().field();
                }
                return null;
            }
        }
        return null;
    }

    private TypeProvider.FieldType getFieldType(int position, CelType type, String fieldName) {
        String typeName = type.name();
        if (this.typeProvider.lookupCelType(typeName).isPresent()) {
            TypeProvider.FieldType fieldType = this.typeProvider.lookupFieldType(type, fieldName);
            if (fieldType != null) {
                return fieldType;
            }
            TypeProvider.ExtensionFieldType extensionFieldType = this.typeProvider.lookupExtensionType(fieldName);
            if (extensionFieldType != null) {
                return extensionFieldType.fieldType();
            }
            this.env.reportError(position, "undefined field '%s'", fieldName);
        } else {
            this.env.reportError(position, "Message type resolution failure while referencing field '%s'. Ensure that the descriptor for type '%s' was added to the environment", fieldName, typeName);
        }
        return ERROR;
    }

    private CelType joinTypes(int position, CelType previousType, CelType type) {
        if (previousType == null) {
            return type;
        }
        if (this.homogeneousLiterals) {
            this.assertIsAssignable(position, type, previousType);
        } else if (!this.inferenceContext.isAssignable(previousType, type)) {
            return SimpleType.DYN;
        }
        return Types.mostGeneral(previousType, type);
    }

    private void assertIsAssignable(int position, CelType actual, CelType expected) {
        if (!this.inferenceContext.isAssignable(expected, actual)) {
            this.env.reportError(position, "expected type '%s' but found '%s'", CelTypes.format(expected), CelTypes.format(actual));
        }
    }

    private CelType unwrapOptional(CelType type) {
        return (CelType)type.parameters().get(0);
    }

    private void assertType(CelExpr expr, CelType type) {
        this.assertIsAssignable(this.getPosition(expr), this.env.getType(expr), type);
    }

    private int getPosition(CelExpr expr) {
        Integer pos = this.positionMap.get(expr.id());
        return pos == null ? 0 : pos;
    }

    private int getPosition(CelExpr.CelCreateStruct.Entry entry) {
        Integer pos = this.positionMap.get(entry.id());
        return pos == null ? 0 : pos;
    }

    private static CelExpr replaceIdentSubtree(CelExpr expr, String name) {
        CelExpr.CelIdent newIdent = CelExpr.CelIdent.newBuilder().setName(name).build();
        return expr.toBuilder().setIdent(newIdent).build();
    }

    private static CelExpr replaceSelectOperandSubtree(CelExpr expr, CelExpr operand) {
        CelExpr.CelSelect newSelect = expr.select().toBuilder().setOperand(operand).build();
        return expr.toBuilder().setSelect(newSelect).build();
    }

    private static CelExpr replaceCallArgumentSubtree(CelExpr expr, CelExpr newArg, int index) {
        CelExpr.CelCall newCall = expr.call().toBuilder().setArg(index, newArg).build();
        return expr.toBuilder().setCall(newCall).build();
    }

    private static CelExpr replaceCallSubtree(CelExpr expr, String functionName) {
        CelExpr.CelCall newCall = expr.call().toBuilder().setFunction(functionName).clearTarget().build();
        return expr.toBuilder().setCall(newCall).build();
    }

    private static CelExpr replaceCallSubtree(CelExpr expr, CelExpr target) {
        CelExpr.CelCall newCall = expr.call().toBuilder().setTarget(target).build();
        return expr.toBuilder().setCall(newCall).build();
    }

    private static CelExpr replaceListElementSubtree(CelExpr expr, CelExpr element, int index) {
        CelExpr.CelCreateList newList = expr.createList().toBuilder().setElement(index, element).build();
        return expr.toBuilder().setCreateList(newList).build();
    }

    private static CelExpr replaceStructEntryValueSubtree(CelExpr expr, CelExpr newValue, int index) {
        CelExpr.CelCreateStruct createStruct = expr.createStruct();
        CelExpr.CelCreateStruct.Entry newEntry = ((CelExpr.CelCreateStruct.Entry)createStruct.entries().get(index)).toBuilder().setValue(newValue).build();
        createStruct = createStruct.toBuilder().setEntry(index, newEntry).build();
        return expr.toBuilder().setCreateStruct(createStruct).build();
    }

    private static CelExpr replaceMapEntryKeySubtree(CelExpr expr, CelExpr newKey, int index) {
        CelExpr.CelCreateMap createMap = expr.createMap();
        CelExpr.CelCreateMap.Entry newEntry = ((CelExpr.CelCreateMap.Entry)createMap.entries().get(index)).toBuilder().setKey(newKey).build();
        createMap = createMap.toBuilder().setEntry(index, newEntry).build();
        return expr.toBuilder().setCreateMap(createMap).build();
    }

    private static CelExpr replaceMapEntryValueSubtree(CelExpr expr, CelExpr newValue, int index) {
        CelExpr.CelCreateMap createMap = expr.createMap();
        CelExpr.CelCreateMap.Entry newEntry = ((CelExpr.CelCreateMap.Entry)createMap.entries().get(index)).toBuilder().setValue(newValue).build();
        createMap = createMap.toBuilder().setEntry(index, newEntry).build();
        return expr.toBuilder().setCreateMap(createMap).build();
    }

    private static CelExpr replaceComprehensionRangeSubtree(CelExpr expr, CelExpr newRange) {
        CelExpr.CelComprehension newComprehension = expr.comprehension().toBuilder().setIterRange(newRange).build();
        return expr.toBuilder().setComprehension(newComprehension).build();
    }

    private static CelExpr replaceComprehensionStepSubtree(CelExpr expr, CelExpr newStep) {
        CelExpr.CelComprehension newComprehension = expr.comprehension().toBuilder().setLoopStep(newStep).build();
        return expr.toBuilder().setComprehension(newComprehension).build();
    }

    private static CelExpr replaceComprehensionResultSubtree(CelExpr expr, CelExpr newResult) {
        CelExpr.CelComprehension newComprehension = expr.comprehension().toBuilder().setResult(newResult).build();
        return expr.toBuilder().setComprehension(newComprehension).build();
    }

    @AutoValue
    protected static abstract class OverloadResolution {
        protected OverloadResolution() {
        }

        public abstract CelReference reference();

        public abstract CelType type();

        public static OverloadResolution of(CelReference reference, CelType type) {
            return new AutoValue_ExprChecker_OverloadResolution(reference, type);
        }
    }
}

