/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.matcher.categorize;

import dev.brachtendorf.jimagehash.matcher.PlainImageMatcher;
import dev.brachtendorf.jimagehash.matcher.categorize.CategoricalImageMatcher;
import dev.brachtendorf.jimagehash.matcher.categorize.CategorizationResult;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCategoricalMatcher
extends PlainImageMatcher
implements CategoricalImageMatcher {
    protected Map<Integer, List<String>> cachedImagesInCategory = new HashMap<Integer, List<String>>();
    protected Map<String, Integer> reverseImageCategoryMap = new HashMap<String, Integer>();

    @Override
    public abstract CategorizationResult categorizeImageAndAdd(BufferedImage var1, String var2);

    @Override
    public int getCategory(String uniqueId) {
        int category = this.reverseImageCategoryMap.get(uniqueId);
        return category;
    }

    @Override
    public CategorizationResult categorizeImage(BufferedImage bi) {
        return this.categorizeImage(null, bi);
    }

    protected abstract CategorizationResult categorizeImage(String var1, BufferedImage var2);

    public boolean isCategorized(String uniqueId) {
        return this.reverseImageCategoryMap.containsKey(uniqueId);
    }

    @Override
    public List<Integer> getCategories() {
        ArrayList<Integer> categoriesAsList = new ArrayList<Integer>(this.cachedImagesInCategory.keySet());
        categoriesAsList.sort(null);
        return Collections.unmodifiableList(categoriesAsList);
    }

    @Override
    public List<String> getImagesInCategory(int category) {
        return this.cachedImagesInCategory.get(category);
    }

    public int getImageCountInCategory(int category) {
        return this.cachedImagesInCategory.get(category).size();
    }
}

