/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.matcher;

import dev.brachtendorf.jimagehash.hash.Hash;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class TypedImageMatcher {
    protected LinkedHashMap<HashingAlgorithm, AlgoSettings> steps = new LinkedHashMap();

    public void addHashingAlgorithm(HashingAlgorithm algo, double threshold) {
        this.addHashingAlgorithm(algo, threshold, true);
    }

    public void addHashingAlgorithm(HashingAlgorithm algo, double threshold, boolean normalized) {
        if (threshold < 0.0) {
            throw new IllegalArgumentException("Fatal error adding algorithm. Threshold has to be in the range of [0-X)");
        }
        if (normalized && threshold > 1.0) {
            throw new IllegalArgumentException("Fatal error adding algorithm. Normalized threshold has to be in the range of [0-1]");
        }
        this.steps.put(algo, new AlgoSettings(threshold, normalized));
    }

    public boolean removeHashingAlgo(HashingAlgorithm algo) {
        return this.steps.remove(algo) != null;
    }

    public void clearHashingAlgorithms() {
        this.steps.clear();
    }

    public Map<HashingAlgorithm, AlgoSettings> getAlgorithms() {
        return Collections.unmodifiableMap(new LinkedHashMap<HashingAlgorithm, AlgoSettings>(this.steps));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.steps == null ? 0 : this.steps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedImageMatcher other = (TypedImageMatcher)obj;
        return !(this.steps == null ? other.steps != null : !this.steps.equals(other.steps));
    }

    public static class AlgoSettings
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private double threshold;
        private boolean normalized;

        public AlgoSettings(double threshold, boolean normalized) {
            this.threshold = threshold;
            this.normalized = normalized;
        }

        public boolean apply(Hash hash, Hash hash1) {
            if (this.normalized) {
                return hash.normalizedHammingDistanceFast(hash1) <= this.threshold;
            }
            return (double)hash.hammingDistanceFast(hash1) <= this.threshold;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public boolean isNormalized() {
            return this.normalized;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.normalized ? 1231 : 1237);
            long temp = Double.doubleToLongBits(this.threshold);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AlgoSettings)) {
                return false;
            }
            AlgoSettings other = (AlgoSettings)obj;
            if (this.normalized != other.normalized) {
                return false;
            }
            return Double.doubleToLongBits(this.threshold) == Double.doubleToLongBits(other.threshold);
        }

        public String toString() {
            return "AlgoSettings [threshold=" + this.threshold + ", normalized=" + this.normalized + "]";
        }
    }
}

