/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms.filter;

import dev.brachtendorf.Require;
import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hashAlgorithms.filter.Filter;
import dev.brachtendorf.jimagehash.hashAlgorithms.filter.MultiKernel;
import java.awt.image.BufferedImage;

public class SobelFilter
implements Filter {
    private static final long serialVersionUID = -794573990315594591L;
    private MultiKernel xKernel;
    private MultiKernel yKernel;
    private double threshold;

    public SobelFilter(double threshold) {
        this.threshold = (Double)Require.inRange((Number)threshold, (Number)0, (Number)1, (String)"Threshold must be in range of [0-1]");
        double[][] x0Mask = new double[][]{{1.0}, {2.0}, {1.0}};
        double[][] x1Mask = new double[][]{{1.0, 0.0, -1.0}};
        double[][] y0Mask = new double[][]{{1.0}, {0.0}, {-1.0}};
        double[][] y1Mask = new double[][]{{1.0, 2.0, 1.0}};
        this.xKernel = new MultiKernel(x1Mask, x0Mask);
        this.yKernel = new MultiKernel(y0Mask, y1Mask);
    }

    @Override
    public BufferedImage filter(BufferedImage bi) {
        FastPixel fp = FastPixel.create((BufferedImage)bi);
        int[][] grayscale = fp.getAverageGrayscale();
        int[][] xGradient = this.xKernel.applyInt(grayscale);
        int[][] yGradient = this.yKernel.applyInt(grayscale);
        int[][] result = new int[xGradient.length][xGradient[0].length];
        int cutOffValue = (int)(this.threshold * 255.0);
        for (int x = 0; x < xGradient.length; ++x) {
            for (int y = 0; y < xGradient[x].length; ++y) {
                result[x][y] = (int)Math.sqrt(xGradient[x][y] * xGradient[x][y] + yGradient[x][y] * yGradient[x][y]);
                if (result[x][y] < 0) {
                    result[x][y] = -result[x][y];
                }
                if (result[x][y] >= cutOffValue) continue;
                result[x][y] = 0;
            }
        }
        BufferedImage returnBi = new BufferedImage(bi.getWidth(), bi.getHeight(), bi.getType());
        FastPixel fpSet = FastPixel.create((BufferedImage)returnBi);
        fpSet.setAverageGrayscale(result);
        if (fpSet.hasAlpha()) {
            fpSet.setAlpha(fp.getAlpha());
        }
        return returnBi;
    }
}

