/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms.filter;

import dev.brachtendorf.ArrayUtil;
import dev.brachtendorf.jimagehash.hashAlgorithms.filter.Kernel;

public abstract class NonAveragingKernel
extends Kernel {
    private static final long serialVersionUID = -6587002283239284704L;

    @Deprecated
    protected NonAveragingKernel(Kernel.EdgeHandlingStrategy strat) {
        super(strat);
    }

    public NonAveragingKernel(int width, int height) {
        super(Kernel.EdgeHandlingStrategy.EXPAND);
        if (width <= 0 || width % 2 == 0 || height <= 0 || height % 2 == 0) {
            throw new IllegalArgumentException("Currently only odd dimensional kernels are supported. Width & height have to be positive");
        }
        double[][] mask = new double[width][height];
        ArrayUtil.fillArrayMulti((Object)mask, () -> Double.valueOf(1.0));
        this.mask = mask;
    }

    public NonAveragingKernel(double[][] mask) {
        super(mask);
    }

    protected double[][] computePotentialValues(byte[][] input, int x, int y) {
        int maskW = this.mask[0].length / 2;
        int maskH = this.mask.length / 2;
        int width = input[0].length;
        int height = input.length;
        double[][] values = new double[2][this.mask.length * this.mask[0].length];
        int index = 0;
        for (int yMask = -maskH; yMask <= maskH; ++yMask) {
            for (int xMask = -maskW; xMask <= maskW; ++xMask) {
                int yPixelIndex;
                int xPixelIndex;
                if (this.edgeHandling.equals((Object)Kernel.EdgeHandlingStrategy.NO_OP)) {
                    xPixelIndex = x + xMask;
                    yPixelIndex = y + yMask;
                    if (xPixelIndex < 0 || xPixelIndex >= width || yPixelIndex < 0 || yPixelIndex >= height) {
                        return new double[][]{{input[y][x]}, {Double.MIN_VALUE}};
                    }
                } else {
                    xPixelIndex = this.edgeHandling.correctPixel(x + xMask, width);
                    yPixelIndex = this.edgeHandling.correctPixel(y + yMask, height);
                }
                values[0][index] = input[yPixelIndex][xPixelIndex];
                values[1][index++] = this.mask[yMask + maskH][xMask + maskW] * (double)input[yPixelIndex][xPixelIndex];
            }
        }
        return values;
    }

    protected double[][] computePotentialValues(int[][] input, int x, int y) {
        int maskW = this.mask[0].length / 2;
        int maskH = this.mask.length / 2;
        int width = input[0].length;
        int height = input.length;
        double[][] values = new double[2][this.mask.length * this.mask[0].length];
        int index = 0;
        for (int yMask = -maskH; yMask <= maskH; ++yMask) {
            for (int xMask = -maskW; xMask <= maskW; ++xMask) {
                int yPixelIndex;
                int xPixelIndex;
                if (this.edgeHandling.equals((Object)Kernel.EdgeHandlingStrategy.NO_OP)) {
                    xPixelIndex = x + xMask;
                    yPixelIndex = y + yMask;
                    if (xPixelIndex < 0 || xPixelIndex >= width || yPixelIndex < 0 || yPixelIndex >= height) {
                        return new double[][]{{input[y][x]}, {0.0}};
                    }
                } else {
                    xPixelIndex = this.edgeHandling.correctPixel(x + xMask, width);
                    yPixelIndex = this.edgeHandling.correctPixel(y + yMask, height);
                }
                values[0][index] = input[yPixelIndex][xPixelIndex];
                values[1][index++] = this.mask[yMask + maskH][xMask + maskW] * (double)input[yPixelIndex][xPixelIndex];
            }
        }
        return values;
    }

    protected double[][] computePotentialValues(double[][] input, int x, int y) {
        int maskW = this.mask[0].length / 2;
        int maskH = this.mask.length / 2;
        int width = input[0].length;
        int height = input.length;
        double[][] values = new double[2][this.mask.length * this.mask[0].length];
        int index = 0;
        for (int yMask = -maskH; yMask <= maskH; ++yMask) {
            for (int xMask = -maskW; xMask <= maskW; ++xMask) {
                int yPixelIndex;
                int xPixelIndex;
                if (this.edgeHandling.equals((Object)Kernel.EdgeHandlingStrategy.NO_OP)) {
                    xPixelIndex = x + xMask;
                    yPixelIndex = y + yMask;
                    if (xPixelIndex < 0 || xPixelIndex >= width || yPixelIndex < 0 || yPixelIndex >= height) {
                        return new double[][]{{input[y][x]}, {0.0}};
                    }
                } else {
                    xPixelIndex = this.edgeHandling.correctPixel(x + xMask, width);
                    yPixelIndex = this.edgeHandling.correctPixel(y + yMask, height);
                }
                values[0][index] = input[yPixelIndex][xPixelIndex];
                values[1][index++] = this.mask[yMask + maskH][xMask + maskW] * input[yPixelIndex][xPixelIndex];
            }
        }
        return values;
    }
}

