/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hashAlgorithms;

import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashBuilder;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.Objects;
import java.util.logging.Logger;
import org.jtransforms.dct.DoubleDCT_2D;
import org.jtransforms.utils.CommonUtils;

public class PerceptiveHash
extends HashingAlgorithm {
    private static final long serialVersionUID = 8409228150836051697L;
    private static final Logger LOGGER = Logger.getLogger(PerceptiveHash.class.getSimpleName());
    private int height;
    private int width;

    public PerceptiveHash(int bitResolution) {
        super(bitResolution);
        this.computeDimensions(bitResolution);
        if ((long)(this.width * this.height) >= CommonUtils.getThreadsBeginN_2D()) {
            LOGGER.warning("Due to an unfortunate design decision in JTransform a threadpool will be kept alive after finishing calculation possibly block jvm termination.  You see this message because calculating an unusual high bit resolution perceptive hash will likely trigger this rule. To quickly terminate the jvm without delay please call ConcurrencyUtils.shutdownThreadPoolAndAwaitTermination(); manually once you are done computing perceptive hashes");
        }
    }

    @Override
    protected BigInteger hash(BufferedImage image, HashBuilder hash) {
        int j;
        int i;
        FastPixel fp = this.createPixelAccessor(image, this.width, this.height);
        int[][] lum = fp.getLuma();
        double[][] lumAsDouble = new double[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                lumAsDouble[x][y] = (double)lum[x][y] / 255.0;
            }
        }
        DoubleDCT_2D dct = new DoubleDCT_2D((long)this.width, (long)this.height);
        dct.forward(lumAsDouble, false);
        double avg = 0.0;
        int subWidth = (int)((double)this.width / 4.0);
        int subHeight = (int)((double)this.height / 4.0);
        int count = subWidth * subHeight;
        for (i = 1; i < subWidth + 1; ++i) {
            for (j = 1; j < subHeight + 1; ++j) {
                avg += lumAsDouble[i][j] / (double)count;
            }
        }
        for (i = 1; i < subWidth + 1; ++i) {
            for (j = 1; j < subHeight + 1; ++j) {
                if (lumAsDouble[i][j] < avg) {
                    hash.prependZero();
                    continue;
                }
                hash.prependOne();
            }
        }
        return hash.toBigInteger();
    }

    private void computeDimensions(int bitResolution) {
        int dimension = (int)Math.round(Math.sqrt(bitResolution)) * 4;
        int normalBound = dimension / 4 * (dimension / 4);
        int higherBound = dimension / 4 * (dimension / 4 + 1);
        this.width = dimension;
        this.height = dimension;
        if (higherBound < bitResolution) {
            ++this.width;
            ++this.height;
        } else if (normalBound < bitResolution || normalBound - bitResolution > higherBound - bitResolution) {
            this.height += 4;
        }
    }

    @Override
    protected int precomputeAlgoId() {
        return Objects.hash("com.github.kilianB.hashAlgorithms." + this.getClass().getSimpleName(), this.height, this.width) * 31 + 1;
    }
}

