/*
 * Decompiled with CFR 0.152.
 */
package dev.brachtendorf.jimagehash.hash;

import dev.brachtendorf.Require;
import dev.brachtendorf.StringUtil;
import dev.brachtendorf.graphics.FastPixel;
import dev.brachtendorf.jimagehash.hash.FuzzyHash;
import dev.brachtendorf.jimagehash.hashAlgorithms.HashingAlgorithm;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import javafx.scene.paint.Color;

public class Hash
implements Serializable {
    private static final long serialVersionUID = 3045682506632674223L;
    protected int algorithmId;
    protected BigInteger hashValue;
    protected int hashLength;

    public Hash(BigInteger hashValue, int hashLength, int algorithmId) {
        this.hashValue = hashValue;
        this.algorithmId = algorithmId;
        this.hashLength = hashLength;
    }

    public int hammingDistance(Hash h) {
        if (this.algorithmId != h.algorithmId) {
            throw new IllegalArgumentException("Can't compare two hash values created by different algorithms");
        }
        return this.hammingDistanceFast(h);
    }

    public int hammingDistanceFast(Hash h) {
        return this.hashValue.xor(h.getHashValue()).bitCount();
    }

    public int hammingDistanceFast(BigInteger bInt) {
        return this.hashValue.xor(bInt).bitCount();
    }

    public double normalizedHammingDistance(Hash h) {
        if (this.algorithmId != h.algorithmId) {
            throw new IllegalArgumentException("Can't compare two hash values created by different algorithms");
        }
        return this.normalizedHammingDistanceFast(h);
    }

    public double normalizedHammingDistanceFast(Hash h) {
        return (double)this.hammingDistanceFast(h) / (double)this.hashLength;
    }

    public boolean getBit(int position) {
        Require.inRange((Number)position, (Number)0, (Number)(this.getBitResolution() - 1), (String)"Bit out of bounds");
        return this.getBitUnsafe(position);
    }

    public boolean getBitUnsafe(int position) {
        return this.hashValue.testBit(position);
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    public BigInteger getHashValue() {
        return this.hashValue;
    }

    public BufferedImage toImage(int blockSize) {
        Color[] colorArr = new Color[]{Color.WHITE, Color.BLACK};
        int[] colorIndex = new int[this.hashLength];
        for (int i = 0; i < this.hashLength; ++i) {
            colorIndex[i] = this.hashValue.testBit(i) ? 1 : 0;
        }
        return this.toImage(colorIndex, colorArr, blockSize);
    }

    public BufferedImage toImage(int blockSize, HashingAlgorithm hasher) {
        return hasher.createAlgorithmSpecificHash(this).toImage(blockSize);
    }

    public BufferedImage toImage(int[] bitColorIndex, Color[] colors, int blockSize) {
        int width;
        int height = width = (int)Math.sqrt(this.hashLength);
        BufferedImage bi = new BufferedImage(blockSize * width, blockSize * height, 5);
        FastPixel fp = FastPixel.create((BufferedImage)bi);
        int i = 0;
        for (int w = 0; w < width * blockSize; w += blockSize) {
            for (int h = 0; h < height * blockSize; h += blockSize) {
                Color c = colors[bitColorIndex[i++]];
                int red = (int)(c.getRed() * 255.0);
                int green = (int)(c.getGreen() * 255.0);
                int blue = (int)(c.getBlue() * 255.0);
                for (int m = 0; m < blockSize; ++m) {
                    for (int n = 0; n < blockSize; ++n) {
                        int x = w + m;
                        int y = h + n;
                        fp.setRed(x, y, red);
                        fp.setGreen(x, y, green);
                        fp.setBlue(x, y, blue);
                    }
                }
            }
        }
        return bi;
    }

    public int getBitResolution() {
        return this.hashLength;
    }

    public void toFile(File saveLocation) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveLocation));){
            oos.writeObject(this);
        }
    }

    public static Hash fromFile(File source) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(source));){
            Object o = ois.readObject();
            if (o.getClass() == FuzzyHash.class) {
                FuzzyHash fuzzyHash = FuzzyHash.fromFile(source);
                return fuzzyHash;
            }
            Hash hash = (Hash)o;
            return hash;
        }
    }

    public byte[] toByteArray() {
        byte[] bArray = this.hashValue.toByteArray();
        if (bArray[0] != 0) {
            return bArray;
        }
        byte[] bArrayWithoutSign = new byte[bArray.length - 1];
        System.arraycopy(bArray, 1, bArrayWithoutSign, 0, bArray.length - 1);
        return bArrayWithoutSign;
    }

    public String toString() {
        return "Hash: " + StringUtil.fillStringBeginning((String)"0", (int)this.hashLength, (String)this.hashValue.toString(2)) + " [algoId: " + this.algorithmId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.algorithmId;
        result = 31 * result + (this.hashValue == null ? 0 : this.hashValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hash other = (Hash)obj;
        if (this.algorithmId != other.getAlgorithmId()) {
            return false;
        }
        return !(this.hashValue == null ? other.hashValue != null : !this.hashValue.equals(other.getHashValue()));
    }
}

